/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.AbstractHandlerMethodMapping;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class SpringWebFluxProvider
extends SpringWebProvider {
    public String findPathPrefix(SpringDocConfigProperties springDocConfigProperties) {
        Map map = this.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            Set<String> patterns = this.getActivePatterns(requestMappingInfo);
            if (CollectionUtils.isEmpty(patterns)) continue;
            for (String operationPath : patterns) {
                if (!operationPath.endsWith(springDocConfigProperties.getApiDocs().getPath())) continue;
                return operationPath.replace(springDocConfigProperties.getApiDocs().getPath(), "");
            }
        }
        return "";
    }

    public Set<String> getActivePatterns(Object requestMapping) {
        RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMapping;
        PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
        return patternsRequestCondition.getPatterns().stream().map(PathPattern::getPatternString).collect(Collectors.toSet());
    }

    public Map getHandlerMethods() {
        if (this.handlerMethods == null) {
            Map beansOfTypeRequestMappingHandlerMapping = this.applicationContext.getBeansOfType(RequestMappingHandlerMapping.class);
            this.handlerMethods = beansOfTypeRequestMappingHandlerMapping.values().stream().map(AbstractHandlerMethodMapping::getHandlerMethods).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1, LinkedHashMap::new));
        }
        return this.handlerMethods;
    }
}

