/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ImagePlatform {
    private final String os;
    private final String architecture;
    private final String variant;

    ImagePlatform(String os, String architecture, String variant) {
        Assert.hasText((String)os, (String)"OS must not be empty");
        this.os = os;
        this.architecture = architecture;
        this.variant = variant;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImagePlatform other = (ImagePlatform)obj;
        return Objects.equals(this.architecture, other.architecture) && Objects.equals(this.os, other.os) && Objects.equals(this.variant, other.variant);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.os, this.variant);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.os);
        if (this.architecture != null) {
            builder.append("/").append(this.architecture);
        }
        if (this.variant != null) {
            builder.append("/").append(this.variant);
        }
        return builder.toString();
    }

    public static ImagePlatform of(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        String[] split = value.split("/+");
        return switch (split.length) {
            case 1 -> new ImagePlatform(split[0], null, null);
            case 2 -> new ImagePlatform(split[0], split[1], null);
            case 3 -> new ImagePlatform(split[0], split[1], split[2]);
            default -> throw new IllegalArgumentException("ImagePlatform value '" + value + "' must be in the form of os[/architecture[/variant]]");
        };
    }

    public static ImagePlatform from(Image image) {
        return new ImagePlatform(image.getOs(), image.getArchitecture(), image.getVariant());
    }

    public String toJson() {
        ObjectNode json = SharedObjectMapper.get().createObjectNode();
        json.put("os", this.os);
        if (StringUtils.hasText((String)this.architecture)) {
            json.put("architecture", this.architecture);
        }
        if (StringUtils.hasText((String)this.variant)) {
            json.put("variant", this.variant);
        }
        return json.toString();
    }
}

