/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        this(method, em, method.getAnnotatedQuery(), evaluationContextProvider, parser);
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em, queryString, evaluationContextProvider, parser);
        this.validateQuery(this.getQuery().getQueryString(), "Validation failed for query for method %s!", new Object[]{method});
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s!", new Object[]{method}), new Object[0]);
        }
    }

    private void validateQuery(String query, String errorMessage, Object ... arguments) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        EntityManager validatingEm = null;
        try {
            validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format(errorMessage, arguments), e);
        }
        finally {
            if (validatingEm != null) {
                validatingEm.close();
            }
        }
    }
}

