/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationException;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.ClassPathJaxb2TypeScanner;
import org.springframework.oxm.mime.MimeContainer;
import org.springframework.oxm.mime.MimeMarshaller;
import org.springframework.oxm.mime.MimeUnmarshaller;
import org.springframework.oxm.support.SaxResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Jaxb2Marshaller
implements MimeMarshaller,
MimeUnmarshaller,
GenericMarshaller,
GenericUnmarshaller,
BeanClassLoaderAware,
InitializingBean {
    private static final String CID = "cid:";
    private static final EntityResolver NO_OP_ENTITY_RESOLVER = (publicId, systemId) -> new InputSource(new StringReader(""));
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private String contextPath;
    @Nullable
    private Class<?>[] classesToBeBound;
    @Nullable
    private String[] packagesToScan;
    @Nullable
    private Map<String, ?> jaxbContextProperties;
    @Nullable
    private Map<String, ?> marshallerProperties;
    @Nullable
    private Map<String, ?> unmarshallerProperties;
    @Nullable
    private Marshaller.Listener marshallerListener;
    @Nullable
    private Unmarshaller.Listener unmarshallerListener;
    @Nullable
    private ValidationEventHandler validationEventHandler;
    @Nullable
    private XmlAdapter<?, ?>[] adapters;
    @Nullable
    private Resource[] schemaResources;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    @Nullable
    private LSResourceResolver schemaResourceResolver;
    private boolean lazyInit = false;
    private boolean mtomEnabled = false;
    private boolean supportJaxbElementClass = false;
    private boolean checkForXmlRootElement = true;
    @Nullable
    private Class<?> mappedClass;
    @Nullable
    private ClassLoader beanClassLoader;
    private final Object jaxbContextMonitor = new Object();
    @Nullable
    private volatile JAXBContext jaxbContext;
    @Nullable
    private Schema schema;
    private boolean supportDtd = false;
    private boolean processExternalEntities = false;

    public void setContextPaths(String ... contextPaths) {
        Assert.notEmpty((Object[])contextPaths, (String)"'contextPaths' must not be empty");
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
    }

    public void setContextPath(@Nullable String contextPath) {
        this.contextPath = contextPath;
    }

    @Nullable
    public String getContextPath() {
        return this.contextPath;
    }

    public void setClassesToBeBound(Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
    }

    @Nullable
    public Class<?>[] getClassesToBeBound() {
        return this.classesToBeBound;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Nullable
    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setJaxbContextProperties(Map<String, ?> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public void setMarshallerProperties(Map<String, ?> properties) {
        this.marshallerProperties = properties;
    }

    public void setUnmarshallerProperties(Map<String, ?> properties) {
        this.unmarshallerProperties = properties;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setAdapters(XmlAdapter<?, ?> ... adapters) {
        this.adapters = adapters;
    }

    public void setSchema(Resource schemaResource) {
        this.schemaResources = new Resource[]{schemaResource};
    }

    public void setSchemas(Resource ... schemaResources) {
        this.schemaResources = schemaResources;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void setSchemaResourceResolver(LSResourceResolver schemaResourceResolver) {
        this.schemaResourceResolver = schemaResourceResolver;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setSupportJaxbElementClass(boolean supportJaxbElementClass) {
        this.supportJaxbElementClass = supportJaxbElementClass;
    }

    public void setCheckForXmlRootElement(boolean checkForXmlRootElement) {
        this.checkForXmlRootElement = checkForXmlRootElement;
    }

    public void setMappedClass(Class<?> mappedClass) {
        this.mappedClass = mappedClass;
    }

    public void setSupportDtd(boolean supportDtd) {
        this.supportDtd = supportDtd;
    }

    public boolean isSupportDtd() {
        return this.supportDtd;
    }

    public void setProcessExternalEntities(boolean processExternalEntities) {
        this.processExternalEntities = processExternalEntities;
        if (processExternalEntities) {
            this.supportDtd = true;
        }
    }

    public boolean isProcessExternalEntities() {
        return this.processExternalEntities;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        boolean hasPackagesToScan;
        boolean hasContextPath = StringUtils.hasLength((String)this.contextPath);
        boolean hasClassesToBeBound = !ObjectUtils.isEmpty((Object[])this.classesToBeBound);
        boolean bl = hasPackagesToScan = !ObjectUtils.isEmpty((Object[])this.packagesToScan);
        if (hasContextPath && (hasClassesToBeBound || hasPackagesToScan) || hasClassesToBeBound && hasPackagesToScan) {
            throw new IllegalArgumentException("Specify either 'contextPath', 'classesToBeBound', or 'packagesToScan'");
        }
        if (!(hasContextPath || hasClassesToBeBound || hasPackagesToScan)) {
            throw new IllegalArgumentException("Setting either 'contextPath', 'classesToBeBound', or 'packagesToScan' is required");
        }
        if (!this.lazyInit) {
            this.getJaxbContext();
        }
        if (!ObjectUtils.isEmpty((Object[])this.schemaResources)) {
            this.schema = this.loadSchema(this.schemaResources, this.schemaLanguage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext() {
        JAXBContext context = this.jaxbContext;
        if (context != null) {
            return context;
        }
        Object object = this.jaxbContextMonitor;
        synchronized (object) {
            context = this.jaxbContext;
            if (context == null) {
                try {
                    context = StringUtils.hasLength((String)this.contextPath) ? this.createJaxbContextFromContextPath(this.contextPath) : (!ObjectUtils.isEmpty((Object[])this.classesToBeBound) ? this.createJaxbContextFromClasses(this.classesToBeBound) : (!ObjectUtils.isEmpty((Object[])this.packagesToScan) ? this.createJaxbContextFromPackages(this.packagesToScan) : JAXBContext.newInstance((Class[])new Class[0])));
                    this.jaxbContext = context;
                }
                catch (JAXBException ex) {
                    throw this.convertJaxbException(ex);
                }
            }
            return context;
        }
    }

    private JAXBContext createJaxbContextFromContextPath(String contextPath) throws JAXBException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating JAXBContext with context path [" + this.contextPath + "]"));
        }
        if (this.jaxbContextProperties != null) {
            if (this.beanClassLoader != null) {
                return JAXBContext.newInstance((String)contextPath, (ClassLoader)this.beanClassLoader, this.jaxbContextProperties);
            }
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)Thread.currentThread().getContextClassLoader(), this.jaxbContextProperties);
        }
        if (this.beanClassLoader != null) {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)this.beanClassLoader);
        }
        return JAXBContext.newInstance((String)contextPath);
    }

    private JAXBContext createJaxbContextFromClasses(Class<?> ... classesToBeBound) throws JAXBException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating JAXBContext with classes to be bound [" + StringUtils.arrayToCommaDelimitedString((Object[])classesToBeBound) + "]"));
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])classesToBeBound, this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])classesToBeBound);
    }

    private JAXBContext createJaxbContextFromPackages(String ... packagesToScan) throws JAXBException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating JAXBContext by scanning packages [" + StringUtils.arrayToCommaDelimitedString((Object[])packagesToScan) + "]"));
        }
        ClassPathJaxb2TypeScanner scanner = new ClassPathJaxb2TypeScanner(this.beanClassLoader, packagesToScan);
        Object[] jaxb2Classes = scanner.scanPackages();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found JAXB2 classes: [" + StringUtils.arrayToCommaDelimitedString((Object[])jaxb2Classes) + "]"));
        }
        this.classesToBeBound = jaxb2Classes;
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])jaxb2Classes, this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])jaxb2Classes);
    }

    private Schema loadSchema(Resource[] resources, String schemaLanguage) throws IOException, SAXException, ParserConfigurationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting validation schema to " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemaResources)));
        }
        Assert.notEmpty((Object[])resources, (String)"No resources given");
        Assert.hasLength((String)schemaLanguage, (String)"No schema language provided");
        Source[] schemaSources = new Source[resources.length];
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            Assert.isTrue((resource != null && resource.exists() ? 1 : 0) != 0, () -> "Resource does not exist: " + resource);
            InputSource inputSource = SaxResourceUtils.createInputSource(resource);
            schemaSources[i] = new SAXSource(xmlReader, inputSource);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        if (this.schemaResourceResolver != null) {
            schemaFactory.setResourceResolver(this.schemaResourceResolver);
        }
        return schemaFactory.newSchema(schemaSources);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.supportJaxbElementClass && JAXBElement.class.isAssignableFrom(clazz) || this.supportsInternal(clazz, this.checkForXmlRootElement);
    }

    @Override
    public boolean supports(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            if (JAXBElement.class == parameterizedType.getRawType() && parameterizedType.getActualTypeArguments().length == 1) {
                Type typeArgument = parameterizedType.getActualTypeArguments()[0];
                if (typeArgument instanceof Class) {
                    Class classArgument = (Class)typeArgument;
                    return classArgument.isArray() && Byte.TYPE == classArgument.getComponentType() || this.isPrimitiveWrapper(classArgument) || this.isStandardClass(classArgument) || this.supportsInternal(classArgument, false);
                }
                if (typeArgument instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)typeArgument;
                    return Byte.TYPE == arrayType.getGenericComponentType();
                }
            }
        } else if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            return this.supportsInternal(clazz, this.checkForXmlRootElement);
        }
        return false;
    }

    private boolean supportsInternal(Class<?> clazz, boolean checkForXmlRootElement) {
        if (checkForXmlRootElement && AnnotationUtils.findAnnotation(clazz, XmlRootElement.class) == null) {
            return false;
        }
        if (StringUtils.hasLength((String)this.contextPath)) {
            String[] contextPaths;
            String packageName = ClassUtils.getPackageName(clazz);
            for (String contextPath : contextPaths = StringUtils.tokenizeToStringArray((String)this.contextPath, (String)":")) {
                if (!contextPath.equals(packageName)) continue;
                return true;
            }
            return false;
        }
        if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            return Arrays.asList(this.classesToBeBound).contains(clazz);
        }
        return false;
    }

    private boolean isPrimitiveWrapper(Class<?> clazz) {
        return Boolean.class == clazz || Byte.class == clazz || Short.class == clazz || Integer.class == clazz || Long.class == clazz || Float.class == clazz || Double.class == clazz;
    }

    private boolean isStandardClass(Class<?> clazz) {
        return String.class == clazz || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || QName.class.isAssignableFrom(clazz) || URI.class == clazz || XMLGregorianCalendar.class.isAssignableFrom(clazz) || Duration.class.isAssignableFrom(clazz) || Image.class == clazz || DataHandler.class == clazz || UUID.class == clazz;
    }

    @Override
    public void marshal(Object graph, Result result) throws XmlMappingException {
        this.marshal(graph, result, null);
    }

    @Override
    public void marshal(Object graph, Result result, @Nullable MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Marshaller marshaller = this.createMarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                marshaller.setAttachmentMarshaller((AttachmentMarshaller)new Jaxb2AttachmentMarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxResult((Result)result)) {
                this.marshalStaxResult(marshaller, graph, result);
            } else {
                marshaller.marshal(graph, result);
            }
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    public Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            this.initJaxbMarshaller(marshaller);
            return marshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private void marshalStaxResult(Marshaller jaxbMarshaller, Object graph, Result staxResult) throws JAXBException {
        XMLStreamWriter streamWriter = StaxUtils.getXMLStreamWriter((Result)staxResult);
        if (streamWriter != null) {
            jaxbMarshaller.marshal(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = StaxUtils.getXMLEventWriter((Result)staxResult);
            if (eventWriter != null) {
                jaxbMarshaller.marshal(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StAX Result contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    protected void initJaxbMarshaller(Marshaller marshaller) throws JAXBException {
        if (this.marshallerProperties != null) {
            for (Map.Entry<String, ?> entry : this.marshallerProperties.entrySet()) {
                marshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        if (this.validationEventHandler != null) {
            marshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                marshaller.setAdapter(adapter);
            }
        }
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
    }

    @Override
    public Object unmarshal(Source source) throws XmlMappingException {
        return this.unmarshal(source, null);
    }

    @Override
    public Object unmarshal(Source source, @Nullable MimeContainer mimeContainer) throws XmlMappingException {
        source = this.processSource(source);
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new Jaxb2AttachmentUnmarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxSource((Source)source)) {
                return this.unmarshalStaxSource(unmarshaller, source);
            }
            if (this.mappedClass != null) {
                return unmarshaller.unmarshal(source, this.mappedClass).getValue();
            }
            return unmarshaller.unmarshal(source);
        }
        catch (NullPointerException ex) {
            if (!this.isSupportDtd()) {
                throw new UnmarshallingFailureException("NPE while unmarshalling: This can happen due to the presence of DTD declarations which are disabled.", ex);
            }
            throw ex;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    public Unmarshaller createUnmarshaller() {
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            this.initJaxbUnmarshaller(unmarshaller);
            return unmarshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected Object unmarshalStaxSource(Unmarshaller jaxbUnmarshaller, Source staxSource) throws JAXBException {
        XMLStreamReader streamReader = StaxUtils.getXMLStreamReader((Source)staxSource);
        if (streamReader != null) {
            return this.mappedClass != null ? jaxbUnmarshaller.unmarshal(streamReader, this.mappedClass).getValue() : jaxbUnmarshaller.unmarshal(streamReader);
        }
        XMLEventReader eventReader = StaxUtils.getXMLEventReader((Source)staxSource);
        if (eventReader != null) {
            return this.mappedClass != null ? jaxbUnmarshaller.unmarshal(eventReader, this.mappedClass).getValue() : jaxbUnmarshaller.unmarshal(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    private Source processSource(Source source) {
        if (StaxUtils.isStaxSource((Source)source) || source instanceof DOMSource) {
            return source;
        }
        XMLReader xmlReader = null;
        InputSource inputSource = null;
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            xmlReader = saxSource.getXMLReader();
            inputSource = saxSource.getInputSource();
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            inputSource = streamSource.getInputStream() != null ? new InputSource(streamSource.getInputStream()) : (streamSource.getReader() != null ? new InputSource(streamSource.getReader()) : new InputSource(streamSource.getSystemId()));
        }
        try {
            if (xmlReader == null) {
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setNamespaceAware(true);
                saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", !this.isSupportDtd());
                String name = "http://xml.org/sax/features/external-general-entities";
                saxParserFactory.setFeature(name, this.isProcessExternalEntities());
                SAXParser saxParser = saxParserFactory.newSAXParser();
                xmlReader = saxParser.getXMLReader();
            }
            if (!this.isProcessExternalEntities()) {
                xmlReader.setEntityResolver(NO_OP_ENTITY_RESOLVER);
            }
            return new SAXSource(xmlReader, inputSource);
        }
        catch (ParserConfigurationException | SAXException ex) {
            this.logger.info((Object)"Processing of external entities could not be disabled", (Throwable)ex);
            return source;
        }
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        if (this.unmarshallerProperties != null) {
            for (Map.Entry<String, ?> entry : this.unmarshallerProperties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.validationEventHandler != null) {
            unmarshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                unmarshaller.setAdapter(adapter);
            }
        }
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
    }

    protected XmlMappingException convertJaxbException(JAXBException ex) {
        if (ex instanceof ValidationException) {
            return new ValidationFailureException("JAXB validation exception", ex);
        }
        if (ex instanceof MarshalException) {
            return new MarshallingFailureException("JAXB marshalling exception", ex);
        }
        if (ex instanceof UnmarshalException) {
            return new UnmarshallingFailureException("JAXB unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown JAXB exception", ex);
    }

    private static class Jaxb2AttachmentMarshaller
    extends AttachmentMarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentMarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(mimeType, data, offset, length);
            return this.addMtomAttachment(new DataHandler((DataSource)dataSource), elementNamespace, elementLocalName);
        }

        public String addMtomAttachment(DataHandler dataHandler, String elementNamespace, String elementLocalName) {
            String host = this.getHost(elementNamespace, dataHandler);
            Object contentId = UUID.randomUUID() + "@" + host;
            this.mimeContainer.addAttachment("<" + (String)contentId + ">", dataHandler);
            contentId = URLEncoder.encode((String)contentId, StandardCharsets.UTF_8);
            return Jaxb2Marshaller.CID + (String)contentId;
        }

        private String getHost(String elementNamespace, DataHandler dataHandler) {
            try {
                URI uri = ResourceUtils.toURI((String)elementNamespace);
                return uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                return dataHandler.getName();
            }
        }

        public String addSwaRefAttachment(DataHandler dataHandler) {
            String contentId = UUID.randomUUID() + "@" + dataHandler.getName();
            this.mimeContainer.addAttachment(contentId, dataHandler);
            return contentId;
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.convertToXopPackage();
        }
    }

    private static class Jaxb2AttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentUnmarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            try {
                DataHandler dataHandler = this.getAttachmentAsDataHandler(cid);
                return FileCopyUtils.copyToByteArray((InputStream)dataHandler.getInputStream());
            }
            catch (IOException ex) {
                throw new UnmarshallingFailureException("Could not read attachment", ex);
            }
        }

        public DataHandler getAttachmentAsDataHandler(String contentId) {
            DataHandler dataHandler;
            if (((String)contentId).startsWith(Jaxb2Marshaller.CID)) {
                contentId = ((String)contentId).substring(Jaxb2Marshaller.CID.length());
                contentId = URLDecoder.decode((String)contentId, StandardCharsets.UTF_8);
                contentId = "<" + (String)contentId + ">";
            }
            if ((dataHandler = this.mimeContainer.getAttachment((String)contentId)) == null) {
                throw new IllegalArgumentException("No attachment found for " + (String)contentId);
            }
            return dataHandler;
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.isXopPackage();
        }
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private final byte[] data;
        private final String contentType;
        private final int offset;
        private final int length;

        public ByteArrayDataSource(String contentType, byte[] data, int offset, int length) {
            this.contentType = contentType;
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data, this.offset, this.length);
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }
}

