/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.List;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class BeanOverrideTestExecutionListener
extends AbstractTestExecutionListener {
    public static final int ORDER = 1950;

    @Override
    public int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        BeanOverrideTestExecutionListener.injectFields(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        Object reinjectDependenciesAttribute = testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE);
        if (Boolean.TRUE.equals(reinjectDependenciesAttribute)) {
            BeanOverrideTestExecutionListener.injectFields(testContext);
        }
    }

    private static void injectFields(TestContext testContext) {
        List<BeanOverrideHandler> handlers = BeanOverrideHandler.forTestClass(testContext.getTestClass());
        if (!handlers.isEmpty()) {
            Object testInstance = testContext.getTestInstance();
            BeanOverrideRegistry beanOverrideRegistry = (BeanOverrideRegistry)testContext.getApplicationContext().getBean("org.springframework.test.context.bean.override.internalBeanOverrideRegistry", BeanOverrideRegistry.class);
            for (BeanOverrideHandler handler : handlers) {
                beanOverrideRegistry.inject(testInstance, handler);
            }
        }
    }
}

