/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.core.token;

import com.zhipu.oapi.core.Config;
import com.zhipu.oapi.core.cache.ICache;
import com.zhipu.oapi.utils.StringUtils;
import com.zhipu.oapi.utils.WuDaoUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger log = LoggerFactory.getLogger(TokenManager.class);
    private static final int expireSeconds = 28790;
    private static final String TokenKeyPrefix = "zhipu_oapi_token";
    private static final String GetTokenUrl = "https://maas.aminer.cn/api/paas/passApiToken/createApiToken";
    private ICache cache;

    public TokenManager(ICache cache) {
        this.cache = cache;
    }

    public String getToken(Config config) throws Exception {
        String key = this.genTokenCacheKey(config.getApiKey());
        String cacheToken = this.cache.get(key);
        if (!StringUtils.isEmpty(cacheToken)) {
            return cacheToken;
        }
        String token = this.getTokenFromServer(config);
        if (StringUtils.isEmpty(token)) {
            log.error("get token fail, token is empty!");
            return token;
        }
        this.cache.set(key, token, 28790, TimeUnit.SECONDS);
        return token;
    }

    private String genTokenCacheKey(String apiKey) {
        return String.format("%s-%s", TokenKeyPrefix, apiKey);
    }

    private String getTokenFromServer(Config config) throws Exception {
        Map<String, Object> resultMap = WuDaoUtils.getToken(GetTokenUrl, config.getApiKey(), config.getPubKey());
        Double code = (Double)resultMap.get("code");
        if (code.intValue() == 200) {
            String token = String.valueOf(resultMap.get("data"));
            return token;
        }
        log.error("get token fail! code: %s, msg: %s", (Object)code.intValue(), resultMap.get("msg"));
        return null;
    }

    public ICache getCache() {
        return this.cache;
    }

    public void setCache(ICache cache) {
        this.cache = cache;
    }
}

