/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.yun.core.json;

import com.baidu.yun.core.json.JSONParserConstants;
import com.baidu.yun.core.json.JSONParserTokenManager;
import com.baidu.yun.core.json.ParseException;
import com.baidu.yun.core.json.SimpleCharStream;
import com.baidu.yun.core.json.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONParser
implements JSONParserConstants {
    public JSONParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public JSONParser() {
        this(new StringReader(""));
    }

    public Map parser(String json) throws ParseException {
        this.ReInit(new StringReader(json));
        return this.object();
    }

    public final Map object() throws ParseException {
        Object value;
        String key;
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.jj_consume_token(18);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                key = this.key();
                this.jj_consume_token(19);
                value = this.value();
                map.put(key, value);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(20);
            key = this.key();
            this.jj_consume_token(19);
            value = this.value();
            map.put(key, value);
        }
        this.jj_consume_token(21);
        return map;
    }

    public final String key() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token t = this.jj_consume_token(15);
                return t.image;
            }
            case 14: {
                String value = this.string();
                return value;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Number number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Token t = this.jj_consume_token(8);
                char lastChar = t.image.charAt(t.image.length() - 1);
                if (lastChar == 'l' || lastChar == 'L') {
                    return Long.parseLong(t.image);
                }
                return Long.parseLong(t.image);
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                char lastChar = t.image.charAt(t.image.length() - 1);
                if (lastChar == 'f' || lastChar == 'F') {
                    return Float.valueOf(Float.parseFloat(t.image));
                }
                return Double.parseDouble(t.image);
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string() throws ParseException {
        Token t = this.jj_consume_token(14);
        return t.image.substring(1, t.image.length() - 1);
    }

    public final Object value() throws ParseException {
        Object obj;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                obj = this.string();
                break;
            }
            case 8: 
            case 12: {
                obj = this.number();
                break;
            }
            case 18: {
                obj = this.object();
                break;
            }
            case 22: {
                obj = this.array();
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                obj = true;
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                obj = false;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                obj = null;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return obj;
    }

    public final List array() throws ParseException {
        Object obj;
        ArrayList<Object> list = new ArrayList<Object>();
        this.jj_consume_token(22);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 22: {
                obj = this.value();
                list.add(obj);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(20);
            obj = this.value();
            list.add(obj);
        }
        this.jj_consume_token(23);
        return list;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{49152, 0x100000, 49152, 4352, 4477408, 4477408, 0x100000};
    }

    public JSONParser(InputStream stream) {
        this(stream, null);
    }

    public JSONParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JSONParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JSONParser(JSONParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JSONParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[24];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 7; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 24; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JSONParser.jj_la1_init_0();
    }
}

