/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.analysis.v03;

import cn.idev.excel.analysis.ExcelReadExecutor;
import cn.idev.excel.analysis.v03.IgnorableXlsRecordHandler;
import cn.idev.excel.analysis.v03.XlsListSheetListener;
import cn.idev.excel.analysis.v03.XlsRecordHandler;
import cn.idev.excel.analysis.v03.handlers.BlankRecordHandler;
import cn.idev.excel.analysis.v03.handlers.BofRecordHandler;
import cn.idev.excel.analysis.v03.handlers.BoolErrRecordHandler;
import cn.idev.excel.analysis.v03.handlers.BoundSheetRecordHandler;
import cn.idev.excel.analysis.v03.handlers.DummyRecordHandler;
import cn.idev.excel.analysis.v03.handlers.EofRecordHandler;
import cn.idev.excel.analysis.v03.handlers.FormulaRecordHandler;
import cn.idev.excel.analysis.v03.handlers.HyperlinkRecordHandler;
import cn.idev.excel.analysis.v03.handlers.IndexRecordHandler;
import cn.idev.excel.analysis.v03.handlers.LabelRecordHandler;
import cn.idev.excel.analysis.v03.handlers.LabelSstRecordHandler;
import cn.idev.excel.analysis.v03.handlers.MergeCellsRecordHandler;
import cn.idev.excel.analysis.v03.handlers.NoteRecordHandler;
import cn.idev.excel.analysis.v03.handlers.NumberRecordHandler;
import cn.idev.excel.analysis.v03.handlers.ObjRecordHandler;
import cn.idev.excel.analysis.v03.handlers.RkRecordHandler;
import cn.idev.excel.analysis.v03.handlers.SstRecordHandler;
import cn.idev.excel.analysis.v03.handlers.StringRecordHandler;
import cn.idev.excel.analysis.v03.handlers.TextObjectRecordHandler;
import cn.idev.excel.context.xls.XlsReadContext;
import cn.idev.excel.exception.ExcelAnalysisException;
import cn.idev.excel.exception.ExcelAnalysisStopException;
import cn.idev.excel.exception.ExcelAnalysisStopSheetException;
import cn.idev.excel.read.metadata.ReadSheet;
import cn.idev.excel.read.metadata.holder.xls.XlsReadWorkbookHolder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsSaxAnalyser
implements HSSFListener,
ExcelReadExecutor {
    private static final Logger log = LoggerFactory.getLogger(XlsSaxAnalyser.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsSaxAnalyser.class);
    private static final short DUMMY_RECORD_SID = -1;
    private final XlsReadContext xlsReadContext;
    private static final Map<Short, XlsRecordHandler> XLS_RECORD_HANDLER_MAP = new HashMap<Short, XlsRecordHandler>(32);

    public XlsSaxAnalyser(XlsReadContext xlsReadContext) {
        this.xlsReadContext = xlsReadContext;
    }

    @Override
    public List<ReadSheet> sheetList() {
        block3: {
            try {
                if (this.xlsReadContext.readWorkbookHolder().getActualSheetDataList() == null) {
                    new XlsListSheetListener(this.xlsReadContext).execute();
                }
            }
            catch (ExcelAnalysisStopException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Custom stop!");
            }
        }
        return this.xlsReadContext.readWorkbookHolder().getActualSheetDataList();
    }

    @Override
    public void execute() {
        XlsReadWorkbookHolder xlsReadWorkbookHolder = this.xlsReadContext.xlsReadWorkbookHolder();
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        xlsReadWorkbookHolder.setFormatTrackingHSSFListener(new FormatTrackingHSSFListener((HSSFListener)listener));
        EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)xlsReadWorkbookHolder.getFormatTrackingHSSFListener());
        xlsReadWorkbookHolder.setHssfWorkbook(workbookBuildingListener.getStubHSSFWorkbook());
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)xlsReadWorkbookHolder.getFormatTrackingHSSFListener());
        try {
            factory.processWorkbookEvents(request, xlsReadWorkbookHolder.getPoifsFileSystem());
        }
        catch (IOException e) {
            throw new ExcelAnalysisException(e);
        }
        this.xlsReadContext.analysisEventProcessor().endSheet(this.xlsReadContext);
    }

    public void processRecord(Record record) {
        boolean ignoreRecord;
        XlsRecordHandler handler = XLS_RECORD_HANDLER_MAP.get(record.getSid());
        if (handler == null) {
            return;
        }
        boolean bl = ignoreRecord = handler instanceof IgnorableXlsRecordHandler && this.xlsReadContext.xlsReadWorkbookHolder().getIgnoreRecord() != false;
        if (ignoreRecord) {
            return;
        }
        if (!handler.support(this.xlsReadContext, record)) {
            return;
        }
        try {
            handler.processRecord(this.xlsReadContext, record);
        }
        catch (ExcelAnalysisStopSheetException e) {
            if (log.isDebugEnabled()) {
                log.debug("Custom stop!", (Throwable)e);
            }
            this.xlsReadContext.xlsReadWorkbookHolder().setIgnoreRecord(Boolean.TRUE);
            this.xlsReadContext.xlsReadWorkbookHolder().setCurrentSheetStopped(Boolean.TRUE);
        }
    }

    static {
        XLS_RECORD_HANDLER_MAP.put((short)513, new BlankRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)2057, new BofRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)517, new BoolErrRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)133, new BoundSheetRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)-1, new DummyRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)10, new EofRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)6, new FormulaRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)440, new HyperlinkRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)523, new IndexRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)516, new LabelRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)253, new LabelSstRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)229, new MergeCellsRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)28, new NoteRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)515, new NumberRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)93, new ObjRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)638, new RkRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)252, new SstRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)519, new StringRecordHandler());
        XLS_RECORD_HANDLER_MAP.put((short)438, new TextObjectRecordHandler());
    }
}

