/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.support;

import cn.idev.excel.exception.ExcelAnalysisException;
import cn.idev.excel.exception.ExcelCommonException;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.EmptyFileException;
import org.apache.poi.util.IOUtils;

public enum ExcelTypeEnum {
    CSV(".csv", new byte[]{-27, -89, -109, -27}),
    XLS(".xls", new byte[]{-48, -49, 17, -32, -95, -79, 26, -31}),
    XLSX(".xlsx", new byte[]{80, 75, 3, 4});

    final String value;
    final byte[] magic;
    static final int MAX_PATTERN_LENGTH = 8;

    private ExcelTypeEnum(String value, byte[] magic) {
        this.value = value;
        this.magic = magic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExcelTypeEnum valueOf(ReadWorkbook readWorkbook) {
        ExcelTypeEnum excelType = readWorkbook.getExcelType();
        if (excelType != null) {
            return excelType;
        }
        File file = readWorkbook.getFile();
        InputStream inputStream = readWorkbook.getInputStream();
        if (file == null && inputStream == null) {
            throw new ExcelAnalysisException("File and inputStream must be a non-null.");
        }
        try {
            if (file != null) {
                if (!file.exists()) {
                    throw new ExcelAnalysisException("File " + file.getAbsolutePath() + " not exists.");
                }
                if (!StringUtils.isEmpty(readWorkbook.getPassword())) {
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.recognitionExcelType(bufferedInputStream);
                        return excelTypeEnum;
                    }
                }
                String fileName = file.getName();
                if (fileName.endsWith(XLSX.getValue())) {
                    return XLSX;
                }
                if (fileName.endsWith(XLS.getValue())) {
                    return XLS;
                }
                if (fileName.endsWith(CSV.getValue())) {
                    return CSV;
                }
                if (StringUtils.isEmpty(readWorkbook.getPassword())) {
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.recognitionExcelType(bufferedInputStream);
                        return excelTypeEnum;
                    }
                }
            }
            if (inputStream.markSupported()) return ExcelTypeEnum.recognitionExcelType(inputStream);
            inputStream = new BufferedInputStream(inputStream);
            readWorkbook.setInputStream(inputStream);
            return ExcelTypeEnum.recognitionExcelType(inputStream);
        }
        catch (ExcelCommonException e) {
            throw e;
        }
        catch (EmptyFileException e) {
            throw new ExcelCommonException("The supplied file was empty (zero bytes long)");
        }
        catch (Exception e) {
            throw new ExcelCommonException("Convert excel format exception.You can try specifying the 'excelType' yourself", e);
        }
    }

    private static ExcelTypeEnum recognitionExcelType(InputStream inputStream) throws Exception {
        byte[] data = IOUtils.peekFirstNBytes((InputStream)inputStream, (int)8);
        if (ExcelTypeEnum.findMagic(ExcelTypeEnum.XLSX.magic, data)) {
            return XLSX;
        }
        if (ExcelTypeEnum.findMagic(ExcelTypeEnum.XLS.magic, data)) {
            return XLS;
        }
        return CSV;
    }

    private static boolean findMagic(byte[] expected, byte[] actual) {
        int i = 0;
        for (byte expectedByte : expected) {
            if (actual[i++] == expectedByte || expectedByte == 63) continue;
            return false;
        }
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getMagic() {
        return this.magic;
    }
}

