/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.system;

import io.rong.RongCloud;
import io.rong.models.Templates;
import io.rong.models.message.BroadcastMessage;
import io.rong.models.message.MessageModel;
import io.rong.models.message.SystemMessage;
import io.rong.models.message.TemplateMessage;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class MsgSystem {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;
    private static final String PATH = "message/system";
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public MsgSystem(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult send(MessageModel message) throws Exception {
        String body;
        SystemMessage systemMessage = (SystemMessage)message;
        String code = CommonUtil.checkFiled(systemMessage, PATH, "send");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(systemMessage.getSenderId().toString(), UTF8));
        for (int i = 0; i < systemMessage.getTargetId().length; ++i) {
            String child = systemMessage.getTargetId()[i];
            if (null == child) continue;
            sb.append("&toUserId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(systemMessage.getObjectName(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(systemMessage.getContent().toString(), UTF8));
        if (systemMessage.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(systemMessage.getPushContent().toString(), UTF8));
        }
        if (systemMessage.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(systemMessage.getPushData().toString(), UTF8));
        }
        if (systemMessage.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(systemMessage.getIsPersisted().toString(), UTF8));
        }
        if (systemMessage.getIsCounted() != null) {
            sb.append("&isCounted=").append(URLEncoder.encode(systemMessage.getIsCounted().toString(), UTF8));
        }
        if (systemMessage.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(systemMessage.getContentAvailable().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/system/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", CommonUtil.getResponseByCode(PATH, "send", HttpUtil.returnResult(conn))), ResponseResult.class);
    }

    public ResponseResult sendTemplate(TemplateMessage template) throws Exception {
        String code = CommonUtil.checkFiled(template, PATH, "sendTemplate");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        Templates templateMessage = new Templates();
        ArrayList<String> toUserIds = new ArrayList<String>();
        ArrayList<Map<String, String>> values = new ArrayList<Map<String, String>>();
        ArrayList<String> push = new ArrayList<String>();
        for (Map.Entry<String, TemplateMessage.Data> vo : template.getContent().entrySet()) {
            toUserIds.add(vo.getKey());
            values.add(vo.getValue().getData());
            push.add(vo.getValue().getPush());
        }
        templateMessage.setFromUserId(template.getSenderId());
        templateMessage.setToUserId(toUserIds.toArray(new String[toUserIds.size()]));
        templateMessage.setObjectName(template.getObjectName());
        templateMessage.setContent(GsonUtil.toJson(template.getTemplate(), Map.class));
        templateMessage.setValues(values);
        templateMessage.setPushContent(push.toArray(new String[push.size()]));
        templateMessage.setPushData(template.getPushData());
        templateMessage.setContentAvailable(template.getContentAvailable());
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/system/publish_template.json", "application/json");
        HttpUtil.setBodyParameter(templateMessage.toString(), conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sendTemplate", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ResponseResult broadcast(BroadcastMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, PATH, "broadcast");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent().toString(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData().toString(), UTF8));
        }
        if (message.getOs() != null) {
            sb.append("&os=").append(URLEncoder.encode(message.getOs().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/message/broadcast.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "broadcast", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

