/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.provider;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.loginuser.api.LoginUserRemoteApi;
import cn.stylefeng.roses.kernel.auth.api.loginuser.pojo.LoginUserRequest;
import cn.stylefeng.roses.kernel.auth.api.loginuser.pojo.SessionValidateResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserExceptionEnum;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginUserProvider
implements LoginUserRemoteApi {
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private UserServiceApi userServiceApi;

    public LoginUser getLoginUserByToken(@RequestBody LoginUserRequest loginUserRequest) {
        if (StrUtil.isBlank((CharSequence)loginUserRequest.getToken())) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.TOKEN_EMPTY);
        }
        return this.sessionManagerApi.getSession(loginUserRequest.getToken());
    }

    public SessionValidateResponse haveSession(@RequestParam(value="token") String token) {
        boolean validateFlag = this.sessionManagerApi.haveSession(token);
        return new SessionValidateResponse(Boolean.valueOf(validateFlag));
    }

    public LoginUser getEffectiveLoginUser(@RequestBody LoginUser loginUser) {
        return this.userServiceApi.getEffectiveLoginUser(loginUser);
    }
}

