/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserGroup;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserGroupDetail;
import cn.stylefeng.roses.kernel.system.modular.user.enums.SysUserGroupExceptionEnum;
import cn.stylefeng.roses.kernel.system.modular.user.factory.UserGroupFactory;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserGroupMapper;
import cn.stylefeng.roses.kernel.system.modular.user.pojo.request.SysUserGroupRequest;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserGroupDetailService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserGroupService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysUserGroupServiceImpl
extends ServiceImpl<SysUserGroupMapper, SysUserGroup>
implements SysUserGroupService {
    @Resource
    private SysUserGroupDetailService sysUserGroupDetailService;
    @Resource
    private DictApi dictApi;

    @Override
    public SysUserGroup add(SysUserGroupRequest sysUserGroupRequest) {
        SysUserGroup sysUserGroup = new SysUserGroup();
        sysUserGroup.setUserGroupId(IdWorker.getId());
        sysUserGroup.setUserGroupTitle(sysUserGroupRequest.getUserGroupTitle());
        sysUserGroup.setUserGroupDetailName(sysUserGroupRequest.getUserGroupDetailName());
        List<SysUserGroupDetail> userGroupDetail = UserGroupFactory.createUserGroupDetail(sysUserGroup.getUserGroupId(), sysUserGroupRequest);
        this.save((Object)sysUserGroup);
        if (ObjectUtil.isNotEmpty(userGroupDetail)) {
            this.sysUserGroupDetailService.saveBatch(userGroupDetail);
        }
        return sysUserGroup;
    }

    @Override
    public void del(SysUserGroupRequest sysUserGroupRequest) {
        SysUserGroup sysUserGroup = this.querySysUserGroup(sysUserGroupRequest);
        this.removeById(sysUserGroup.getUserGroupId());
    }

    @Override
    public void edit(SysUserGroupRequest sysUserGroupRequest) {
        SysUserGroup sysUserGroup = this.querySysUserGroup(sysUserGroupRequest);
        BeanUtil.copyProperties((Object)((Object)sysUserGroupRequest), (Object)((Object)sysUserGroup), (String[])new String[0]);
        this.updateById((Object)sysUserGroup);
    }

    @Override
    public SysUserGroup detail(SysUserGroupRequest sysUserGroupRequest) {
        SysUserGroup sysUserGroup = this.querySysUserGroup(sysUserGroupRequest);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserGroupDetail::getUserGroupId, (Object)sysUserGroup.getUserGroupId());
        List detailList = this.sysUserGroupDetailService.list((Wrapper)queryWrapper);
        return UserGroupFactory.parseToEntity(sysUserGroup, detailList);
    }

    @Override
    public PageResult<SysUserGroup> findPage(SysUserGroupRequest sysUserGroupRequest) {
        LambdaQueryWrapper<SysUserGroup> wrapper = this.createWrapper(sysUserGroupRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SimpleDict> getSelectRelationList() {
        return this.dictApi.getDictDetailsByDictTypeCode("select_relation");
    }

    @Override
    public List<SysUserGroup> findList(SysUserGroupRequest sysUserGroupRequest) {
        LambdaQueryWrapper<SysUserGroup> wrapper = this.createWrapper(sysUserGroupRequest);
        return this.list((Wrapper)wrapper);
    }

    private SysUserGroup querySysUserGroup(SysUserGroupRequest sysUserGroupRequest) {
        SysUserGroup sysUserGroup = (SysUserGroup)((Object)this.getById(sysUserGroupRequest.getUserGroupId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysUserGroup))) {
            throw new ServiceException((AbstractExceptionEnum)SysUserGroupExceptionEnum.SYS_USER_GROUP_NOT_EXISTED);
        }
        return sysUserGroup;
    }

    private LambdaQueryWrapper<SysUserGroup> createWrapper(SysUserGroupRequest sysUserGroupRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long userGroupId = sysUserGroupRequest.getUserGroupId();
        String userGroupTitle = sysUserGroupRequest.getUserGroupTitle();
        String userGroupDetailName = sysUserGroupRequest.getUserGroupDetailName();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userGroupId), SysUserGroup::getUserGroupId, (Object)userGroupId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)userGroupTitle), SysUserGroup::getUserGroupTitle, (Object)userGroupTitle);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)userGroupDetailName), SysUserGroup::getUserGroupDetailName, (Object)userGroupDetailName);
        return queryWrapper;
    }
}

