/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.util;

import com.aizuda.snailjob.common.core.network.SnailJobNetworkProperties;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class SnailJobNetworkUtils {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final SnailJobNetworkProperties properties;

    public SnailJobNetworkUtils(SnailJobNetworkProperties properties) {
        this.properties = properties;
    }

    public String findPreferredHostAddress() {
        List<InetAddress> validAddresses = this.findAllValidAddresses();
        return this.selectPreferredAddress(validAddresses);
    }

    private List<InetAddress> findAllValidAddresses() {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!this.isValidAddress(address) || this.ignoreInterface(ni.getDisplayName())) continue;
                    result.add(address);
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to retrieve network interfaces", e);
        }
        return result;
    }

    private boolean isValidAddress(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return false;
        }
        if (this.properties.isPreferIpv4() && address instanceof Inet6Address) {
            return false;
        }
        return !this.properties.isPreferSiteLocalAddress() || address.isSiteLocalAddress();
    }

    boolean ignoreInterface(String interfaceName) {
        for (String regex : this.properties.getIgnoredInterfaces()) {
            if (!interfaceName.matches(regex)) continue;
            SnailJobLog.LOCAL.trace("Ignoring interface: " + interfaceName, new Object[0]);
            return true;
        }
        return false;
    }

    private String selectPreferredAddress(List<InetAddress> addresses) {
        if (this.properties.getPreferredNetworks() != null && !this.properties.getPreferredNetworks().isEmpty()) {
            for (String network : this.properties.getPreferredNetworks()) {
                String[] parts = network.split("/");
                String baseIp = parts[0];
                int prefixLength = Integer.parseInt(parts[1]);
                for (InetAddress address : addresses) {
                    if (!this.matchesNetwork(address, baseIp, prefixLength)) continue;
                    return address.getHostAddress();
                }
            }
        }
        return NetUtil.getLocalIpStr();
    }

    private boolean matchesNetwork(InetAddress address, String baseIp, int prefixLength) {
        if (address instanceof Inet6Address && !IPV4_PATTERN.matcher(baseIp).matches()) {
            int mask;
            byte[] addrBytes = address.getAddress();
            byte[] baseBytes = this.textToNumericFormatV6(baseIp);
            if (baseBytes == null || addrBytes.length != baseBytes.length) {
                return false;
            }
            int bitsToCompare = Math.min(prefixLength, addrBytes.length * 8);
            for (int i = 0; i < bitsToCompare / 8; ++i) {
                if (addrBytes[i] == baseBytes[i]) continue;
                return false;
            }
            int remainingBits = bitsToCompare % 8;
            return remainingBits == 0 || (addrBytes[bitsToCompare / 8] & (mask = 255 << 8 - remainingBits)) == (baseBytes[bitsToCompare / 8] & mask);
        }
        if (address instanceof Inet4Address && IPV4_PATTERN.matcher(baseIp).matches()) {
            byte[] addrBytes = address.getAddress();
            String[] baseParts = baseIp.split("\\.");
            int[] baseOctets = new int[4];
            for (int i = 0; i < 4; ++i) {
                baseOctets[i] = Integer.parseInt(baseParts[i]);
            }
            int addrInt = (addrBytes[0] & 0xFF) << 24 | (addrBytes[1] & 0xFF) << 16 | (addrBytes[2] & 0xFF) << 8 | addrBytes[3] & 0xFF;
            int maskBits = prefixLength;
            int mask = -1 << 32 - maskBits;
            int baseInt = baseOctets[0] << 24 | baseOctets[1] << 16 | baseOctets[2] << 8 | baseOctets[3];
            return (addrInt & mask) == (baseInt & mask);
        }
        return false;
    }

    private byte[] textToNumericFormatV6(String ipAddress) {
        try {
            return Inet6Address.getByName(ipAddress).getAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

