/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.handler;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.client.CommonRpcClient;
import com.aizuda.snailjob.server.common.dto.ConfigSyncTask;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class SyncConfigHandler
implements Lifecycle,
Runnable {
    private static final LinkedBlockingQueue<ConfigSyncTask> QUEUE = new LinkedBlockingQueue(256);
    public Thread THREAD = null;
    protected final AccessTemplate accessTemplate;

    public static boolean addSyncTask(String groupName, String namespaceId) {
        ConfigSyncTask configSyncTask = new ConfigSyncTask();
        configSyncTask.setNamespaceId(namespaceId);
        configSyncTask.setGroupName(groupName);
        return QUEUE.offer(configSyncTask);
    }

    public void syncVersion(String groupName, String namespaceId) {
        try {
            Set serverNodeSet = CacheRegisterTable.getServerNodeSet((String)groupName, (String)namespaceId);
            for (RegisterNodeInfo registerNodeInfo : serverNodeSet) {
                ConfigDTO configDTO = this.accessTemplate.getGroupConfigAccess().getConfigInfo(groupName, namespaceId);
                CommonRpcClient rpcClient = (CommonRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).client(CommonRpcClient.class).build();
                SnailJobLog.LOCAL.info("Synchronization result [{}]", new Object[]{rpcClient.syncConfig(configDTO)});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("version sync error. groupName:[{}]", new Object[]{groupName, e});
        }
    }

    public void start() {
        this.THREAD = new Thread((Runnable)this, "config-version-sync");
        this.THREAD.start();
    }

    public void close() {
        if (Objects.nonNull(this.THREAD)) {
            this.THREAD.interrupt();
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ConfigSyncTask task = QUEUE.take();
                this.syncVersion(task.getGroupName(), task.getNamespaceId());
            }
            catch (InterruptedException e) {
                SnailJobLog.LOCAL.info("[{}] thread stop.", new Object[]{Thread.currentThread().getName()});
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("client refresh expireAt error.", new Object[]{e});
            }
            finally {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Generated
    public SyncConfigHandler(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

