/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row {
    private List<Object> columnValues;

    public Row() {
        this.columnValues = new ArrayList<Object>();
    }

    public Row(int columnNum) {
        this.columnValues = new ArrayList<Object>(columnNum);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Row [row=");
        for (Object object : this.getColumnValues()) {
            if (object == null) {
                builder.append(",");
                continue;
            }
            builder.append(object.toString());
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public void setColumn(int index, Object value) {
        try {
            this.columnValues.add(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Adb4pgClientException(108, "column index out of boundary", null);
        }
    }

    public void updateColumn(int index, Object value) {
        try {
            this.columnValues.set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Adb4pgClientException(108, "column index out of boundary", null);
        }
    }

    public List<Object> getColumnValues() {
        return this.columnValues;
    }

    public void setColumnValues(List<Object> values) {
        this.columnValues = values;
    }

    public int length() {
        int length = 0;
        for (Object v : this.columnValues) {
            if (v == null) continue;
            length += v.toString().getBytes().length;
        }
        return length;
    }
}

