/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetricTimerListener
implements Runnable {
    private static final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());

    @Override
    public void run() {
        TreeMap<Long, List<MetricNode>> maps = new TreeMap<Long, List<MetricNode>>();
        for (Map.Entry<ResourceWrapper, ClusterNode> entry : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            ClusterNode node = entry.getValue();
            Map<Long, MetricNode> metrics = node.metrics();
            this.aggregate(maps, metrics, node);
        }
        this.aggregate(maps, Constants.ENTRY_NODE.metrics(), Constants.ENTRY_NODE);
        if (!maps.isEmpty()) {
            for (Map.Entry<ResourceWrapper, ClusterNode> entry : maps.entrySet()) {
                try {
                    metricWriter.write((Long)((Object)entry.getKey()), (List)((Object)entry.getValue()));
                }
                catch (Exception e) {
                    RecordLog.warn("[MetricTimerListener] Write metric error", e);
                }
            }
        }
    }

    private void aggregate(Map<Long, List<MetricNode>> maps, Map<Long, MetricNode> metrics, ClusterNode node) {
        for (Map.Entry<Long, MetricNode> entry : metrics.entrySet()) {
            long time = entry.getKey();
            MetricNode metricNode = entry.getValue();
            metricNode.setResource(node.getName());
            metricNode.setClassification(node.getResourceType());
            if (maps.get(time) == null) {
                maps.put(time, new ArrayList());
            }
            List<MetricNode> nodes = maps.get(time);
            nodes.add(entry.getValue());
        }
    }
}

