/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.function.ObjBoolConsumer;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.reader.CharArrayValueConsumer;
import com.alibaba.fastjson2.reader.ConstructorFunction;
import com.alibaba.fastjson2.reader.ConstructorSupplier;
import com.alibaba.fastjson2.reader.FactoryFunction;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderAnySetter;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceField;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalField;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalMethod;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerField;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolField;
import com.alibaba.fastjson2.reader.FieldReaderBoolFunc;
import com.alibaba.fastjson2.reader.FieldReaderBoolMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolValFunc;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueField;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderCharValueField;
import com.alibaba.fastjson2.reader.FieldReaderCharValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderCollectionFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderCollectionMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderDate;
import com.alibaba.fastjson2.reader.FieldReaderDoubleField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleFunc;
import com.alibaba.fastjson2.reader.FieldReaderDoubleMethod;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatField;
import com.alibaba.fastjson2.reader.FieldReaderFloatFunc;
import com.alibaba.fastjson2.reader.FieldReaderFloatMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueField;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInstant;
import com.alibaba.fastjson2.reader.FieldReaderInt16Field;
import com.alibaba.fastjson2.reader.FieldReaderInt16Func;
import com.alibaba.fastjson2.reader.FieldReaderInt16Method;
import com.alibaba.fastjson2.reader.FieldReaderInt16Param;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt32Field;
import com.alibaba.fastjson2.reader.FieldReaderInt32Func;
import com.alibaba.fastjson2.reader.FieldReaderInt32Method;
import com.alibaba.fastjson2.reader.FieldReaderInt32Param;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt64Field;
import com.alibaba.fastjson2.reader.FieldReaderInt64Func;
import com.alibaba.fastjson2.reader.FieldReaderInt64Method;
import com.alibaba.fastjson2.reader.FieldReaderInt64Param;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt8Field;
import com.alibaba.fastjson2.reader.FieldReaderInt8Func;
import com.alibaba.fastjson2.reader.FieldReaderInt8Method;
import com.alibaba.fastjson2.reader.FieldReaderInt8Param;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueFunc;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderListField;
import com.alibaba.fastjson2.reader.FieldReaderLocalDate;
import com.alibaba.fastjson2.reader.FieldReaderLocalDateTime;
import com.alibaba.fastjson2.reader.FieldReaderMapFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderMapMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderNumberFunc;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.FieldReaderObjectFunc;
import com.alibaba.fastjson2.reader.FieldReaderObjectParam;
import com.alibaba.fastjson2.reader.FieldReaderOffsetDateTime;
import com.alibaba.fastjson2.reader.FieldReaderStackTrace;
import com.alibaba.fastjson2.reader.FieldReaderStringArray;
import com.alibaba.fastjson2.reader.FieldReaderStringField;
import com.alibaba.fastjson2.reader.FieldReaderStringFunc;
import com.alibaba.fastjson2.reader.FieldReaderStringMethod;
import com.alibaba.fastjson2.reader.FieldReaderUUID;
import com.alibaba.fastjson2.reader.FieldReaderZonedDateTime;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReader1;
import com.alibaba.fastjson2.reader.ObjectReader2;
import com.alibaba.fastjson2.reader.ObjectReader3;
import com.alibaba.fastjson2.reader.ObjectReader4;
import com.alibaba.fastjson2.reader.ObjectReader5;
import com.alibaba.fastjson2.reader.ObjectReader6;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderException;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplValue;
import com.alibaba.fastjson2.reader.ObjectReaderImplValueInt;
import com.alibaba.fastjson2.reader.ObjectReaderImplValueString;
import com.alibaba.fastjson2.reader.ObjectReaderInterface;
import com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstructor;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.support.LambdaMiscCodec;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;

public class ObjectReaderCreator {
    public static final boolean JIT = !JDKUtils.ANDROID && !JDKUtils.GRAAL;
    public static final ObjectReaderCreator INSTANCE = new ObjectReaderCreator();
    protected final AtomicInteger jitErrorCount = new AtomicInteger();
    protected volatile Throwable jitErrorLast;
    protected static final Map<Class, LambdaSetterInfo> methodTypeMapping = new HashMap<Class, LambdaSetterInfo>();

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstructor(Constructor constructor, String ... paramNames) {
        Function<Map<Long, Object>, T> function = this.createFunction(constructor, paramNames);
        Class declaringClass = constructor.getDeclaringClass();
        FieldReader[] fieldReaders = this.createFieldReaders(JSONFactory.getDefaultObjectReaderProvider(), declaringClass, declaringClass, constructor, constructor.getParameters(), paramNames);
        return this.createObjectReaderNoneDefaultConstructor(declaringClass, function, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstructor(Class objectClass, Function<Map<Long, Object>, T> creator, FieldReader ... fieldReaders) {
        return new ObjectReaderNoneDefaultConstructor<T>(objectClass, null, null, 0L, creator, null, null, fieldReaders, null, null, null);
    }

    public <T> ObjectReader<T> createObjectReaderFactoryMethod(Method factoryMethod, String ... paramNames) {
        Function<Map<Long, Object>, T> factoryFunction = this.createFactoryFunction(factoryMethod, paramNames);
        FieldReader[] fieldReaders = this.createFieldReaders(JSONFactory.getDefaultObjectReaderProvider(), null, null, factoryMethod, factoryMethod.getParameters(), paramNames);
        return new ObjectReaderNoneDefaultConstructor<T>(null, null, null, 0L, factoryFunction, null, paramNames, fieldReaders, null, null, null);
    }

    public FieldReader[] createFieldReaders(ObjectReaderProvider provider, Class objectClass, Type objectType, Executable owner, Parameter[] parameters, String ... paramNames) {
        Class<?> declaringClass = null;
        if (owner != null) {
            declaringClass = owner.getDeclaringClass();
        }
        FieldReader[] fieldReaders = new FieldReader[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String fieldName;
            Field field;
            FieldInfo fieldInfo = new FieldInfo();
            Parameter parameter = parameters[i];
            String paramName = i < paramNames.length ? paramNames[i] : parameter.getName();
            if (owner instanceof Constructor) {
                provider.getFieldInfo(fieldInfo, declaringClass, (Constructor)owner, i, parameter);
            }
            if (owner instanceof Constructor && (field = BeanUtils.getDeclaredField(declaringClass, paramName)) != null) {
                provider.getFieldInfo(fieldInfo, declaringClass, field);
            }
            if ((fieldName = fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty() ? paramName : fieldInfo.fieldName) == null) {
                fieldName = "arg" + i;
            }
            if (paramName == null) {
                paramName = "arg" + i;
            }
            ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, parameter.getParameterizedType(), parameter.getType(), fieldInfo);
            Type paramType = parameter.getParameterizedType();
            fieldReaders[i] = this.createFieldReaderParam(null, null, fieldName, i, fieldInfo.features, fieldInfo.format, paramType, parameter.getType(), paramName, declaringClass, parameter, null, initReader);
        }
        return fieldReaders;
    }

    public <T> Function<Map<Long, Object>, T> createFactoryFunction(Method factoryMethod, String ... paramNames) {
        factoryMethod.setAccessible(true);
        return new FactoryFunction(factoryMethod, paramNames);
    }

    public <T> Function<Map<Long, Object>, T> createFunction(Constructor constructor, String ... paramNames) {
        constructor.setAccessible(true);
        return new ConstructorFunction(null, constructor, null, null, null, paramNames);
    }

    public <T> Function<Map<Long, Object>, T> createFunction(Constructor constructor, Constructor markerConstructor, String ... paramNames) {
        if (markerConstructor == null) {
            constructor.setAccessible(true);
        } else {
            markerConstructor.setAccessible(true);
        }
        return new ConstructorFunction(null, constructor, null, null, markerConstructor, paramNames);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, 0L, null, this.createSupplier(objectClass), null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Supplier<T> defaultCreator, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, 0L, null, defaultCreator, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Class[] seeAlso, FieldReader ... fieldReaders) {
        Supplier<T> instanceSupplier = this.createSupplier(objectType);
        return new ObjectReaderSeeAlso<T>(objectType, instanceSupplier, "@type", seeAlso, null, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectClass, String typeKey, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        Supplier<T> creator = this.createSupplier(objectClass);
        return new ObjectReaderSeeAlso<T>(objectClass, creator, typeKey, seeAlso, seeAlsoNames, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectClass, String typeKey, Class[] seeAlso, String[] seeAlsoNames, Class seeAlsoDefault, FieldReader ... fieldReaders) {
        Supplier<T> creator = this.createSupplier(objectClass);
        return new ObjectReaderSeeAlso<T>(objectClass, creator, typeKey, seeAlso, seeAlsoNames, seeAlsoDefault, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Supplier<T> defaultCreator, String typeKey, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        return new ObjectReaderSeeAlso<T>(objectType, defaultCreator, typeKey, seeAlso, seeAlsoNames, null, fieldReaders);
    }

    protected <T> ObjectReader<T> createObjectReaderWithBuilder(Class<T> objectClass, Type objectType, ObjectReaderProvider provider, BeanInfo beanInfo) {
        Function builderFunction = null;
        if (beanInfo.buildMethod != null) {
            builderFunction = this.createBuildFunction(beanInfo.buildMethod);
        }
        Class builderClass = beanInfo.builder;
        String builderWithPrefix = beanInfo.builderWithPrefix;
        if (builderWithPrefix == null || builderWithPrefix.isEmpty()) {
            builderWithPrefix = "with";
        }
        int builderWithPrefixLenth = builderWithPrefix.length();
        LinkedHashMap fieldReaders = new LinkedHashMap();
        String prefix = builderWithPrefix;
        FieldInfo fieldInfo = new FieldInfo();
        BeanUtils.setters(builderClass, false, method -> {
            String fieldName;
            fieldInfo.init();
            provider.getFieldInfo(fieldInfo, objectClass, (Method)method);
            if (fieldInfo.ignore) {
                return;
            }
            String methodName = method.getName();
            if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
                boolean prefixNotMach;
                int methodNameLength = methodName.length();
                boolean bl = prefixNotMach = methodNameLength <= prefix.length() || !methodName.startsWith(prefix);
                if (prefixNotMach) {
                    if (method.getDeclaringClass() == Object.class || method.getReturnType() != builderClass || method.getAnnotation(JSONField.class) == null && (beanInfo.readerFeatures & JSONReader.Feature.SupportSmartMatch.mask) == 0L) return;
                    fieldName = methodName;
                } else {
                    fieldName = BeanUtils.setterName(methodName, builderWithPrefixLenth);
                }
            } else {
                fieldName = fieldInfo.fieldName;
            }
            if (method.getParameterCount() == 0) {
                FieldReader fieldReader = this.createFieldReaderMethod(builderClass, builderClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, method.getGenericReturnType(), method.getReturnType(), (Method)method, null);
                FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
                if (origin == null || origin.compareTo(fieldReader) <= 0) return;
                fieldReaders.put(fieldName, fieldReader);
                return;
            }
            Type fieldType = method.getGenericParameterTypes()[0];
            Class<?> fieldClass = method.getParameterTypes()[0];
            method.setAccessible(true);
            FieldReader fieldReader = this.createFieldReaderMethod(builderClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass, (Method)method, null);
            FieldReader origin = fieldReaders.putIfAbsent(fieldName, fieldReader);
            if (origin != null && origin.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
            if (fieldInfo.alternateNames == null) return;
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReaderMethod(builderClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass, (Method)method, null));
            }
        });
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Supplier<T> instanceSupplier = this.createSupplier(builderClass);
        return this.createObjectReader(builderClass, 0L, instanceSupplier, builderFunction, (FieldReader[])fieldReaderArray);
    }

    protected <T> ObjectReader<T> createObjectReaderWithCreator(Class<T> objectClass, Type objectType, ObjectReaderProvider provider, BeanInfo beanInfo) {
        String[] paramNames;
        Class<Object> declaringClass;
        Parameter[] parameters;
        FieldInfo fieldInfo = new FieldInfo();
        LinkedHashMap<String, FieldReader> fieldReaders = new LinkedHashMap<String, FieldReader>();
        if (beanInfo.creatorConstructor != null) {
            parameters = beanInfo.creatorConstructor.getParameters();
            declaringClass = beanInfo.creatorConstructor.getDeclaringClass();
            paramNames = ASMUtils.lookupParameterNames(beanInfo.creatorConstructor);
        } else {
            parameters = beanInfo.createMethod.getParameters();
            declaringClass = beanInfo.createMethod.getDeclaringClass();
            paramNames = ASMUtils.lookupParameterNames(beanInfo.createMethod);
        }
        for (int i = 0; i < parameters.length; ++i) {
            fieldInfo.init();
            Parameter parameter = parameters[i];
            if (beanInfo.creatorConstructor != null) {
                provider.getFieldInfo(fieldInfo, objectClass, beanInfo.creatorConstructor, i, parameter);
            } else {
                provider.getFieldInfo(fieldInfo, objectClass, beanInfo.createMethod, i, parameter);
            }
            if (parameters.length == 1 && (fieldInfo.features & 0x1000000000000L) != 0L) break;
            String fieldName = fieldInfo.fieldName;
            if (fieldName == null || fieldName.isEmpty()) {
                if (beanInfo.createParameterNames != null && i < beanInfo.createParameterNames.length) {
                    fieldName = beanInfo.createParameterNames[i];
                }
                if (fieldName == null || fieldName.isEmpty()) {
                    fieldName = parameter.getName();
                }
            }
            if (fieldName == null || fieldName.isEmpty()) {
                fieldName = paramNames[i];
            } else if (fieldName.startsWith("arg")) {
                if (paramNames != null && paramNames.length > i) {
                    fieldName = paramNames[i];
                }
            } else {
                paramNames[i] = fieldName;
            }
            String finalFieldName = fieldName;
            Class<?> paramClass = parameter.getType();
            BeanUtils.getters(objectClass, method -> {
                if (method.getReturnType() != paramClass) {
                    return;
                }
                FieldInfo methodFieldInfo = new FieldInfo();
                provider.getFieldInfo(methodFieldInfo, objectClass, (Method)method);
                String methodFieldName = methodFieldInfo.fieldName;
                if (methodFieldName == null) {
                    methodFieldName = BeanUtils.getterName(method, PropertyNamingStrategy.CamelCase.name());
                }
                if (methodFieldInfo.readUsing != null && finalFieldName.equals(methodFieldName)) {
                    fieldInfo.readUsing = methodFieldInfo.readUsing;
                }
            });
            if (fieldName == null || fieldName.isEmpty()) {
                fieldName = "arg" + i;
            }
            Type paramType = parameter.getParameterizedType();
            ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, paramType, paramClass, fieldInfo);
            FieldReader fieldReaderParam = this.createFieldReaderParam(objectClass, objectType, fieldName, i, fieldInfo.features, fieldInfo.format, paramType, paramClass, fieldName, declaringClass, parameter, null, initReader);
            fieldReaders.put(fieldName, fieldReaderParam);
            if (fieldInfo.alternateNames == null) continue;
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReaderParam(objectClass, objectType, alternateName, i, fieldInfo.features, fieldInfo.format, paramType, paramClass, fieldName, declaringClass, parameter, null));
            }
        }
        if (parameters.length == 1 && (fieldInfo.features & 0x1000000000000L) != 0L) {
            String defaultValue;
            JSONObject object;
            Type valueType = beanInfo.creatorConstructor == null ? beanInfo.createMethod.getGenericParameterTypes()[0] : beanInfo.creatorConstructor.getGenericParameterTypes()[0];
            Class<?> valueClass = beanInfo.creatorConstructor == null ? beanInfo.createMethod.getParameterTypes()[0] : beanInfo.creatorConstructor.getParameterTypes()[0];
            JSONSchema jsonSchema = null;
            if (fieldInfo.schema != null && !fieldInfo.schema.isEmpty() && !(object = JSON.parseObject(fieldInfo.schema)).isEmpty()) {
                jsonSchema = JSONSchema.of(object, valueClass);
            }
            if ((defaultValue = fieldInfo.defaultValue) != null && defaultValue.getClass() != valueClass) {
                Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), valueType);
                if (typeConvert != null) {
                    defaultValue = typeConvert.apply(defaultValue);
                } else {
                    throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + valueClass.getName());
                }
            }
            boolean jit = JIT || (fieldInfo.features & 0x40000000000000L) != 0L || (beanInfo.readerFeatures & 0x40000000000000L) != 0L;
            Function<Object, T> function = null;
            if (defaultValue == null && jit) {
                if (valueClass == Integer.TYPE) {
                    IntFunction<T> intFunction = null;
                    if (beanInfo.creatorConstructor != null) {
                        intFunction = this.createIntFunction(beanInfo.creatorConstructor);
                    } else if (beanInfo.createMethod != null) {
                        intFunction = this.createIntFunction(beanInfo.createMethod);
                    }
                    if (intFunction != null) {
                        return ObjectReaderImplValueInt.of(objectClass, fieldInfo.features, jsonSchema, intFunction);
                    }
                } else if (valueClass == String.class) {
                    if (beanInfo.creatorConstructor != null) {
                        function = this.createStringFunction(beanInfo.creatorConstructor);
                    } else if (beanInfo.createMethod != null) {
                        function = this.createStringFunction(beanInfo.createMethod);
                    }
                    if (function != null) {
                        return ObjectReaderImplValueString.of(objectClass, fieldInfo.features, jsonSchema, function);
                    }
                }
            }
            if (jit && !valueClass.isPrimitive()) {
                if (beanInfo.creatorConstructor != null) {
                    function = this.createValueFunction(beanInfo.creatorConstructor, valueClass);
                } else if (beanInfo.createMethod != null) {
                    function = this.createValueFunction(beanInfo.createMethod, valueClass);
                }
            }
            return new ObjectReaderImplValue(objectClass, valueType, valueClass, fieldInfo.features, fieldInfo.format, defaultValue, jsonSchema, beanInfo.creatorConstructor, beanInfo.createMethod, function);
        }
        Function<Map<Long, Object>, Object> function = beanInfo.creatorConstructor != null ? this.createFunction(beanInfo.creatorConstructor, beanInfo.markerConstructor, paramNames) : this.createFactoryFunction(beanInfo.createMethod, paramNames);
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Object[] setterFieldReaders = this.createFieldReaders(objectClass, objectType);
        Arrays.sort(setterFieldReaders);
        boolean[] flags = null;
        int maskCount = 0;
        for (int i = 0; i < setterFieldReaders.length; ++i) {
            Object setterFieldReader = setterFieldReaders[i];
            if (!fieldReaders.containsKey(((FieldReader)setterFieldReader).fieldName)) continue;
            if (flags == null) {
                flags = new boolean[setterFieldReaders.length];
            }
            flags[i] = true;
            ++maskCount;
        }
        if (maskCount > 0) {
            FieldReader[] array = new FieldReader[setterFieldReaders.length - maskCount];
            int index = 0;
            for (int i = 0; i < setterFieldReaders.length; ++i) {
                if (flags[i]) continue;
                array[index++] = setterFieldReaders[i];
            }
            setterFieldReaders = array;
        }
        return new ObjectReaderNoneDefaultConstructor<T>(objectClass, beanInfo.typeKey, beanInfo.typeName, beanInfo.readerFeatures, function, null, paramNames, (FieldReader[])fieldReaderArray, (FieldReader[])setterFieldReaders, beanInfo.seeAlso, beanInfo.seeAlsoNames);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, features, null, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, String typeKey, long features, JSONSchema schema, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        int modifiers;
        if (objectClass != null && (Modifier.isAbstract(modifiers = objectClass.getModifiers()) || Modifier.isInterface(modifiers))) {
            return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, schema, defaultCreator, buildFunction, fieldReaders);
        }
        switch (fieldReaders.length) {
            case 1: {
                return new ObjectReader1<T>(objectClass, features, schema, defaultCreator, buildFunction, fieldReaders[0]);
            }
            case 2: {
                return new ObjectReader2<T>(objectClass, features, schema, defaultCreator, buildFunction, fieldReaders[0], fieldReaders[1]);
            }
            case 3: {
                return new ObjectReader3<T>(objectClass, defaultCreator, features, schema, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2]);
            }
            case 4: {
                return new ObjectReader4<T>(objectClass, features, schema, defaultCreator, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3]);
            }
            case 5: {
                return new ObjectReader5<T>(objectClass, defaultCreator, features, schema, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3], fieldReaders[4]);
            }
            case 6: {
                return new ObjectReader6<T>(objectClass, defaultCreator, features, schema, buildFunction, fieldReaders[0], fieldReaders[1], fieldReaders[2], fieldReaders[3], fieldReaders[4], fieldReaders[5]);
            }
        }
        return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, schema, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Type objectType) {
        if (objectType instanceof Class) {
            return this.createObjectReader((Class)objectType);
        }
        Class<?> objectClass = TypeUtils.getMapping(objectType);
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectClass, objectType);
        return this.createObjectReader(objectClass, this.createSupplier(objectClass), fieldReaderArray);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType) {
        return this.createObjectReader(objectType, objectType, false, JSONFactory.getDefaultObjectReaderProvider());
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType, boolean fieldBased) {
        return this.createObjectReader(objectType, objectType, fieldBased, JSONFactory.getDefaultObjectReaderProvider());
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Type objectType, boolean fieldBased, ObjectReaderProvider provider) {
        BeanInfo beanInfo = new BeanInfo();
        if (fieldBased) {
            beanInfo.readerFeatures |= JSONReader.Feature.FieldBased.mask;
        }
        for (ObjectReaderModule module : provider.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(beanInfo, objectClass);
        }
        if (beanInfo.deserializer != null && ObjectReader.class.isAssignableFrom(beanInfo.deserializer)) {
            try {
                Constructor constructor = beanInfo.deserializer.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ObjectReader)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create deserializer error", e);
            }
        }
        if (fieldBased) {
            beanInfo.readerFeatures |= JSONReader.Feature.FieldBased.mask;
        }
        if (Enum.class.isAssignableFrom(objectClass) && (beanInfo.createMethod == null || beanInfo.createMethod.getParameterCount() == 1)) {
            return this.createEnumReader(objectClass, beanInfo.createMethod, provider);
        }
        if (Throwable.class.isAssignableFrom(objectClass)) {
            fieldBased = false;
            beanInfo.readerFeatures |= JSONReader.Feature.IgnoreSetNullValue.mask;
        }
        if (fieldBased && objectClass.isInterface()) {
            fieldBased = false;
        }
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectClass, objectType, beanInfo, fieldBased, provider);
        boolean allReadOnlyOrZero = true;
        for (int i = 0; i < fieldReaderArray.length; ++i) {
            FieldReader fieldReader = fieldReaderArray[i];
            if (fieldReader.isReadOnly()) continue;
            allReadOnlyOrZero = false;
            break;
        }
        if (beanInfo.creatorConstructor != null || beanInfo.createMethod != null) {
            return this.createObjectReaderWithCreator(objectClass, objectType, provider, beanInfo);
        }
        if (beanInfo.builder != null) {
            return this.createObjectReaderWithBuilder(objectClass, objectType, provider, beanInfo);
        }
        Constructor creatorConstructor = null;
        ArrayList<Constructor> alternateConstructors = new ArrayList<Constructor>();
        BeanUtils.constructor(objectClass, alternateConstructors::add);
        if (Throwable.class.isAssignableFrom(objectClass)) {
            return new ObjectReaderException<T>(objectClass, alternateConstructors, fieldReaderArray);
        }
        Constructor defaultConstructor = null;
        Class<?> declaringClass = objectClass.getDeclaringClass();
        int index = -1;
        for (int i = 0; i < alternateConstructors.size(); ++i) {
            Constructor constructor = (Constructor)alternateConstructors.get(i);
            if (constructor.getParameterCount() == 0) {
                defaultConstructor = constructor;
            }
            if (declaringClass != null && constructor.getParameterCount() == 1 && declaringClass.equals(constructor.getParameterTypes()[0])) {
                creatorConstructor = constructor;
                index = i;
                break;
            }
            if (creatorConstructor == null) {
                creatorConstructor = constructor;
                index = i;
                continue;
            }
            if (constructor.getParameterCount() == 0) {
                creatorConstructor = constructor;
                index = i;
                continue;
            }
            if (creatorConstructor.getParameterCount() >= constructor.getParameterCount()) continue;
            creatorConstructor = constructor;
            index = i;
        }
        if (index != -1) {
            alternateConstructors.remove(index);
        }
        if (creatorConstructor != null && creatorConstructor.getParameterCount() != 0 && beanInfo.seeAlso == null) {
            FieldInfo fieldInfo;
            boolean record = BeanUtils.isRecord(objectClass);
            creatorConstructor.setAccessible(true);
            String[] parameterNames = beanInfo.createParameterNames;
            if (record && parameterNames == null) {
                parameterNames = BeanUtils.getRecordFieldNames(objectClass);
            }
            if (parameterNames == null || parameterNames.length == 0) {
                parameterNames = ASMUtils.lookupParameterNames(creatorConstructor);
                Parameter[] parameters = creatorConstructor.getParameters();
                fieldInfo = new FieldInfo();
                for (int i = 0; i < parameters.length && i < parameterNames.length; ++i) {
                    fieldInfo.init();
                    Parameter parameter = parameters[i];
                    provider.getFieldInfo(fieldInfo, objectClass, creatorConstructor, i, parameter);
                    if (fieldInfo.fieldName == null) continue;
                    parameterNames[i] = fieldInfo.fieldName;
                }
            }
            int matchCount = 0;
            if (defaultConstructor != null) {
                block8: for (int i = 0; i < parameterNames.length; ++i) {
                    String parameterName = parameterNames[i];
                    if (parameterName == null) continue;
                    for (int j = 0; j < fieldReaderArray.length; ++j) {
                        FieldReader fieldReader = fieldReaderArray[j];
                        if (fieldReader == null || !parameterName.equals(fieldReader.fieldName)) continue;
                        ++matchCount;
                        continue block8;
                    }
                }
            }
            if (!fieldBased && !Throwable.class.isAssignableFrom(objectClass) && defaultConstructor == null && matchCount != parameterNames.length) {
                if (creatorConstructor.getParameterCount() == 1) {
                    fieldInfo = new FieldInfo();
                    provider.getFieldInfo(fieldInfo, objectClass, creatorConstructor, 0, creatorConstructor.getParameters()[0]);
                    if ((fieldInfo.features & 0x1000000000000L) != 0L) {
                        String defaultValue;
                        JSONObject object;
                        Type valueType = creatorConstructor.getGenericParameterTypes()[0];
                        Class<?> valueClass = creatorConstructor.getParameterTypes()[0];
                        JSONSchema jsonSchema = null;
                        if (fieldInfo.schema != null && !fieldInfo.schema.isEmpty() && !(object = JSON.parseObject(fieldInfo.schema)).isEmpty()) {
                            jsonSchema = JSONSchema.of(object, valueClass);
                        }
                        if ((defaultValue = fieldInfo.defaultValue) != null && defaultValue.getClass() != valueClass) {
                            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), valueType);
                            if (typeConvert != null) {
                                defaultValue = typeConvert.apply(defaultValue);
                            } else {
                                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + valueClass.getName());
                            }
                        }
                        return new ObjectReaderImplValue(objectClass, valueType, valueClass, fieldInfo.features, fieldInfo.format, defaultValue, jsonSchema, creatorConstructor, null, null);
                    }
                }
                if (allReadOnlyOrZero && fieldReaderArray.length != 0 && alternateConstructors.isEmpty()) {
                    block10: for (int i = 0; i < parameterNames.length; ++i) {
                        String paramName = parameterNames[i];
                        for (FieldReader fieldReader : fieldReaderArray) {
                            if (fieldReader.field == null || !fieldReader.field.getName().equals(paramName) || fieldReader.fieldName.equals(paramName)) continue;
                            parameterNames[i] = fieldReader.fieldName;
                            continue block10;
                        }
                    }
                }
                Function function = null;
                BiFunction biFunction = null;
                if (JIT) {
                    if (creatorConstructor.getParameterCount() == 1) {
                        function = LambdaMiscCodec.createFunction(creatorConstructor);
                    } else if (creatorConstructor.getParameterCount() == 2) {
                        biFunction = LambdaMiscCodec.createBiFunction(creatorConstructor);
                    }
                }
                ConstructorFunction constructorFunction = new ConstructorFunction(alternateConstructors, creatorConstructor, function, biFunction, null, parameterNames);
                FieldReader[] paramFieldReaders = this.createFieldReaders(provider, objectClass, objectType, creatorConstructor, creatorConstructor.getParameters(), parameterNames);
                return new ObjectReaderNoneDefaultConstructor(objectClass, beanInfo.typeKey, beanInfo.typeName, beanInfo.readerFeatures, constructorFunction, alternateConstructors, parameterNames, paramFieldReaders, fieldReaderArray, null, null);
            }
        }
        if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
            return this.createObjectReaderSeeAlso(objectClass, beanInfo.typeKey, beanInfo.seeAlso, beanInfo.seeAlsoNames, beanInfo.seeAlsoDefault, fieldReaderArray);
        }
        if (objectClass.isInterface()) {
            return new ObjectReaderInterface((Class)objectClass, null, null, 0L, null, null, fieldReaderArray);
        }
        Supplier<T> creator = this.createSupplier(objectClass);
        JSONSchema jsonSchema = JSONSchema.of(JSON.parseObject(beanInfo.schema), objectClass);
        ObjectReader<T> objectReader = this.createObjectReader(objectClass, beanInfo.typeKey, beanInfo.readerFeatures, jsonSchema, creator, null, fieldReaderArray);
        if (objectReader instanceof ObjectReaderBean) {
            JSONReader.AutoTypeBeforeHandler beforeHandler = null;
            if (beanInfo.autoTypeBeforeHandler != null) {
                try {
                    Constructor<? extends JSONReader.AutoTypeBeforeHandler> constructor = beanInfo.autoTypeBeforeHandler.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    beforeHandler = constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (beforeHandler != null) {
                ((ObjectReaderBean)objectReader).setAutoTypeBeforeHandler(beforeHandler);
            }
        }
        return objectReader;
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass) {
        return this.createFieldReaders(objectClass, objectClass, null, false, JSONFactory.getDefaultObjectReaderProvider());
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType) {
        return this.createFieldReaders(objectClass, objectType, null, false, JSONFactory.getDefaultObjectReaderProvider());
    }

    protected void createFieldReader(Class objectClass, Type objectType, String namingStrategy, FieldInfo fieldInfo, Field field, Map<String, FieldReader> fieldReaders, ObjectReaderProvider provider) {
        int cmp;
        FieldReader fieldReader;
        FieldReader previous;
        String fieldName;
        provider.getFieldInfo(fieldInfo, objectClass, field);
        if (fieldInfo.ignore) {
            boolean unwrap;
            boolean bl = unwrap = (fieldInfo.features & 0x2000000000000L) != 0L && Map.class.isAssignableFrom(field.getType());
            if (!unwrap) {
                return;
            }
        }
        if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
            fieldName = field.getName();
            if (namingStrategy != null) {
                fieldName = BeanUtils.fieldName(fieldName, namingStrategy);
            }
        } else {
            fieldName = fieldInfo.fieldName;
        }
        Type fieldType = field.getGenericType();
        Class<?> fieldClass = field.getType();
        ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, fieldType, fieldClass, fieldInfo);
        String schema = fieldInfo.schema;
        if (fieldInfo.required && schema == null) {
            schema = "{\"required\":true}";
        }
        if ((previous = fieldReaders.putIfAbsent(fieldName, fieldReader = this.createFieldReader(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, schema, fieldType, fieldClass, field, initReader))) != null && (cmp = fieldReader.compareTo(previous)) > 0) {
            fieldReaders.put(fieldName, fieldReader);
        }
        if (fieldInfo.alternateNames != null) {
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                FieldReader fieldReader1 = this.createFieldReader(objectClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, null, fieldInfo.locale, fieldInfo.defaultValue, schema, fieldType, fieldClass, field, null);
                fieldReaders.putIfAbsent(alternateName, fieldReader1);
            }
        }
    }

    protected void createFieldReader(Class objectClass, Type objectType, String namingStrategy, String[] orders, BeanInfo beanInfo, FieldInfo fieldInfo, Method method, Map<String, FieldReader> fieldReaders, ObjectReaderProvider provider) {
        FieldReader origin;
        boolean jit;
        int parameterCount;
        String fieldName;
        provider.getFieldInfo(fieldInfo, objectClass, method);
        if (fieldInfo.ignore) {
            return;
        }
        if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
            char c1;
            String methodName = method.getName();
            fieldName = methodName.startsWith("set") ? BeanUtils.setterName(methodName, namingStrategy) : BeanUtils.getterName(method, namingStrategy);
            char c0 = '\u0000';
            int len = fieldName.length();
            if (len > 0) {
                c0 = fieldName.charAt(0);
            }
            if (len == 1 && c0 >= 'a' && c0 <= 'z' || len > 2 && c0 >= 'A' && c0 <= 'Z' && (c1 = fieldName.charAt(1)) >= 'A' && c1 <= 'Z') {
                char[] chars = fieldName.toCharArray();
                chars[0] = len == 1 ? (char)(chars[0] - 32) : (char)(chars[0] + 32);
                String fieldName1 = new String(chars);
                Field field = BeanUtils.getDeclaredField(objectClass, fieldName1);
                if (field != null) {
                    if (Modifier.isPublic(field.getModifiers())) {
                        fieldName = field.getName();
                    } else if (len == 1) {
                        fieldInfo.alternateNames = new String[]{fieldName};
                        fieldName = field.getName();
                    }
                }
            }
        } else {
            fieldName = fieldInfo.fieldName;
        }
        if (orders != null && orders.length > 0) {
            boolean match = false;
            for (int i = 0; i < orders.length; ++i) {
                if (!fieldName.equals(orders[i])) continue;
                fieldInfo.ordinal = i;
                match = true;
                break;
            }
            if (!match && fieldInfo.ordinal == 0) {
                fieldInfo.ordinal = orders.length;
            }
        }
        if ((parameterCount = method.getParameterCount()) == 0) {
            Class<?> fieldClass;
            Type fieldType = method.getGenericReturnType();
            FieldReader fieldReader = this.createFieldReaderMethod(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass = method.getReturnType(), method, fieldInfo.getInitReader());
            FieldReader origin2 = fieldReaders.putIfAbsent(fieldName, fieldReader);
            if (origin2 != null && origin2.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
            return;
        }
        if (parameterCount == 2) {
            Class<?> fieldClass = method.getParameterTypes()[1];
            Type fieldType = method.getGenericParameterTypes()[1];
            method.setAccessible(true);
            FieldReaderAnySetter anySetter = new FieldReaderAnySetter(fieldType, fieldClass, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, null, method);
            fieldReaders.put(anySetter.fieldName, anySetter);
            return;
        }
        Type fieldType = method.getGenericParameterTypes()[0];
        Class<?> fieldClass = method.getParameterTypes()[0];
        if (fieldType instanceof Class && Collection.class.isAssignableFrom((Class)fieldType)) {
            Class<?>[] interfaces = objectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Type[] genericParameterTypes;
                Method interfaceMethod = BeanUtils.getMethod(interfaces[i], method);
                if (interfaceMethod == null || (genericParameterTypes = interfaceMethod.getGenericParameterTypes()).length != 1 || !(genericParameterTypes[0] instanceof ParameterizedType)) continue;
                fieldType = genericParameterTypes[0];
            }
        }
        if (TypeUtils.isFunction(fieldClass)) {
            return;
        }
        ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, fieldType, fieldClass, fieldInfo);
        FieldReader fieldReader = null;
        boolean bl = jit = (fieldInfo.features & 0x40000000000000L) != 0L;
        if (jit) {
            try {
                fieldReader = this.createFieldReaderLambda(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass, method, initReader);
            }
            catch (Throwable ignored) {
                this.jitErrorCount.incrementAndGet();
                this.jitErrorLast = ignored;
            }
        }
        if (fieldReader == null) {
            fieldReader = this.createFieldReaderMethod(objectClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass, method, initReader);
        }
        if ((origin = (FieldReader)fieldReaders.putIfAbsent(fieldName, fieldReader)) != null && origin.compareTo(fieldReader) > 0) {
            fieldReaders.put(fieldName, fieldReader);
        }
        if (fieldInfo.alternateNames != null) {
            for (String alternateName : fieldInfo.alternateNames) {
                if (fieldName.equals(alternateName)) continue;
                fieldReaders.putIfAbsent(alternateName, this.createFieldReaderMethod(objectClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldInfo.schema, fieldType, fieldClass, method, initReader));
            }
        }
    }

    protected <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType, BeanInfo beanInfo, boolean fieldBased, ObjectReaderProvider provider) {
        if (beanInfo == null) {
            beanInfo = new BeanInfo();
            for (ObjectReaderModule module : provider.modules) {
                ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                if (annotationProcessor == null) continue;
                annotationProcessor.getBeanInfo(beanInfo, objectClass);
            }
        }
        boolean recoard = BeanUtils.isRecord(objectClass);
        String namingStrategy = beanInfo.namingStrategy;
        LinkedHashMap<String, FieldReader> fieldReaders = new LinkedHashMap<String, FieldReader>();
        BeanInfo finalBeanInfo = beanInfo;
        long beanFeatures = beanInfo.readerFeatures;
        String beanFormat = beanInfo.format;
        FieldInfo fieldInfo = new FieldInfo();
        String[] orders = beanInfo.orders;
        if (fieldBased) {
            BeanUtils.declaredFields(objectClass, field -> {
                fieldInfo.init();
                fieldInfo.features |= JSONReader.Feature.FieldBased.mask;
                fieldInfo.features |= beanFeatures;
                fieldInfo.format = beanFormat;
                this.createFieldReader(objectClass, objectType, namingStrategy, fieldInfo, (Field)field, (Map<String, FieldReader>)fieldReaders, provider);
            });
        } else {
            if (!recoard) {
                BeanUtils.declaredFields(objectClass, field -> {
                    fieldInfo.init();
                    fieldInfo.ignore = (field.getModifiers() & 1) == 0;
                    fieldInfo.features |= beanFeatures;
                    fieldInfo.format = beanFormat;
                    this.createFieldReader(objectClass, objectType, namingStrategy, fieldInfo, (Field)field, (Map<String, FieldReader>)fieldReaders, provider);
                    if (fieldInfo.required) {
                        String fieldName = fieldInfo.fieldName;
                        if (fieldName == null || fieldName.isEmpty()) {
                            fieldName = field.getName();
                        }
                        finalBeanInfo.required(fieldName);
                    }
                });
            }
            Class mixIn = provider.getMixIn(objectClass);
            BeanUtils.setters(objectClass, mixIn, method -> {
                fieldInfo.init();
                fieldInfo.features |= beanFeatures;
                fieldInfo.format = beanFormat;
                this.createFieldReader(objectClass, objectType, namingStrategy, orders, finalBeanInfo, fieldInfo, (Method)method, (Map<String, FieldReader>)fieldReaders, provider);
            });
            if (objectClass.isInterface()) {
                BeanUtils.getters(objectClass, method -> {
                    fieldInfo.init();
                    fieldInfo.features |= beanFeatures;
                    this.createFieldReader(objectClass, objectType, namingStrategy, orders, finalBeanInfo, fieldInfo, (Method)method, (Map<String, FieldReader>)fieldReaders, provider);
                });
            }
        }
        Class<T> superclass = objectClass.getSuperclass();
        if (BeanUtils.isExtendedMap(objectClass)) {
            Type superType = objectClass.getGenericSuperclass();
            FieldReader fieldReader = ObjectReaders.fieldReader("$super$", superType, superclass, (o, f) -> {
                Map thisMap = (Map)o;
                Map superMap = (Map)f;
                Iterator iterator = superMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry value;
                    Map.Entry entry = value = iterator.next();
                    thisMap.put(entry.getKey(), entry.getValue());
                }
            });
            fieldReaders.put("$super$", fieldReader);
        }
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        return fieldReaderArray;
    }

    public <T> Supplier<T> createSupplier(Class<T> objectClass) {
        Constructor<T> constructor;
        if (objectClass.isInterface()) {
            return null;
        }
        int modifiers = objectClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return null;
        }
        try {
            constructor = objectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
        catch (Throwable e) {
            throw new JSONException("get constructor error, class " + objectClass.getName(), e);
        }
        return this.createSupplier(constructor, true);
    }

    public <T> Supplier<T> createSupplier(Constructor constructor, boolean jit) {
        if (jit &= JIT) {
            Class declaringClass = constructor.getDeclaringClass();
            MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
            try {
                if (constructor.getParameterCount() == 0) {
                    MethodHandle handle = lookup.findConstructor(declaringClass, TypeUtils.METHOD_TYPE_VOID);
                    CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", TypeUtils.METHOD_TYPE_SUPPLIER, TypeUtils.METHOD_TYPE_OBJECT, handle, TypeUtils.METHOD_TYPE_OBJECT);
                    return callSite.getTarget().invokeExact();
                }
            }
            catch (Throwable e) {
                this.jitErrorCount.incrementAndGet();
                this.jitErrorLast = e;
            }
        }
        return new ConstructorSupplier(constructor);
    }

    protected <T> IntFunction<T> createIntFunction(Constructor constructor) {
        Class declaringClass = constructor.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodHandle handle = lookup.findConstructor(declaringClass, TypeUtils.METHOD_TYPE_VOID_INT);
            MethodType instantiatedMethodType = MethodType.methodType(declaringClass, Integer.TYPE);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_INT_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_INT, handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    protected <T> IntFunction<T> createIntFunction(Method factoryMethod) {
        Class<?> declaringClass = factoryMethod.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodType methodType = MethodType.methodType(factoryMethod.getReturnType(), Integer.TYPE);
            MethodHandle handle = lookup.findStatic(declaringClass, factoryMethod.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_INT_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_INT, handle, methodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    protected <T> Function<String, T> createStringFunction(Constructor constructor) {
        Class declaringClass = constructor.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodHandle handle = lookup.findConstructor(declaringClass, TypeUtils.METHOD_TYPE_VOID_STRING);
            MethodType instantiatedMethodType = MethodType.methodType(declaringClass, String.class);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    protected <T> Function<String, T> createStringFunction(Method factoryMethod) {
        Class<?> declaringClass = factoryMethod.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodType methodType = MethodType.methodType(factoryMethod.getReturnType(), String.class);
            MethodHandle handle = lookup.findStatic(declaringClass, factoryMethod.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, handle, methodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    protected <I, T> Function<I, T> createValueFunction(Constructor<T> constructor, Class<I> valueClass) {
        Class<T> declaringClass = constructor.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodType methodType = MethodType.methodType(Void.TYPE, valueClass);
            MethodHandle handle = lookup.findConstructor(declaringClass, methodType);
            MethodType instantiatedMethodType = MethodType.methodType(declaringClass, valueClass);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    protected <I, T> Function<I, T> createValueFunction(Method factoryMethod, Class valueClass) {
        Class<?> declaringClass = factoryMethod.getDeclaringClass();
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(declaringClass);
        try {
            MethodType methodType = MethodType.methodType(factoryMethod.getReturnType(), valueClass);
            MethodHandle handle = lookup.findStatic(declaringClass, factoryMethod.getName(), methodType);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, TypeUtils.METHOD_TYPE_OBJECT_OBJECT, handle, methodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            return null;
        }
    }

    public <T, R> Function<T, R> createBuildFunction(Method builderMethod) {
        try {
            return this.createBuildFunctionLambda(builderMethod);
        }
        catch (Throwable e) {
            this.jitErrorCount.incrementAndGet();
            this.jitErrorLast = e;
            builderMethod.setAccessible(true);
            return o -> {
                try {
                    return builderMethod.invoke(o, new Object[0]);
                }
                catch (Throwable e) {
                    throw new JSONException("create instance error", e);
                }
            };
        }
    }

    <T, R> Function<T, R> createBuildFunctionLambda(Method builderMethod) {
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(builderMethod.getDeclaringClass());
        try {
            MethodHandle target = lookup.findVirtual(builderMethod.getDeclaringClass(), builderMethod.getName(), MethodType.methodType(builderMethod.getReturnType()));
            MethodType func = target.type();
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", TypeUtils.METHOD_TYPE_FUNCTION, func.erase(), target, func);
            Object object = callSite.getTarget().invoke();
            return (Function)object;
        }
        catch (Throwable e) {
            throw new JSONException("create fieldReader error", e);
        }
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, objectType, fieldName, 0, 0L, null, null, null, null, fieldType, fieldClass, method, null);
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, fieldName, format, fieldType, fieldClass, method);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectClass, objectClass, fieldName, 0, 0L, format, null, null, null, fieldType, fieldClass, method, null);
    }

    public <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Type fieldType, Class fieldClass, String paramName, Class declaringClass, Parameter parameter, JSONSchema schema) {
        return this.createFieldReaderParam(objectClass, objectType, fieldName, ordinal, features, format, fieldType, fieldClass, paramName, declaringClass, parameter, schema, null);
    }

    public <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Type fieldType, Class fieldClass, String paramName, Class declaringClass, Parameter parameter, JSONSchema schema, ObjectReader initReader) {
        if (initReader != null) {
            FieldReaderObjectParam paramReader = new FieldReaderObjectParam(fieldName, fieldType, fieldClass, paramName, parameter, ordinal, features, format, schema);
            paramReader.initReader = initReader;
            return paramReader;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return new FieldReaderInt8Param(fieldName, fieldClass, paramName, parameter, ordinal, features, format, schema);
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return new FieldReaderInt16Param(fieldName, fieldClass, paramName, parameter, ordinal, features, format, schema);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new FieldReaderInt32Param(fieldName, fieldClass, paramName, parameter, ordinal, features, format, schema);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new FieldReaderInt64Param(fieldName, fieldClass, paramName, parameter, ordinal, features, format, schema);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class) && objectType != null && (fieldTypeResolved = BeanUtils.getParamType(TypeReference.get(objectType), objectClass, declaringClass, parameter, fieldType)) != null) {
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldTypeResolved == null) {
            fieldTypeResolved = fieldType;
        }
        if (fieldClassResolved == null) {
            fieldClassResolved = fieldClass;
        }
        return new FieldReaderObjectParam(fieldName, fieldTypeResolved, fieldClassResolved, paramName, parameter, ordinal, features, format, schema);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, String schema, Type fieldType, Class fieldClass, Method method, ObjectReader initReader) {
        String methodName;
        JSONObject object;
        if (method != null) {
            method.setAccessible(true);
        }
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        JSONSchema jsonSchema = null;
        if (schema != null && !schema.isEmpty() && !(object = JSON.parseObject(schema)).isEmpty()) {
            jsonSchema = JSONSchema.of(object, fieldClass);
        }
        if (initReader != null) {
            FieldReaderObject fieldReaderObjectMethod = new FieldReaderObject(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, locale, defaultValue, jsonSchema, method, null, null);
            fieldReaderObjectMethod.initReader = initReader;
            return fieldReaderObjectMethod;
        }
        if (fieldType == Boolean.TYPE) {
            return new FieldReaderBoolValueMethod(fieldName, ordinal, features, format, (Boolean)defaultValue, jsonSchema, method);
        }
        if (fieldType == Boolean.class) {
            return new FieldReaderBoolMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Boolean)defaultValue, jsonSchema, method);
        }
        if (fieldType == Byte.TYPE) {
            return new FieldReaderInt8ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Byte)defaultValue, jsonSchema, method);
        }
        if (fieldType == Short.TYPE) {
            return new FieldReaderInt16ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Short)defaultValue, jsonSchema, method);
        }
        if (fieldType == Integer.TYPE) {
            return new FieldReaderInt32ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Integer)defaultValue, jsonSchema, method);
        }
        if (fieldType == Long.TYPE) {
            return new FieldReaderInt64ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Long)defaultValue, jsonSchema, method);
        }
        if (fieldType == Float.TYPE) {
            return new FieldReaderFloatValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Float)defaultValue, jsonSchema, method);
        }
        if (fieldType == Double.TYPE) {
            return new FieldReaderDoubleValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Double)defaultValue, jsonSchema, method);
        }
        if (fieldType == Byte.class) {
            return new FieldReaderInt8Method(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Byte)defaultValue, jsonSchema, method);
        }
        if (fieldType == Short.class) {
            return new FieldReaderInt16Method(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Short)defaultValue, jsonSchema, method);
        }
        if (fieldType == Integer.class) {
            return new FieldReaderInt32Method(fieldName, ordinal, features, format, locale, (Integer)defaultValue, jsonSchema, method);
        }
        if (fieldType == Long.class) {
            return new FieldReaderInt64Method(fieldName, ordinal, features, format, locale, (Long)defaultValue, jsonSchema, method);
        }
        if (fieldType == Float.class) {
            return new FieldReaderFloatMethod(fieldName, ordinal, features, format, locale, (Float)defaultValue, jsonSchema, method);
        }
        if (fieldType == Double.class) {
            return new FieldReaderDoubleMethod(fieldName, ordinal, features, format, (Double)defaultValue, jsonSchema, method);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (BigDecimal)defaultValue, jsonSchema, method);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (BigInteger)defaultValue, jsonSchema, method);
        }
        if (fieldType == String.class) {
            return new FieldReaderStringMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (String)defaultValue, jsonSchema, method);
        }
        if (fieldType == LocalDate.class) {
            return new FieldReaderLocalDate(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, null, null);
        }
        if (fieldType == OffsetDateTime.class) {
            return new FieldReaderOffsetDateTime(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, null, null);
        }
        if (fieldType == UUID.class) {
            return new FieldReaderUUID(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, null, null);
        }
        if (fieldType == String[].class) {
            return new FieldReaderStringArray(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, null, null);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class) || !(objectType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (method.getParameterCount() == 0) {
            if (fieldClass == AtomicInteger.class) {
                return new FieldReaderAtomicIntegerMethodReadOnly(fieldName, fieldClass, ordinal, jsonSchema, method);
            }
            if (fieldClass == AtomicLong.class) {
                return new FieldReaderAtomicLongReadOnly(fieldName, fieldClass, ordinal, jsonSchema, method);
            }
            if (fieldClass == AtomicIntegerArray.class) {
                return new FieldReaderAtomicIntegerArrayReadOnly(fieldName, fieldClass, ordinal, jsonSchema, method);
            }
            if (fieldClass == AtomicLongArray.class) {
                return new FieldReaderAtomicLongArrayReadOnly(fieldName, fieldClass, ordinal, jsonSchema, method);
            }
            if (fieldClass == AtomicBoolean.class) {
                return new FieldReaderAtomicBooleanMethodReadOnly(fieldName, fieldClass, ordinal, jsonSchema, method);
            }
            if (fieldClass == AtomicReference.class) {
                return new FieldReaderAtomicReferenceMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, jsonSchema, method);
            }
            if (Collection.class.isAssignableFrom(fieldClass)) {
                Field field = null;
                String methodName2 = method.getName();
                if (methodName2.startsWith("get")) {
                    String getterName = BeanUtils.getterName(methodName2, PropertyNamingStrategy.CamelCase.name());
                    field = BeanUtils.getDeclaredField(method.getDeclaringClass(), getterName);
                }
                return new FieldReaderCollectionMethodReadOnly(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, jsonSchema, method, field);
            }
            if (Map.class.isAssignableFrom(fieldClass)) {
                Field field = null;
                String methodName3 = method.getName();
                if (methodName3.startsWith("get")) {
                    String getterName = BeanUtils.getterName(methodName3, PropertyNamingStrategy.CamelCase.name());
                    field = BeanUtils.getDeclaredField(method.getDeclaringClass(), getterName);
                }
                return new FieldReaderMapMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, features, format, jsonSchema, method, field);
            }
            if (!objectClass.isInterface()) {
                return null;
            }
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class || fieldClass == LinkedList.class) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    return new FieldReaderList(fieldName, fieldTypeResolved, fieldClass, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, jsonSchema, method, null, null);
                }
                return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, itemType, itemClass, ordinal, features, format, locale, null, jsonSchema, method, null, null);
            }
            return new FieldReaderList(fieldName, fieldType, fieldClass, (Type)((Object)Object.class), Object.class, ordinal, features, format, locale, null, jsonSchema, method, null, null);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, null, method, null);
        }
        if (fieldClass == StackTraceElement[].class && method.getDeclaringClass() == Throwable.class) {
            return new FieldReaderStackTrace(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, null, Throwable::setStackTrace);
        }
        Field field = null;
        if ((features & 0x2000000000000L) != 0L && (methodName = method.getName()).startsWith("set")) {
            String setterName = BeanUtils.setterName(methodName, PropertyNamingStrategy.CamelCase.name());
            field = BeanUtils.getDeclaredField(method.getDeclaringClass(), setterName);
            try {
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new FieldReaderObject(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, field, null);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, Type fieldType, Field field) {
        return this.createFieldReader(fieldName, null, fieldType, field);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, Field field) {
        return this.createFieldReader(fieldName, null, field.getGenericType(), field);
    }

    public <T> FieldReader createFieldReader(String fieldName, Method method) {
        Type fieldType;
        Class<?> fieldClass;
        Class<?> declaringClass = method.getDeclaringClass();
        int parameterCount = method.getParameterCount();
        if (parameterCount == 0) {
            fieldClass = method.getReturnType();
            fieldType = method.getGenericReturnType();
        } else if (parameterCount == 1) {
            fieldClass = method.getParameterTypes()[0];
            fieldType = method.getGenericParameterTypes()[0];
        } else {
            throw new JSONException("illegal setter method " + method);
        }
        return this.createFieldReaderMethod(declaringClass, declaringClass, fieldName, 0, 0L, null, null, null, null, fieldType, fieldClass, method, null);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, String format, Type fieldType, Field field) {
        Class<?> objectClass = field.getDeclaringClass();
        return this.createFieldReader(objectClass, objectClass, fieldName, 0L, format, fieldType, field.getType(), field);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, long features, String format, Type fieldType, Class fieldClass, Field field) {
        return this.createFieldReader(objectClass, objectType, fieldName, 0, features, format, null, null, null, fieldType, field.getType(), field, null);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, String schema, Type fieldType, Class fieldClass, Field field, ObjectReader initReader) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        String objectClassName;
        JSONObject object;
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
            Function typeConvert = provider.getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        JSONSchema jsonSchema = null;
        if (schema != null && !schema.isEmpty() && !(object = JSON.parseObject(schema)).isEmpty()) {
            jsonSchema = JSONSchema.of(object, fieldClass);
        }
        if (field != null && !(objectClassName = objectClass.getName()).startsWith("java.lang") && !objectClassName.startsWith("java.time")) {
            field.setAccessible(true);
        }
        if (initReader != null) {
            FieldReaderObjectField fieldReader = new FieldReaderObjectField(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, defaultValue, jsonSchema, field);
            fieldReader.initReader = initReader;
            return fieldReader;
        }
        if (fieldClass == Integer.TYPE) {
            return new FieldReaderInt32ValueField(fieldName, fieldClass, ordinal, format, (Integer)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Field(fieldName, fieldClass, ordinal, features, format, (Integer)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Long.TYPE) {
            return new FieldReaderInt64ValueField(fieldName, fieldClass, ordinal, features, format, (Long)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Field(fieldName, fieldClass, ordinal, features, format, (Long)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldReaderInt16ValueField(fieldName, fieldClass, ordinal, features, format, (Short)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Field(fieldName, fieldClass, ordinal, features, format, (Short)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldReaderBoolValueField(fieldName, ordinal, features, format, (Boolean)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolField(fieldName, fieldClass, ordinal, features, format, (Boolean)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldReaderInt8ValueField(fieldName, fieldClass, ordinal, features, format, (Byte)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Field(fieldName, fieldClass, ordinal, features, format, (Byte)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldReaderFloatValueField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Float.class) {
            return new FieldReaderFloatField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldReaderDoubleValueField(fieldName, fieldClass, ordinal, features, format, (Double)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Double.class) {
            return new FieldReaderDoubleField(fieldName, fieldClass, ordinal, features, format, (Double)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldReaderCharValueField(fieldName, ordinal, features, format, (Character)defaultValue, jsonSchema, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalField(fieldName, fieldClass, ordinal, features, format, (BigDecimal)defaultValue, jsonSchema, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerField(fieldName, fieldClass, ordinal, features, format, (BigInteger)defaultValue, jsonSchema, field);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringField(fieldName, fieldClass, ordinal, features, format, (String)defaultValue, jsonSchema, field);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, field, null, null);
        }
        if (fieldClass == AtomicBoolean.class) {
            return new FieldReaderAtomicBooleanFieldReadOnly(fieldName, fieldClass, ordinal, format, (AtomicBoolean)defaultValue, jsonSchema, field);
        }
        if (fieldClass == AtomicReference.class) {
            return new FieldReaderAtomicReferenceField(fieldName, fieldType, fieldClass, ordinal, format, jsonSchema, field);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, field, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        boolean finalField = Modifier.isFinal(field.getModifiers());
        if (Collection.class.isAssignableFrom(fieldClass)) {
            ParameterizedType parameterizedType2;
            Type[] actualTypeArguments2;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments2 = (parameterizedType2 = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments2[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    if (finalField) {
                        if ((features & JSONReader.Feature.FieldBased.mask) != 0L) {
                            return new FieldReaderListField(fieldName, fieldTypeResolved, (Class)fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, jsonSchema, field);
                        }
                        return new FieldReaderCollectionFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, jsonSchema, field);
                    }
                    return new FieldReaderListField(fieldName, fieldTypeResolved, (Class)fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, jsonSchema, field);
                }
                return new FieldReaderListField(fieldName, fieldTypeResolved, fieldClassResolved, itemType, itemClass, ordinal, features, format, locale, (Collection)defaultValue, jsonSchema, field);
            }
            Object itemType = null;
            if (fieldType instanceof ParameterizedType && (actualTypeArguments2 = ((ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
                itemType = actualTypeArguments2[0];
            }
            if (itemType == null) {
                itemType = Object.class;
            }
            Class<?> itemClass = TypeUtils.getClass(itemType);
            return new FieldReaderListField(fieldName, fieldType, fieldClass, (Type)itemType, itemClass, ordinal, features, format, locale, (Collection)defaultValue, jsonSchema, field);
        }
        if (Map.class.isAssignableFrom(fieldClass) && fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 2 && finalField && (features & JSONReader.Feature.FieldBased.mask) == 0L) {
            return new FieldReaderMapFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, jsonSchema, field);
        }
        if (finalField) {
            if (fieldClass == int[].class) {
                return new FieldReaderInt32ValueArrayFinalField(fieldName, fieldClass, ordinal, features, format, (int[])defaultValue, jsonSchema, field);
            }
            if (fieldClass == long[].class) {
                return new FieldReaderInt64ValueArrayFinalField(fieldName, fieldClass, ordinal, features, format, (long[])defaultValue, jsonSchema, field);
            }
        }
        if (fieldClassResolved != null) {
            if ((features & 0x2000000000000L) != 0L && Map.class.isAssignableFrom(fieldClassResolved)) {
                return new FieldReaderMapFieldReadOnly(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, jsonSchema, field);
            }
            return new FieldReaderObjectField(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, defaultValue, jsonSchema, field);
        }
        if (fieldClass == LocalDateTime.class) {
            return new FieldReaderLocalDateTime(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, field, null, null);
        }
        if (fieldClass == ZonedDateTime.class) {
            return new FieldReaderZonedDateTime(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, field, null, null);
        }
        if (fieldClass == Instant.class) {
            return new FieldReaderInstant(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, field, null, null);
        }
        return new FieldReaderObjectField(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, jsonSchema, field);
    }

    public <T, V> FieldReader createFieldReader(String fieldName, Type fieldType, Class<V> fieldClass, long features, BiConsumer<T, V> function) {
        return this.createFieldReader(null, null, fieldName, fieldType, fieldClass, 0, features, null, null, null, null, null, function, null);
    }

    public <T, V> FieldReader createFieldReader(String fieldName, Type fieldType, Class<V> fieldClass, Method method, BiConsumer<T, V> function) {
        return this.createFieldReader(null, null, fieldName, fieldType, fieldClass, 0, 0L, null, null, null, null, method, function, null);
    }

    public <T, V> FieldReader createFieldReader(Class objectClass, Type objectType, String fieldName, Type fieldType, Class<V> fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, BiConsumer<T, V> function, ObjectReader initReader) {
        if (initReader != null) {
            FieldReaderObject fieldReaderObjectMethod = new FieldReaderObject(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, locale, defaultValue, schema, method, null, function);
            fieldReaderObjectMethod.initReader = initReader;
            return fieldReaderObjectMethod;
        }
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function);
        }
        if (fieldClass == Float.class) {
            return new FieldReaderFloatFunc<T>(fieldName, fieldClass, ordinal, features, format, locale, (Float)defaultValue, schema, method, function);
        }
        if (fieldClass == Double.class) {
            return new FieldReaderDoubleFunc<T>(fieldName, fieldClass, ordinal, features, format, locale, (Double)defaultValue, schema, method, function);
        }
        if (fieldClass == Number.class) {
            return new FieldReaderNumberFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, (Number)defaultValue, schema, method, function);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate<T>(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, null, method, function);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            TypeReference<?> objectTypeReference = objectType == null ? null : TypeReference.get(objectType);
            fieldTypeResolved = BeanUtils.getFieldType(objectTypeReference, objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Object itemType = Object.class;
            Class itemClass = Object.class;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1 && (itemClass = TypeUtils.getMapping((Type)(itemType = actualTypeArguments[0]))) == String.class) {
                return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, defaultValue, schema, method, null, function);
            }
            return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, (Type)itemType, itemClass, ordinal, features, format, locale, defaultValue, schema, method, null, function);
        }
        if (fieldTypeResolved != null) {
            return new FieldReaderObjectFunc<T, V>(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function, null);
        }
        return new FieldReaderObjectFunc<T, V>(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, function, null);
    }

    protected ObjectReader createEnumReader(Class objectClass, Method createMethod, ObjectReaderProvider provider) {
        Class fieldClassMixInSource;
        Object name;
        Enum e;
        int i;
        FieldInfo fieldInfo = new FieldInfo();
        Enum[] ordinalEnums = (Enum[])objectClass.getEnumConstants();
        LinkedHashMap<Long, Enum> enumMap = new LinkedHashMap<Long, Enum>();
        for (i = 0; ordinalEnums != null && i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hash = Fnv.hashCode64((String)name);
            enumMap.put(hash, e);
            try {
                fieldInfo.init();
                Field field = objectClass.getField((String)name);
                provider.getFieldInfo(fieldInfo, objectClass, field);
                String jsonFieldName = fieldInfo.fieldName;
                if (jsonFieldName != null && !jsonFieldName.isEmpty() && !jsonFieldName.equals(name)) {
                    long jsonFieldNameHash = Fnv.hashCode64(jsonFieldName);
                    enumMap.putIfAbsent(jsonFieldNameHash, e);
                }
                if (fieldInfo.alternateNames == null) continue;
                for (String alternateName : fieldInfo.alternateNames) {
                    if (alternateName == null || alternateName.isEmpty()) continue;
                    long alternateNameHash = Fnv.hashCode64(alternateName);
                    enumMap.putIfAbsent(alternateNameHash, e);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = 0; ordinalEnums != null && i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hashLCase = Fnv.hashCode64LCase((String)name);
            enumMap.putIfAbsent(hashLCase, e);
        }
        long[] enumNameHashCodes = new long[enumMap.size()];
        int i2 = 0;
        for (Long h : enumMap.keySet()) {
            enumNameHashCodes[i2++] = h;
        }
        Arrays.sort(enumNameHashCodes);
        Member enumValueField = BeanUtils.getEnumValueField(objectClass, provider);
        if (enumValueField == null && provider.modules.size() > 0 && (fieldClassMixInSource = provider.getMixIn(objectClass)) != null) {
            Member mixedValueField = BeanUtils.getEnumValueField(fieldClassMixInSource, provider);
            if (mixedValueField instanceof Field) {
                try {
                    enumValueField = objectClass.getField(mixedValueField.getName());
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else if (mixedValueField instanceof Method) {
                try {
                    enumValueField = objectClass.getMethod(mixedValueField.getName(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        Enum[] enums = new Enum[enumNameHashCodes.length];
        for (int i3 = 0; i3 < enumNameHashCodes.length; ++i3) {
            Enum e2;
            long hash = enumNameHashCodes[i3];
            enums[i3] = e2 = (Enum)enumMap.get(hash);
        }
        return new ObjectReaderImplEnum(objectClass, createMethod, enumValueField, enums, ordinalEnums, enumNameHashCodes);
    }

    static ObjectReader getInitReader(ObjectReaderProvider provider, Type fieldType, Class fieldClass, FieldInfo fieldInfo) {
        ObjectReader initReader = fieldInfo.getInitReader();
        if (initReader == null && Map.class.isAssignableFrom(fieldClass) && (fieldInfo.keyUsing != null || fieldInfo.valueUsing != null)) {
            ObjectReader reader;
            ObjectReader keyReader = null;
            if (fieldInfo.keyUsing != null) {
                try {
                    Constructor<?> constructor = fieldInfo.keyUsing.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    keyReader = (ObjectReader)constructor.newInstance(new Object[0]);
                }
                catch (Exception constructor) {
                    // empty catch block
                }
            }
            ObjectReader valueReader = null;
            if (fieldInfo.valueUsing != null) {
                try {
                    Constructor<?> constructor = fieldInfo.valueUsing.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    valueReader = (ObjectReader)constructor.newInstance(new Object[0]);
                }
                catch (Exception constructor) {
                    // empty catch block
                }
            }
            if ((keyReader != null || valueReader != null) && (reader = ObjectReaderImplMap.of(fieldType, fieldClass, fieldInfo.features)) instanceof ObjectReaderImplMapTyped) {
                ObjectReaderImplMapTyped mapReader = (ObjectReaderImplMapTyped)reader;
                if (keyReader != null) {
                    mapReader.keyObjectReader = keyReader;
                }
                if (valueReader != null) {
                    mapReader.valueObjectReader = valueReader;
                }
                return mapReader;
            }
        }
        if (initReader == null) {
            ObjectReader objectReader;
            if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                objectReader = provider.getObjectReader((Type)((Object)Long.class));
                if (objectReader != ObjectReaderImplInt64.INSTANCE) {
                    initReader = objectReader;
                }
            } else if (fieldClass == BigDecimal.class) {
                objectReader = provider.getObjectReader((Type)((Object)BigDecimal.class));
                if (objectReader != ObjectReaderImplBigDecimal.INSTANCE) {
                    initReader = objectReader;
                }
            } else if (fieldClass == BigInteger.class) {
                objectReader = provider.getObjectReader((Type)((Object)BigInteger.class));
                if (objectReader != ObjectReaderImplBigInteger.INSTANCE) {
                    initReader = objectReader;
                }
            } else if (fieldClass == Date.class && (objectReader = provider.getObjectReader((Type)((Object)Date.class))) != ObjectReaderImplDate.INSTANCE) {
                initReader = objectReader;
            }
        }
        return initReader;
    }

    protected <T> FieldReader createFieldReaderLambda(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, String schema, Type fieldType, Class fieldClass, Method method, ObjectReader initReader) {
        Object function;
        JSONObject object;
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        JSONSchema jsonSchema = null;
        if (schema != null && !schema.isEmpty() && !(object = JSON.parseObject(schema)).isEmpty()) {
            jsonSchema = JSONSchema.of(object, fieldClass);
        }
        if (initReader != null) {
            function = (BiConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return this.createFieldReader(objectClass, objectType, fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, (BiConsumer)function, initReader);
        }
        if (fieldType == Boolean.TYPE) {
            function = (ObjBoolConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderBoolValFunc(fieldName, ordinal, jsonSchema, method, function);
        }
        if (fieldType == Byte.TYPE) {
            function = (ObjByteConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderInt8ValueFunc(fieldName, ordinal, jsonSchema, method, function);
        }
        if (fieldType == Short.TYPE) {
            function = (ObjShortConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderInt16ValueFunc(fieldName, ordinal, features, format, locale, (Short)defaultValue, jsonSchema, method, function);
        }
        if (fieldType == Integer.TYPE) {
            function = (ObjIntConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderInt32ValueFunc(fieldName, ordinal, (Integer)defaultValue, jsonSchema, method, function);
        }
        if (fieldType == Long.TYPE) {
            function = (ObjLongConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderInt64ValueFunc(fieldName, ordinal, (Long)defaultValue, jsonSchema, method, function);
        }
        if (fieldType == Character.TYPE) {
            function = (ObjCharConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderCharValueFunc(fieldName, ordinal, format, (Character)defaultValue, jsonSchema, method, function);
        }
        if (fieldType == Float.TYPE) {
            function = (ObjFloatConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderFloatValueFunc(fieldName, ordinal, (Float)defaultValue, jsonSchema, method, function);
        }
        if (fieldType == Double.TYPE) {
            function = (ObjDoubleConsumer)this.lambdaSetter(objectClass, fieldClass, method);
            return new FieldReaderDoubleValueFunc(fieldName, ordinal, (Double)defaultValue, jsonSchema, method, function);
        }
        BiConsumer consumer = (BiConsumer)this.lambdaSetter(objectClass, fieldClass, method);
        return this.createFieldReader(objectClass, objectType, fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, jsonSchema, method, consumer, null);
    }

    protected Object lambdaSetter(Class objectClass, Class fieldClass, Method method) {
        MethodType invokedType;
        MethodType samMethodType;
        MethodHandles.Lookup lookup = JDKUtils.trustedLookup(objectClass);
        Class<?> returnType = method.getReturnType();
        LambdaSetterInfo lambdaInfo = methodTypeMapping.get(fieldClass);
        MethodType methodType = null;
        if (lambdaInfo != null) {
            samMethodType = lambdaInfo.sameMethodMethod;
            invokedType = lambdaInfo.invokedType;
            if (returnType == Void.TYPE) {
                methodType = lambdaInfo.methodType;
            }
        } else {
            samMethodType = TypeUtils.METHOD_TYPE_VOO;
            invokedType = TypeUtils.METHOD_TYPE_BI_CONSUMER;
        }
        if (methodType == null) {
            methodType = MethodType.methodType(returnType, fieldClass);
        }
        try {
            MethodHandle target = lookup.findVirtual(objectClass, method.getName(), methodType);
            MethodType instantiatedMethodType = MethodType.methodType(Void.TYPE, objectClass, fieldClass);
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "accept", invokedType, samMethodType, target, instantiatedMethodType);
            return callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new JSONException("create fieldReader error", e);
        }
    }

    public Function<Consumer, ByteArrayValueConsumer> createByteArrayValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return null;
    }

    public Function<Consumer, CharArrayValueConsumer> createCharArrayValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return null;
    }

    static {
        methodTypeMapping.put(Boolean.TYPE, new LambdaSetterInfo(Boolean.TYPE, ObjBoolConsumer.class));
        methodTypeMapping.put(Byte.TYPE, new LambdaSetterInfo(Byte.TYPE, ObjByteConsumer.class));
        methodTypeMapping.put(Short.TYPE, new LambdaSetterInfo(Short.TYPE, ObjShortConsumer.class));
        methodTypeMapping.put(Integer.TYPE, new LambdaSetterInfo(Integer.TYPE, ObjIntConsumer.class));
        methodTypeMapping.put(Long.TYPE, new LambdaSetterInfo(Long.TYPE, ObjLongConsumer.class));
        methodTypeMapping.put(Character.TYPE, new LambdaSetterInfo(Character.TYPE, ObjCharConsumer.class));
        methodTypeMapping.put(Float.TYPE, new LambdaSetterInfo(Float.TYPE, ObjFloatConsumer.class));
        methodTypeMapping.put(Double.TYPE, new LambdaSetterInfo(Double.TYPE, ObjDoubleConsumer.class));
    }

    static class LambdaSetterInfo {
        final Class fieldClass;
        final MethodType sameMethodMethod;
        final MethodType methodType;
        final MethodType invokedType;

        LambdaSetterInfo(Class fieldClass, Class functionClass) {
            this.fieldClass = fieldClass;
            this.sameMethodMethod = MethodType.methodType(Void.TYPE, Object.class, fieldClass);
            this.methodType = MethodType.methodType(Void.TYPE, fieldClass);
            this.invokedType = MethodType.methodType(functionClass);
        }
    }
}

