/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.transport.netty4;

import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import com.alibaba.nls.client.transport.netty4.NettyConnection;
import com.alibaba.nls.client.transport.netty4.WebSocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyWebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocketClient.class);
    static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = 2L;
    private final int handshakeTimeout;
    private final int heartbeatInterval;
    private final URI websocketURI;
    private int port;
    private SslContext sslCtx;
    EventLoopGroup group = new NioEventLoopGroup(0);
    Bootstrap bootstrap = new Bootstrap();

    public NettyWebSocketClient(String uriStr) throws Exception {
        this.handshakeTimeout = Integer.parseInt(System.getProperty("nls.ws.handshake.timeout", "10"));
        this.heartbeatInterval = Integer.parseInt(System.getProperty("nls.ws.heartbeat.interval", "0"));
        this.websocketURI = new URI(uriStr);
        boolean ssl = "wss".equalsIgnoreCase(this.websocketURI.getScheme());
        this.port = this.websocketURI.getPort();
        if (ssl) {
            this.sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            if (this.port == -1) {
                this.port = 443;
            }
        } else if (this.port == -1) {
            this.port = 80;
        }
        final String isCompression = System.getProperty("nls.ws.compression", "false");
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (NettyWebSocketClient.this.sslCtx != null) {
                    p.addLast(new ChannelHandler[]{NettyWebSocketClient.this.sslCtx.newHandler(ch.alloc(), NettyWebSocketClient.this.websocketURI.getHost(), 443)});
                }
                if ("true".equalsIgnoreCase(isCompression)) {
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE});
                } else {
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192)});
                }
                if (NettyWebSocketClient.this.heartbeatInterval > 0) {
                    p.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, NettyWebSocketClient.this.heartbeatInterval)});
                }
                p.addLast("hookedHandler", (ChannelHandler)new WebSocketClientHandler());
            }
        });
    }

    public Connection connect(String token, ConnectionListener listener, int connectionTimeout) throws Exception {
        return this.connect(token, listener, connectionTimeout, this.websocketURI);
    }

    public Connection connect(String token, ConnectionListener listener, int connectionTimeout, URI newUri) throws Exception {
        URI connectUri = null;
        connectUri = newUri == null ? this.websocketURI : newUri;
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeout);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        httpHeaders.set("X-NLS-Token", (Object)token);
        String authHeader = System.getenv("HTTP_HEADER_AUTHORIZATION");
        if (authHeader != null) {
            httpHeaders.set("Authorization", (Object)authHeader);
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)connectUri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)httpHeaders, (int)196608);
        long start = System.currentTimeMillis();
        Channel channel = this.bootstrap.connect(connectUri.getHost(), this.port).sync().channel();
        long connectingTime = System.currentTimeMillis() - start;
        logger.debug("websocket channel is established after sync,connectionId:{} ,use {}", (Object)channel.id(), (Object)connectingTime);
        WebSocketClientHandler handler = (WebSocketClientHandler)channel.pipeline().get("hookedHandler");
        handler.setListener(listener);
        handler.setHandshaker(handshaker);
        handshaker.handshake(channel);
        start = System.currentTimeMillis();
        this.waitHandshake(handler.handshakeFuture(), channel);
        long handshakeTime = System.currentTimeMillis() - start;
        logger.debug("websocket connection is established after handshake,connectionId:{},use {}", (Object)channel.id(), (Object)handshakeTime);
        return new NettyConnection(channel, connectingTime, handshakeTime);
    }

    public void shutdown() {
        this.group.shutdownGracefully();
    }

    public void shutdown(long timeout, TimeUnit unit) {
        this.group.shutdownGracefully(2L, timeout, unit);
    }

    private void waitHandshake(ChannelFuture handshakeFuture, Channel channel) throws Exception {
        if (handshakeFuture.await((long)this.handshakeTimeout, TimeUnit.SECONDS)) {
            return;
        }
        if (channel.isActive()) {
            channel.close();
        }
        if (handshakeFuture.cause() != null) {
            throw new Exception("Handshake timeout!", handshakeFuture.cause());
        }
        throw new Exception("Handshake timeout!");
    }
}

