/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.asr;

import com.alibaba.nls.client.protocol.InputFormatEnum;
import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.SampleRateEnum;
import com.alibaba.nls.client.protocol.SpeechReqProtocol;
import com.alibaba.nls.client.protocol.asr.SpeechTranscriberListener;
import com.alibaba.nls.client.transport.Connection;
import com.alibaba.nls.client.transport.ConnectionListener;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechTranscriber
extends SpeechReqProtocol {
    static Logger logger = LoggerFactory.getLogger(SpeechTranscriber.class);
    private CountDownLatch completeLatch;
    private CountDownLatch readyLatch;
    protected long lastSendTime = -1L;
    protected SpeechTranscriberListener speechTranscriberListener;
    private static final String DEFAULT_FORMAT = "pcm";
    private static final Integer DEFAULT_SAMPLE_RATE = 16000;

    public SpeechTranscriberListener getSpeechTranscriberListener() {
        return this.speechTranscriberListener;
    }

    public String getFormat() {
        return (String)this.payload.get("format");
    }

    public void setFormat(InputFormatEnum format) {
        this.payload.put("format", format.getName());
    }

    public Integer getSampleRate() {
        return (Integer)this.payload.get("sample_rate");
    }

    public void setSampleRate(SampleRateEnum sampleRate) {
        this.payload.put("sample_rate", sampleRate.value);
    }

    public void setEnableIntermediateResult(boolean isEnable) {
        this.payload.put("enable_intermediate_result", isEnable);
    }

    public void setEnablePunctuation(boolean isEnable) {
        this.payload.put("enable_punctuation_prediction", isEnable);
    }

    public void setEnableITN(boolean enableITN) {
        this.payload.put("enable_inverse_text_normalization", enableITN);
    }

    public SpeechTranscriber(NlsClient client, SpeechTranscriberListener listener) throws Exception {
        this.conn = client.connect((ConnectionListener)listener);
        this.afterConnection(listener);
    }

    public SpeechTranscriber(NlsClient client, String token, SpeechTranscriberListener listener) throws Exception {
        Connection conn;
        this.conn = conn = client.connect(token, (ConnectionListener)listener);
        this.afterConnection(listener);
    }

    public SpeechTranscriber(NlsClient client, String token, SpeechTranscriberListener listener, String newUrl) throws Exception {
        URI newUri = new URI(newUrl);
        this.conn = client.connect(token, (ConnectionListener)listener, newUri);
        this.afterConnection(listener);
    }

    protected void afterConnection(SpeechTranscriberListener listener) {
        this.payload = new HashMap();
        this.header.put("namespace", "SpeechTranscriber");
        this.header.put("name", "StartTranscription");
        this.payload.put("format", DEFAULT_FORMAT);
        this.payload.put("sample_rate", DEFAULT_SAMPLE_RATE);
        listener.setSpeechTranscriber(this);
        this.speechTranscriberListener = listener;
        this.state = SpeechReqProtocol.State.STATE_CONNECTED;
    }

    public void send(byte[] data) {
        this.send(data, data.length);
    }

    public void send(byte[] data, int length) {
        long sendInterval;
        if (this.lastSendTime != -1L && (sendInterval = System.currentTimeMillis() - this.lastSendTime) > 5000L) {
            logger.warn("too large binary send interval: {} million second", (Object)sendInterval);
        }
        this.state.checkSend();
        try {
            this.conn.sendBinary(Arrays.copyOfRange(data, 0, length));
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void send(InputStream ins) {
        this.state.checkSend();
        try {
            byte[] bytes = new byte[8000];
            int len = 0;
            while ((len = ins.read(bytes)) > 0) {
                long sendInterval;
                if (this.lastSendTime != -1L && (sendInterval = System.currentTimeMillis() - this.lastSendTime) > 5000L) {
                    logger.warn("too large binary send interval: {} million second", (Object)sendInterval);
                }
                this.conn.sendBinary(Arrays.copyOfRange(bytes, 0, len));
                this.lastSendTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void send(InputStream ins, int batchSize, int sleepInterval) {
        this.state.checkSend();
        try {
            byte[] bytes = new byte[batchSize];
            int len = 0;
            while ((len = ins.read(bytes)) > 0) {
                long sendInterval;
                if (this.lastSendTime != -1L && (sendInterval = System.currentTimeMillis() - this.lastSendTime) > 5000L) {
                    logger.warn("too large binary send interval: {} million second", (Object)sendInterval);
                }
                this.conn.sendBinary(Arrays.copyOfRange(bytes, 0, len));
                this.lastSendTime = System.currentTimeMillis();
                Thread.sleep(sleepInterval);
            }
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.currentTaskId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    void markTranscriberReady() {
        this.state = SpeechReqProtocol.State.STATE_REQUEST_CONFIRMED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
    }

    void markTranscriberComplete() {
        this.state = SpeechReqProtocol.State.STATE_COMPLETE;
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markFail() {
        this.state = SpeechReqProtocol.State.STATE_FAIL;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    void markClosed() {
        this.state = SpeechReqProtocol.State.STATE_CLOSED;
        if (this.readyLatch != null) {
            this.readyLatch.countDown();
        }
        if (this.completeLatch != null) {
            this.completeLatch.countDown();
        }
    }

    @Deprecated
    public void controlTranscriber(Map<String, Object> context) {
        this.sendControlMessage(null, context);
    }

    public void sendControlMessage(Map<String, Object> payload, Map<String, Object> context) {
        SpeechReqProtocol req = new SpeechReqProtocol();
        req.setAppKey(this.getAppKey());
        req.header.put("namespace", "SpeechTranscriber");
        req.header.put("name", "ControlTranscriber");
        req.header.put("task_id", this.currentTaskId);
        req.payload = payload;
        req.context = context;
        this.conn.sendText(req.serializeWithContext());
    }

    public void start() throws Exception {
        this.start(10000L);
    }

    public void start(long milliSeconds) throws Exception {
        super.start();
        this.completeLatch = new CountDownLatch(1);
        this.readyLatch = new CountDownLatch(1);
        boolean result = this.readyLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for start confirmation.task_id:%s,state:%s", milliSeconds, this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void stop() throws Exception {
        this.stop(10000L);
    }

    public void stop(long milliSeconds) throws Exception {
        this.state.checkStop();
        SpeechReqProtocol req = new SpeechReqProtocol();
        req.header.put("task_id", this.currentTaskId);
        req.header.put("namespace", "SpeechTranscriber");
        req.header.put("name", "StopTranscription");
        req.setAppKey(this.getAppKey());
        this.conn.sendText(req.serialize());
        this.state = SpeechReqProtocol.State.STATE_STOP_SENT;
        boolean result = this.completeLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for complete confirmation.task_id:%s,state:%s", milliSeconds, this.currentTaskId, this.state);
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void close() {
        this.conn.close();
    }
}

