/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.client;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.impl.ClusterCanalConnector;
import com.alibaba.otter.canal.client.impl.ClusterNodeAccessStrategy;
import com.alibaba.otter.canal.client.impl.SimpleCanalConnector;
import com.alibaba.otter.canal.client.impl.SimpleNodeAccessStrategy;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import java.net.SocketAddress;
import java.util.List;

public class CanalConnectors {
    public static CanalConnector newSingleConnector(SocketAddress address, String destination, String username, String password) {
        SimpleCanalConnector canalConnector = new SimpleCanalConnector(address, username, password, destination);
        canalConnector.setSoTimeout(60000);
        canalConnector.setIdleTimeout(3600000);
        return canalConnector;
    }

    public static CanalConnector newClusterConnector(List<? extends SocketAddress> addresses, String destination, String username, String password) {
        ClusterCanalConnector canalConnector = new ClusterCanalConnector(username, password, destination, new SimpleNodeAccessStrategy(addresses));
        canalConnector.setSoTimeout(60000);
        canalConnector.setIdleTimeout(3600000);
        return canalConnector;
    }

    public static CanalConnector newClusterConnector(String zkServers, String destination, String username, String password) {
        ClusterCanalConnector canalConnector = new ClusterCanalConnector(username, password, destination, new ClusterNodeAccessStrategy(destination, ZkClientx.getZkClient((String)zkServers)));
        canalConnector.setSoTimeout(60000);
        canalConnector.setIdleTimeout(3600000);
        return canalConnector;
    }
}

