/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.op.CanClone;
import com.ql.util.express.instruction.op.OperatorAdd;
import com.ql.util.express.instruction.op.OperatorAlias;
import com.ql.util.express.instruction.op.OperatorAnd;
import com.ql.util.express.instruction.op.OperatorAnonymousNewArray;
import com.ql.util.express.instruction.op.OperatorAnonymousNewList;
import com.ql.util.express.instruction.op.OperatorAnonymousNewMap;
import com.ql.util.express.instruction.op.OperatorArray;
import com.ql.util.express.instruction.op.OperatorBase;
import com.ql.util.express.instruction.op.OperatorBit;
import com.ql.util.express.instruction.op.OperatorBreak;
import com.ql.util.express.instruction.op.OperatorCast;
import com.ql.util.express.instruction.op.OperatorContinue;
import com.ql.util.express.instruction.op.OperatorDef;
import com.ql.util.express.instruction.op.OperatorDoubleAddReduce;
import com.ql.util.express.instruction.op.OperatorEqualsLessMore;
import com.ql.util.express.instruction.op.OperatorEvaluate;
import com.ql.util.express.instruction.op.OperatorExportAlias;
import com.ql.util.express.instruction.op.OperatorExportDef;
import com.ql.util.express.instruction.op.OperatorFunction;
import com.ql.util.express.instruction.op.OperatorIn;
import com.ql.util.express.instruction.op.OperatorKeyValue;
import com.ql.util.express.instruction.op.OperatorLike;
import com.ql.util.express.instruction.op.OperatorMacro;
import com.ql.util.express.instruction.op.OperatorMultiDiv;
import com.ql.util.express.instruction.op.OperatorNew;
import com.ql.util.express.instruction.op.OperatorNor;
import com.ql.util.express.instruction.op.OperatorNot;
import com.ql.util.express.instruction.op.OperatorOr;
import com.ql.util.express.instruction.op.OperatorReduce;
import com.ql.util.express.instruction.op.OperatorReturn;
import com.ql.util.express.parse.ExpressNode;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class OperatorFactory {
    protected boolean isPrecise = false;
    private Map<String, OperatorBase> operator = new HashMap<String, OperatorBase>();

    public OperatorFactory(boolean aIsPrecise) {
        this.isPrecise = aIsPrecise;
        this.addOperator("new", new OperatorNew("new"));
        this.addOperator("anonymousNewArray", new OperatorAnonymousNewArray("anonymousNewArray"));
        this.addOperator("NewList", new OperatorAnonymousNewList("NewList"));
        this.addOperator(":", new OperatorKeyValue(":"));
        this.addOperator("NewMap", new OperatorAnonymousNewMap("NewMap"));
        this.addOperator("def", new OperatorDef("def"));
        this.addOperator("exportDef", new OperatorExportDef("exportDef"));
        this.addOperator("!", new OperatorNot("!"));
        this.addOperator("*", new OperatorMultiDiv("*"));
        this.addOperator("/", new OperatorMultiDiv("/"));
        this.addOperator("%", new OperatorMultiDiv("%"));
        this.addOperator("mod", new OperatorMultiDiv("mod"));
        this.addOperator("+", new OperatorAdd("+"));
        this.addOperator("-", new OperatorReduce("-"));
        this.addOperator("<", new OperatorEqualsLessMore("<"));
        this.addOperator(">", new OperatorEqualsLessMore(">"));
        this.addOperator("<=", new OperatorEqualsLessMore("<="));
        this.addOperator(">=", new OperatorEqualsLessMore(">="));
        this.addOperator("==", new OperatorEqualsLessMore("=="));
        this.addOperator("!=", new OperatorEqualsLessMore("!="));
        this.addOperator("<>", new OperatorEqualsLessMore("<>"));
        this.addOperator("&&", new OperatorAnd("&&"));
        this.addOperator("||", new OperatorOr("||"));
        this.addOperator("nor", new OperatorNor("nor"));
        this.addOperator("=", new OperatorEvaluate("="));
        this.addOperator("exportAlias", new OperatorExportAlias("exportAlias"));
        this.addOperator("alias", new OperatorAlias("alias"));
        this.addOperator("break", new OperatorBreak("break"));
        this.addOperator("continue", new OperatorContinue("continue"));
        this.addOperator("return", new OperatorReturn("return"));
        this.addOperator("ARRAY_CALL", new OperatorArray("ARRAY_CALL"));
        this.addOperator("++", new OperatorDoubleAddReduce("++"));
        this.addOperator("--", new OperatorDoubleAddReduce("--"));
        this.addOperator("cast", new OperatorCast("cast"));
        this.addOperator("macro", new OperatorMacro("macro"));
        this.addOperator("function", new OperatorFunction("function"));
        this.addOperator("in", new OperatorIn("in"));
        this.addOperator("like", new OperatorLike("like"));
        this.addOperator("&", new OperatorBit("&"));
        this.addOperator("|", new OperatorBit("|"));
        this.addOperator("^", new OperatorBit("^"));
        this.addOperator("~", new OperatorBit("~"));
        this.addOperator("<<", new OperatorBit("<<"));
        this.addOperator(">>", new OperatorBit(">>"));
    }

    public void addOperator(String name, OperatorBase op) {
        OperatorBase oldOp = this.operator.get(name);
        if (oldOp != null) {
            throw new RuntimeException("\u91cd\u590d\u5b9a\u4e49\u64cd\u4f5c\u7b26\uff1a" + name + "\u5b9a\u4e491\uff1a" + oldOp.getClass() + " \u5b9a\u4e492\uff1a" + op.getClass());
        }
        op.setPrecise(this.isPrecise);
        op.setAliasName(name);
        this.operator.put(name, op);
    }

    public OperatorBase replaceOperator(String name, OperatorBase op) {
        OperatorBase old = this.operator.remove(name);
        this.addOperator(name, op);
        return old;
    }

    public void addOperatorWithAlias(String aAliasName, String name, String errorInfo) throws Exception {
        if (!this.operator.containsKey(name)) {
            throw new QLException(name + " \u4e0d\u662f\u7cfb\u7edf\u7ea7\u522b\u7684\u64cd\u4f5c\u7b26\u53f7\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u522b\u540d");
        }
        OperatorBase orgiOperator = this.operator.get(name);
        if (orgiOperator == null) {
            throw new QLException(name + " \u4e0d\u80fd\u88ab\u8bbe\u7f6e\u522b\u540d");
        }
        OperatorBase destOperator = null;
        if (orgiOperator instanceof CanClone) {
            destOperator = ((CanClone)((Object)orgiOperator)).cloneMe(aAliasName, errorInfo);
        } else {
            Class<?> opClass = orgiOperator.getClass();
            Constructor<?> constructor = null;
            try {
                constructor = opClass.getConstructor(String.class, String.class, String.class);
            }
            catch (Exception e) {
                throw new QLException(name + " \u4e0d\u80fd\u88ab\u8bbe\u7f6e\u522b\u540d:" + e.getMessage());
            }
            if (constructor == null) {
                throw new QLException(name + " \u4e0d\u80fd\u88ab\u8bbe\u7f6e\u522b\u540d");
            }
            destOperator = (OperatorBase)constructor.newInstance(aAliasName, name, errorInfo);
        }
        if (this.operator.containsKey(aAliasName)) {
            throw new RuntimeException("\u64cd\u4f5c\u7b26\u53f7\uff1a\"" + aAliasName + "\" \u5df2\u7ecf\u5b58\u5728");
        }
        this.addOperator(aAliasName, destOperator);
    }

    public boolean isExistOperator(String operName) throws Exception {
        return this.operator.containsKey(operName);
    }

    public OperatorBase getOperator(String aOperName) {
        return this.operator.get(aOperName);
    }

    public OperatorBase newInstance(ExpressNode opItem) throws Exception {
        OperatorBase op = this.operator.get(opItem.getNodeType().getName());
        if (op == null) {
            op = this.operator.get(opItem.getTreeType().getName());
        }
        if (op == null) {
            op = this.operator.get(opItem.getValue());
        }
        if (op == null) {
            throw new QLCompileException("\u6ca1\u6709\u4e3a\"" + opItem.getValue() + "\"\u5b9a\u4e49\u64cd\u4f5c\u7b26\u5904\u7406\u5bf9\u8c61");
        }
        return op;
    }

    public OperatorBase newInstance(String opName) throws Exception {
        OperatorBase op = this.operator.get(opName);
        if (op == null) {
            throw new QLCompileException("\u6ca1\u6709\u4e3a\"" + opName + "\"\u5b9a\u4e49\u64cd\u4f5c\u7b26\u5904\u7406\u5bf9\u8c61");
        }
        return op;
    }
}

