/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.embeddings;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.embeddings.MultiModalEmbeddingParam;
import com.alibaba.dashscope.embeddings.MultiModalEmbeddingResult;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.utils.PreprocessMessageInput;

public class MultiModalEmbedding {
    private final SynchronizeHalfDuplexApi<MultiModalEmbeddingParam> syncApi;
    private final ApiServiceOption serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.EMBEDDINGS.getValue())).task(Task.MULTIMODAL_EMBEDDING.getValue())).function(Function.MULTIMODAL_EMBEDDING.getValue())).build();

    public MultiModalEmbedding() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public void call(MultiModalEmbeddingParam param, final ResultCallback<MultiModalEmbeddingResult> callback) throws ApiException, NoApiKeyException, UploadFileException {
        this.preprocessInput(param);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(MultiModalEmbeddingResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public MultiModalEmbeddingResult call(MultiModalEmbeddingParam param) throws ApiException, NoApiKeyException, UploadFileException {
        this.preprocessInput(param);
        return MultiModalEmbeddingResult.fromDashScopeResult(this.syncApi.call(param));
    }

    private void preprocessInput(MultiModalEmbeddingParam param) throws NoApiKeyException, UploadFileException {
        boolean isUpload = PreprocessMessageInput.preProcessMessageInputs(param.getModel(), param.getContent(), param.getApiKey());
        if (isUpload) {
            param.putHeader("X-DashScope-OssResourceResolve", "enable");
        }
    }

    public static class Models {
        public static final String MULTIMODAL_EMBEDDING_ONE_PEACE_V1 = "multimodal-embedding-one-peace-v1";
    }
}

