/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLArrayExpr
extends SQLExprImpl
implements SQLReplaceable {
    private SQLExpr expr;
    private List<SQLExpr> values = new ArrayList<SQLExpr>();

    @Override
    public SQLArrayExpr clone() {
        SQLArrayExpr x = new SQLArrayExpr();
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        for (SQLExpr value : this.values) {
            SQLExpr value2 = value.clone();
            value2.setParent(x);
            x.values.add(value2);
        }
        return x;
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.expr = x;
    }

    public List<SQLExpr> getValues() {
        return this.values;
    }

    public void addValue(SQLExpr value) {
        value.setParent(this);
        this.values.add(value);
    }

    public void setValues(List<SQLExpr> values) {
        this.values = values;
        if (values != null) {
            for (SQLExpr value : values) {
                value.setParent(this);
            }
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.expr != null) {
                this.expr.accept(visitor);
            }
            if (this.values != null) {
                for (SQLExpr value : this.values) {
                    if (value == null) continue;
                    value.accept(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.add(this.expr);
        children.addAll(this.values);
        return children;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLArrayExpr other = (SQLArrayExpr)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) != expr) continue;
            target.setParent(this);
            this.values.set(i, target);
            return true;
        }
        return false;
    }
}

