/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import java.util.Calendar;

public enum SQLIntervalUnit {
    YEAR,
    YEAR_MONTH,
    QUARTER,
    MONTH,
    WEEK,
    DAY,
    DAY_HOUR,
    DAY_MINUTE,
    DAY_SECOND,
    DAY_MICROSECOND,
    HOUR,
    HOUR_MINUTE,
    HOUR_SECOND,
    HOUR_MICROSECOND,
    MINUTE,
    MINUTE_SECOND,
    MINUTE_MICROSECOND,
    SECOND,
    SECOND_MICROSECOND,
    MICROSECOND,
    DAY_OF_WEEK,
    DOW,
    DAY_OF_MONTH,
    DAY_OF_YEAR,
    YEAR_OF_WEEK,
    YOW,
    TIMEZONE_HOUR,
    TIMEZONE_MINUTE,
    DOY,
    YEAR_TO_MONTH("YEAR TO MONTH");

    public final String name;
    public final String nameLCase;

    private SQLIntervalUnit(String name) {
        this.name = name;
        this.nameLCase = name.toLowerCase();
    }

    private SQLIntervalUnit() {
        this.name = this.name();
        this.nameLCase = this.name.toLowerCase();
    }

    public static boolean add(Calendar calendar, int intervalInt, SQLIntervalUnit unit) {
        switch (unit.ordinal()) {
            case 0: {
                calendar.add(1, intervalInt);
                return true;
            }
            case 3: {
                calendar.add(2, intervalInt);
                return true;
            }
            case 4: {
                calendar.add(4, intervalInt);
                return true;
            }
            case 5: {
                calendar.add(5, intervalInt);
                return true;
            }
            case 10: {
                calendar.add(11, intervalInt);
                return true;
            }
            case 14: {
                calendar.add(12, intervalInt);
                return true;
            }
            case 17: {
                calendar.add(13, intervalInt);
                return true;
            }
            case 19: {
                calendar.add(14, intervalInt);
                return true;
            }
        }
        return false;
    }

    public boolean isDateTime() {
        switch (this.ordinal()) {
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static SQLIntervalUnit of(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (str = str.toUpperCase()) {
            case "YEARS": {
                return YEAR;
            }
            case "MONTHS": {
                return MONTH;
            }
            case "WEEKS": {
                return WEEK;
            }
            case "DAYS": {
                return DAY;
            }
            case "HOURS": {
                return HOUR;
            }
            case "MINUTES": {
                return MINUTE;
            }
            case "SECONDS": {
                return SECOND;
            }
        }
        for (SQLIntervalUnit value : SQLIntervalUnit.values()) {
            if (!value.name().equals(str)) continue;
            return value;
        }
        return null;
    }
}

