/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Job;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.LogType;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class Instance
extends LazyLoad {
    private String project;
    private Map<String, Result> results;
    private boolean isSync = false;
    private TaskStatusModel model;
    private Status status;
    private RestClient client;
    private Odps odps;
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private boolean hookInvoked = false;
    private OdpsHooks hooks;

    Instance(String project, TaskStatusModel model, Map<String, Result> results, Odps odps) {
        this.project = project;
        this.model = model;
        this.results = results;
        if (model.status != null) {
            this.status = Status.valueOf(model.status.toUpperCase());
        }
        if (results != null && results.size() > 0) {
            this.isSync = true;
            this.status = Status.TERMINATED;
        }
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    @Override
    public void reload() throws OdpsException {
        this.reload(false);
    }

    private void reload(boolean isBlock) throws OdpsException {
        HashMap<String, String> params = null;
        if (isBlock) {
            params = new HashMap<String, String>();
            params.put("instancestatus", null);
        }
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        this.model.owner = resp.getHeaders().get("x-odps-owner");
        String startTimeStr = resp.getHeaders().get("x-odps-start-time");
        String endTimeStr = resp.getHeaders().get("x-odps-end-time");
        try {
            this.model.startTime = DateUtils.parseRfc822Date(startTimeStr);
        }
        catch (ParseException e) {
            throw new OdpsException("Invalid response, x-odps-start-time:" + startTimeStr);
        }
        try {
            this.model.endTime = DateUtils.parseRfc822Date(endTimeStr);
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            InstanceStatusModel sm = SimpleXmlUtils.unmarshal(resp, InstanceStatusModel.class);
            this.status = Status.valueOf(sm.status.toUpperCase());
        }
        catch (Exception e) {
            throw new OdpsException("Invalid instance status response.", e);
        }
    }

    public void stop() throws OdpsException {
        InstanceStatusModel sm = new InstanceStatusModel();
        sm.status = "Terminated";
        try {
            String ret = SimpleXmlUtils.marshal(sm);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            this.client.stringRequest(this.getResource(), "PUT", null, headers, ret);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Map<String, Result> getTaskResultsWithFormat() throws OdpsException {
        if (this.isSync) {
            return this.results;
        }
        this.results = new HashMap<String, Result>();
        for (InstanceResultModel.TaskResult r : this.getRawTaskResults()) {
            this.results.put(r.name, r.result);
        }
        return this.results;
    }

    public Map<String, String> getTaskResults() throws OdpsException {
        Map<String, Result> results = this.getTaskResultsWithFormat();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Result> entry : results.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getString());
        }
        return result;
    }

    public List<InstanceResultModel.TaskResult> getRawTaskResults() throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("result", null);
        InstanceResultModel instanceResult = this.client.request(InstanceResultModel.class, this.getResource(), "GET", params);
        return instanceResult.taskResults;
    }

    public String getRawSubqueryResults(String subqueryId, String taskName) throws OdpsException {
        String ret;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("result", null);
        params.put("subquery_id", subqueryId);
        InstanceResultModel instanceResult = this.client.request(InstanceResultModel.class, this.getResource(), "GET", params);
        this.results = new HashMap<String, Result>();
        for (InstanceResultModel.TaskResult r : instanceResult.taskResults) {
            this.results.put(r.name, r.result);
        }
        taskName = taskName + "_" + subqueryId;
        try {
            ret = this.results.get(taskName).getString();
        }
        catch (NullPointerException e) {
            throw new OdpsException("Task result not found, please run query again.");
        }
        return ret;
    }

    public TaskCost getTaskCost(String taskName) throws OdpsException {
        TaskSummary summary = this.getTaskSummary(taskName);
        if (summary == null) {
            return null;
        }
        try {
            if (summary.get("Cost") != null) {
                Map taskCostMap = (Map)summary.get("Cost");
                TaskCost cost = new TaskCost();
                if (taskCostMap.get("CPU") != null) {
                    cost.setCPUCost(((Long)taskCostMap.get("CPU")).intValue());
                }
                if (taskCostMap.get("Memory") != null) {
                    cost.setMemoryCost(((Long)taskCostMap.get("Memory")).intValue());
                }
                if (taskCostMap.get("Input") != null) {
                    cost.setInputSize(((Long)taskCostMap.get("Input")).intValue());
                }
                return cost;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getTaskInfo(String taskName, String infoKey) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("info", null);
        params.put("taskname", taskName);
        params.put("key", infoKey);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        try {
            return new String(result.getBody(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e);
        }
    }

    @Deprecated
    public String setTaskInfo(String taskName, String infoKey, String infoValue) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("info", null);
        params.put("taskname", taskName);
        InstanceTaskInfoModel sm = new InstanceTaskInfoModel();
        sm.key = infoKey;
        sm.value = infoValue;
        try {
            String kv = SimpleXmlUtils.marshal(sm);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            Response result = this.client.stringRequest(this.getResource(), "PUT", params, headers, kv);
            return new String(result.getBody(), "utf-8");
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public SetInformationResult setInformation(String taskName, String infoKey, String infoValue) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("info", null);
        params.put("taskname", taskName);
        InstanceTaskInfoModel sm = new InstanceTaskInfoModel();
        sm.key = infoKey;
        sm.value = infoValue;
        Response result = null;
        try {
            String kv = SimpleXmlUtils.marshal(sm);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            result = this.client.stringRequest(this.getResource(), "PUT", params, headers, kv);
            Type type = new TypeToken<SetInformationResult>(){}.getType();
            SetInformationResult setInformationResult = (SetInformationResult)gson.fromJson(new String(result.getBody(), "utf-8"), type);
            if (setInformationResult == null) {
                throw new OdpsException("Parse response json failed:" + String.valueOf(result.getBody()));
            }
            return setInformationResult;
        }
        catch (JsonParseException e) {
            throw new OdpsException("Parse response json failed, body:" + String.valueOf(result.getBody()) + " Error:" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public TaskSummary getTaskSummary(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancesummary", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        TaskSummary summary = null;
        try {
            Gson gson = GsonObjectBuilder.get();
            Map map = (Map)gson.fromJson(new String(result.getBody()), new TypeToken<Map<Object, Object>>(){}.getType());
            if (map.get("Instance") != null) {
                Map mapReduce = (Map)map.get("Instance");
                String jsonSummary = (String)mapReduce.get("JsonSummary");
                if (jsonSummary != null) {
                    summary = (TaskSummary)gson.fromJson(jsonSummary, TaskSummary.class);
                }
                if (summary != null) {
                    summary.setSummaryText((String)mapReduce.get("Summary"));
                    summary.setJsonSummary(jsonSummary);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return summary;
    }

    public Map<String, TaskStatus> getTaskStatus() throws OdpsException {
        HashMap<String, TaskStatus> taskStatus = new HashMap<String, TaskStatus>();
        TaskStatusModel taskStatusModel = this.model;
        if (!this.isSync || !this.hasTaskStatus(taskStatusModel)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taskstatus", null);
            taskStatusModel = this.client.request(TaskStatusModel.class, this.getResource(), "GET", params);
        }
        for (TaskStatusModel.InstanceTaskModel taskModel : taskStatusModel.tasks) {
            TaskStatus status = new TaskStatus(taskModel);
            taskStatus.put(status.getName(), status);
        }
        return taskStatus;
    }

    private boolean hasTaskStatus(TaskStatusModel model) {
        for (TaskStatusModel.InstanceTaskModel taskModel : model.tasks) {
            TaskStatus status = new TaskStatus(taskModel);
            if (((TaskStatus)status).model.status != null) continue;
            return false;
        }
        return true;
    }

    public Set<String> getTaskNames() throws OdpsException {
        return this.getTaskStatus().keySet();
    }

    public boolean isSuccessful() throws OdpsException {
        boolean r = true;
        Map<String, TaskStatus> status = this.getTaskStatus();
        for (TaskStatus s : status.values()) {
            if (s.getStatus() == TaskStatus.Status.SUCCESS) continue;
            r = false;
            break;
        }
        return r;
    }

    public void waitForSuccess() throws OdpsException {
        this.waitForSuccess(1000L);
    }

    public void waitForSuccess(long interval) throws OdpsException {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!this.isSuccessful()) {
            for (Map.Entry<String, TaskStatus> e : this.getTaskStatus().entrySet()) {
                if (e.getValue().getStatus() == TaskStatus.Status.FAILED) {
                    throw new OdpsException(this.getTaskResults().get(e.getKey()));
                }
                if (e.getValue().getStatus() == TaskStatus.Status.SUCCESS) continue;
                throw new OdpsException(e.getKey() + ", Status=" + (Object)((Object)e.getValue().getStatus()));
            }
        }
    }

    public static String getStageProgressFormattedString(List<StageProgress> stages) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sim.format(new Date());
        result.append(dateString + ' ');
        for (StageProgress stage : stages) {
            result.append(String.format("%s:%s/%s/%s%s%s", stage.getName(), stage.getRunningWorkers(), stage.getTerminatedWorkers(), stage.getTotalWorkers(), stage.getBackupWorkers() > 0 ? "(+" + stage.getBackupWorkers() + " backups)" : "", "[" + stage.getFinishedPercentage() + "%]\t"));
        }
        return result.toString();
    }

    public List<StageProgress> getTaskProgress(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceprogress", taskName);
        params.put("taskname", taskName);
        TaskProgress r = this.client.request(TaskProgress.class, this.getResource(), "GET", params);
        return r.getStages();
    }

    public Odps getOdps() {
        return this.odps;
    }

    public String getId() {
        return this.model.name;
    }

    public Status getStatus(boolean isBlock) {
        if (this.status != Status.TERMINATED) {
            try {
                this.reload(isBlock);
            }
            catch (OdpsException e) {
                throw new ReloadException(e.getMessage(), e);
            }
        }
        try {
            if (this.hooks != null && this.status == Status.TERMINATED && !this.hookInvoked) {
                this.hookInvoked = true;
                this.hooks.after(this, this.odps);
            }
        }
        catch (OdpsException e) {
            throw new ReloadException(e.getMessage(), e);
        }
        return this.status;
    }

    public Status getStatus() {
        return this.getStatus(false);
    }

    public boolean isTerminated() {
        return this.getStatus() == Status.TERMINATED;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getStartTime() {
        if (this.model.startTime == null) {
            this.lazyLoad();
        }
        return this.model.startTime;
    }

    public Date getEndTime() {
        if (this.model.endTime == null) {
            this.lazyLoad();
        }
        return this.model.endTime;
    }

    public List<Task> getTasks() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getTasks();
    }

    public int getPriority() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getPriority();
    }

    private Job getJob(String resource) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", null);
        Job.JobModel model = this.client.request(Job.JobModel.class, resource, "GET", params, null, null);
        return new Job(model);
    }

    public String getJobName() throws OdpsException {
        String resource = this.getResource();
        return this.getJob(resource).getName();
    }

    private String getResource() {
        return ResourceBuilder.buildInstanceResource(this.project, this.model.name);
    }

    public String getLog(String workerId, LogType logType, int size) throws OdpsException {
        if (workerId == null) {
            throw new OdpsException("Missing argument: workerId");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("log", null);
        params.put("id", workerId);
        if (logType != null) {
            params.put("logtype", logType.toString());
        }
        if (size > 0) {
            params.put("size", String.valueOf(size));
        }
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(resp.getBody());
    }

    public String getTaskDetailJson(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancedetail", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result.getBody());
    }

    public OdpsHooks getOdpsHooks() {
        return this.hooks;
    }

    public void setOdpsHooks(OdpsHooks hooks) {
        this.hooks = hooks;
    }

    public boolean isHookInvoked() {
        return this.hookInvoked;
    }

    public void setHookInvoked(boolean hookInvoked) {
        this.hookInvoked = hookInvoked;
    }

    public String getTaskDetailJson2(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("detail", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result.getBody());
    }

    public String getTaskQuotaJson(String taskName) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instancequota", null);
        params.put("taskname", taskName);
        Response result = this.client.request(this.getResource(), "GET", params, null, null);
        return new String(result.getBody());
    }

    public String startDebug(String workerId, String debugId) throws OdpsException {
        if (workerId == null) {
            throw new OdpsException("Missing argument: workerId");
        }
        if (debugId == null) {
            throw new OdpsException("Missing argument: debugId");
        }
        InstanceDebugModel model = new InstanceDebugModel();
        model.debugId = debugId;
        model.logId = workerId;
        try {
            String body = SimpleXmlUtils.marshal(model);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/xml");
            Response resp = this.client.stringRequest(this.getResource() + "/debug", "POST", null, headers, body);
            return new String(resp.getBody());
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public InstanceQueueingInfo getQueueingInfo() throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cached", null);
        Response resp = this.client.request(this.getResource(), "GET", params, null, null);
        Gson gson = GsonObjectBuilder.get();
        JsonObject object = (JsonObject)gson.fromJson(new String(resp.getBody()), JsonObject.class);
        return new InstanceQueueingInfo(object);
    }

    public static class InstanceQueueingInfo {
        JsonObject properties;

        InstanceQueueingInfo(JsonObject props) {
            this.properties = props;
        }

        public <T> T getProperty(String key, Class<T> clz) {
            if (this.properties.get(key) == null) {
                return null;
            }
            return this.cast(this.properties.get(key), clz);
        }

        private <T> T cast(Object object, Class<T> clz) {
            if (object instanceof JsonPrimitive) {
                if (clz.equals(Integer.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsInt());
                }
                if (clz.equals(Short.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsShort());
                }
                if (clz.equals(Boolean.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsBoolean());
                }
                if (clz.equals(Double.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsDouble());
                }
                if (clz.equals(Long.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsLong());
                }
                if (clz.equals(Float.class)) {
                    return clz.cast(Float.valueOf(((JsonPrimitive)object).getAsFloat()));
                }
                if (clz.equals(String.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsString());
                }
                if (clz.equals(Byte.class)) {
                    return clz.cast(((JsonPrimitive)object).getAsByte());
                }
            } else {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                return (T)gson.fromJson(gson.toJson(object), clz);
            }
            return null;
        }

        public String getId() {
            return this.properties.has("instanceId") ? this.properties.get("instanceId").getAsString() : null;
        }

        public Integer getPriority() {
            return this.properties.has("instancePriority") ? Integer.valueOf(this.properties.get("instancePriority").getAsInt()) : null;
        }

        public Double getProgress() {
            return this.properties.has("instanceProgress") ? Double.valueOf(this.properties.get("instanceProgress").getAsDouble()) : null;
        }

        public String getJobName() {
            return this.properties.has("jobName") ? this.properties.get("jobName").getAsString() : null;
        }

        public String getProject() {
            return this.properties.has("projectName") ? this.properties.get("projectName").getAsString() : null;
        }

        public String getSkyNetId() {
            return this.properties.has("skynetId") ? this.properties.get("skynetId").getAsString() : null;
        }

        public Date getStartTime() {
            String startTimeStr = this.properties.get("startTime").getAsString();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            Date startTime = null;
            try {
                startTime = format.parse(startTimeStr);
            }
            catch (ParseException e1) {
                try {
                    startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ").parse(startTimeStr);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return startTime;
        }

        public String getTaskType() {
            return this.properties.get("taskType").getAsString();
        }

        public String getTaskName() {
            return this.properties.get("taskName").getAsString();
        }

        public String getUserAccount() {
            return this.properties.get("userAccount").getAsString();
        }

        public Status getStatus() {
            if (!this.properties.has("status")) {
                return null;
            }
            String status = this.properties.get("status").getAsString();
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (Exception e) {
                return Status.UNKNOWN;
            }
        }

        public static enum Status {
            RUNNING,
            SUSPENDED,
            TERMINATED,
            UNKNOWN;

        }
    }

    @Root(name="Progress", strict=false)
    private static class TaskProgress {
        @ElementList(entry="Stage", inline=true, required=false)
        List<StageProgress> stages = new LinkedList<StageProgress>();

        private TaskProgress() {
        }

        List<StageProgress> getStages() {
            return this.stages;
        }
    }

    @Root(strict=false)
    public static class StageProgress {
        @Attribute(name="ID", required=false)
        String name;
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String status;
        @Element(name="BackupWorkers", required=false)
        int backupSysInstances;
        @Element(name="TerminatedWorkers", required=false)
        int terminatedSysInstances;
        @Element(name="RunningWorkers", required=false)
        int runningSysInstances;
        @Element(name="TotalWorkers", required=false)
        int totalSysInstances;
        @Element(name="InputRecords", required=false)
        long inputRecords;
        @Element(name="OutputRecords", required=false)
        long outputRecords;
        @Element(name="FinishedPercentage", required=false)
        int finishedPercentage;

        public Status getStatus() {
            if (this.status == null) {
                return null;
            }
            return Status.valueOf(this.status.toUpperCase());
        }

        public int getBackupWorkers() {
            return this.backupSysInstances;
        }

        public int getRunningWorkers() {
            return this.runningSysInstances;
        }

        public String getName() {
            return this.name;
        }

        public int getTerminatedWorkers() {
            return this.terminatedSysInstances;
        }

        public int getTotalWorkers() {
            return this.totalSysInstances;
        }

        public long getInputRecords() {
            return this.inputRecords;
        }

        public long getOutputRecords() {
            return this.outputRecords;
        }

        public int getFinishedPercentage() {
            return this.finishedPercentage;
        }

        public static enum Status {
            READY,
            WAITING,
            RUNNING,
            SUSPENDED,
            FAILED,
            TERMINATED,
            CANCELLED,
            CANCELLING;

        }
    }

    public static class TaskStatus {
        private TaskStatusModel.InstanceTaskModel model;

        TaskStatus(TaskStatusModel.InstanceTaskModel model) {
            this.model = model;
        }

        public String getName() {
            return this.model.name;
        }

        public String getType() {
            return this.model.type;
        }

        public Status getStatus() {
            return Status.valueOf(this.model.status.toUpperCase());
        }

        public static enum Status {
            WAITING,
            RUNNING,
            SUCCESS,
            FAILED,
            SUSPENDED,
            CANCELLED;

        }
    }

    @Root(name="Instance", strict=false)
    static class TaskStatusModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="StartTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date startTime;
        @Element(name="EndTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date endTime;
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String status;
        @ElementList(name="Tasks", entry="Task", required=false)
        List<InstanceTaskModel> tasks = new ArrayList<InstanceTaskModel>();

        TaskStatusModel() {
        }

        @Root(strict=false)
        static class InstanceTaskModel {
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String name;
            @Attribute(name="Type", required=false)
            String type;
            @Element(name="StartTime", required=false)
            @Convert(value=SimpleXmlUtils.DateConverter.class)
            Date startTime;
            @Element(name="EndTime", required=false)
            @Convert(value=SimpleXmlUtils.DateConverter.class)
            Date endTime;
            @Element(name="Status", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String status;
            @ElementList(name="Histories", entry="History", required=false)
            List<InstanceTaskModel> histories = new ArrayList<InstanceTaskModel>();

            InstanceTaskModel() {
            }
        }
    }

    public static class TaskSummary
    extends HashMap {
        private String text;
        private String jsonSummary = "{}";

        public String getSummaryText() {
            return this.text;
        }

        void setSummaryText(String text) {
            this.text = text;
        }

        public String getJsonSummary() {
            return this.jsonSummary;
        }

        void setJsonSummary(String jsonSummary) {
            this.jsonSummary = jsonSummary;
        }
    }

    public static class TaskCost {
        private Integer cpuCost = 0;
        private Integer memoryCost = 0;
        private Integer inputSize = 0;

        public Integer getCPUCost() {
            return this.cpuCost;
        }

        public void setCPUCost(Integer cpuCost) {
            this.cpuCost = cpuCost;
        }

        public Integer getMemoryCost() {
            return this.memoryCost;
        }

        public void setMemoryCost(Integer memoryCost) {
            this.memoryCost = memoryCost;
        }

        public Integer getInputSize() {
            return this.inputSize;
        }

        public void setInputSize(Integer inputSize) {
            this.inputSize = inputSize;
        }
    }

    @Root(name="Instance", strict=false)
    static class InstanceTaskInfoModel {
        @Element(name="Key", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String key;
        @Element(name="Value", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String value;

        InstanceTaskInfoModel() {
        }
    }

    @Root(strict=false)
    public static class Result {
        @Attribute(name="Transform", required=false)
        String transform;
        @Attribute(name="Format", required=false)
        String format;
        @Text(required=false)
        String text = "";

        public String getString() {
            if (this.transform != null && "Base64".equals(this.transform)) {
                try {
                    String decodedString = new String(Base64.decodeBase64((String)this.text), "UTF-8");
                    return decodedString;
                }
                catch (Exception e) {
                    return this.text;
                }
            }
            return this.text;
        }

        public String getFormat() {
            return this.format;
        }
    }

    @Root(name="Instance", strict=false)
    public static class InstanceResultModel {
        @ElementList(name="Tasks", entry="Task", required=false)
        List<TaskResult> taskResults = new ArrayList<TaskResult>();

        @Root(strict=false)
        public static class TaskResult {
            @Attribute(name="Type", required=false)
            String type;
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String name;
            @Element(name="Result", required=false)
            Result result;
            @Element(name="Status", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String status;

            public String getType() {
                return this.type;
            }

            public String getName() {
                return this.name;
            }

            public Result getResult() {
                return this.result;
            }

            public String getStatus() {
                return this.status;
            }
        }
    }

    @Root(strict=false)
    private static class InstanceDebugModel {
        @Element(name="LogId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String logId;
        @Element(name="DebugId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String debugId;

        private InstanceDebugModel() {
        }
    }

    @Root(name="Instance", strict=false)
    private static class InstanceStatusModel {
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String status;

        private InstanceStatusModel() {
        }
    }

    public class SetInformationResult {
        public String result;
        public String status;
    }

    public static enum Status {
        RUNNING("Running"),
        SUSPENDED("Suspended"),
        TERMINATED("Terminated");

        private static final Map<String, Status> strToEnum;
        private String strVal;

        private Status(String strVal) {
            this.strVal = strVal;
        }

        static Status fromString(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return strToEnum.get(value);
        }

        public String toString() {
            return this.strVal;
        }

        static {
            strToEnum = new HashMap<String, Status>();
            for (Status t : Status.values()) {
                strToEnum.put(t.toString(), t);
            }
        }
    }
}

