/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Job;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class CommandUtil {
    private static final Calendar calendar = new Calendar.Builder().setCalendarType("iso8601").setLenient(true).setTimeZone(TimeZone.getTimeZone("GMT")).build();

    public static String runJob(Task task, Odps odps) throws OdpsException {
        Instance instance = CommandUtil.submit(task, odps);
        return instance.getId();
    }

    private static Instance submit(Task task, Odps odps) throws OdpsException {
        Job job = new Job();
        String guid = UUID.randomUUID().toString();
        task.setProperty("guid", guid);
        job.addTask(task);
        return odps.instances().create(job);
    }

    public static List<Record> toRecord(List<List<String>> data, List<String> headers) {
        if (headers == null || headers.size() == 0) {
            throw new IllegalArgumentException("headers is empty!");
        }
        ArrayList<Record> records = new ArrayList<Record>();
        Column[] columns = new Column[headers.size()];
        int index = 0;
        for (String string : headers) {
            columns[index++] = new Column(string, (TypeInfo)TypeInfoFactory.STRING);
        }
        for (List list : data) {
            if (list == null || list.size() != headers.size()) {
                throw new IllegalArgumentException("data and headers not match");
            }
            ArrayRecord record = new ArrayRecord(columns);
            for (int i = 0; i < list.size(); ++i) {
                record.set(i, list.get(i));
            }
            records.add((Record)record);
        }
        return records;
    }

    public static List<Record> toRecord(String data) {
        Column[] columns = new Column[]{new Column("Info", (TypeInfo)TypeInfoFactory.STRING)};
        ArrayRecord record = new ArrayRecord(columns);
        record.set(0, (Object)data);
        return Collections.singletonList(record);
    }

    public static List<Record> toRecord(Map<String, Object> data, Map<String, TypeInfo> dataType) {
        if (dataType == null || dataType.size() == 0) {
            throw new IllegalArgumentException("dataType is empty!");
        }
        Column[] columns = new Column[dataType.keySet().size()];
        int index = 0;
        for (String header : dataType.keySet()) {
            columns[index++] = new Column(header, dataType.get(header));
        }
        ArrayRecord record = new ArrayRecord(columns);
        index = 0;
        for (String header : dataType.keySet()) {
            if (!data.containsKey(header)) {
                throw new IllegalArgumentException("data and dataType not match.");
            }
            record.set(index++, data.get(header));
        }
        return Collections.singletonList(record);
    }

    public static List<Record> toRecord(List<Map<String, Object>> data, Map<String, TypeInfo> dataType) {
        if (dataType == null || dataType.size() == 0) {
            throw new IllegalArgumentException("dataType is empty!");
        }
        Column[] columns = new Column[dataType.keySet().size()];
        int index = 0;
        for (String header : dataType.keySet()) {
            columns[index++] = new Column(header, dataType.get(header));
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (Map<String, Object> dataMap : data) {
            if (dataMap == null || dataMap.size() != dataType.size()) {
                throw new IllegalArgumentException("data and dataType not match");
            }
            ArrayRecord record = new ArrayRecord(columns);
            index = 0;
            for (String header : dataType.keySet()) {
                record.set(index++, dataMap.get(header));
            }
            records.add((Record)record);
        }
        return records;
    }

    public static Date getTime(Date date, int hour) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)calendar.clone();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date toDate(String strDate) {
        if (strDate == null) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(strDate);
            Calendar cal = (Calendar)calendar.clone();
            cal.setTime(date);
            return cal.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("invalid date: " + strDate);
        }
    }

    public static int getNumberToken(String numberString) {
        int number;
        try {
            number = Integer.parseInt(numberString);
            if (number < 1) {
                throw new IllegalArgumentException("number should >= 1");
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("number is not integer");
        }
        return number;
    }
}

