/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.google.gson.GsonBuilder;
import java.util.Map;

@Root(name="CUPID", strict=false)
public class CupidTask
extends Task {
    @Element(name="Plan", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String Plan;

    public String getPlan() {
        return this.Plan;
    }

    public void setPlan(String plan) {
        this.Plan = plan;
    }

    static CupidTask GetCupidTask(String plan, String taskName, Map<String, String> hints) throws OdpsException {
        CupidTask task = new CupidTask();
        task.setName(taskName);
        task.setPlan(plan);
        task.setProperty("type", "cupid");
        if (hints != null) {
            if (hints.containsKey("odps.cupid.task.subtype")) {
                task.setProperty("subtype", hints.get("odps.cupid.task.subtype"));
            }
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return task;
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints, Integer priority, String runningCluster, String jobName) throws OdpsException {
        CupidTask task = CupidTask.GetCupidTask(plan, "cupid_task", hints);
        return odps.instances().create(project, task, priority, runningCluster, jobName);
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints, int priority) throws OdpsException {
        CupidTask task = CupidTask.GetCupidTask(plan, "cupid_task", hints);
        return odps.instances().create(project, task, priority);
    }

    public static Instance run(Odps odps, String project, String plan, Map<String, String> hints) throws OdpsException {
        CupidTask task = CupidTask.GetCupidTask(plan, "cupid_task", hints);
        return odps.instances().create(project, task);
    }
}

