/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;

public class RecognizeInternationalBusinessLicenseRequest
extends Request {
    @Query
    @NameInMap(value="Country")
    @Validation(required=true)
    private String country;
    @Query
    @NameInMap(value="Url")
    @Validation(maxLength=2048)
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeInternationalBusinessLicenseRequest(Builder builder) {
        super((Request.Builder)builder);
        this.country = builder.country;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeInternationalBusinessLicenseRequest create() {
        return RecognizeInternationalBusinessLicenseRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCountry() {
        return this.country;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeInternationalBusinessLicenseRequest, Builder> {
        private String country;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeInternationalBusinessLicenseRequest request) {
            super((Request)request);
            this.country = request.country;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder country(String country) {
            this.putQueryParameter("Country", country);
            this.country = country;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeInternationalBusinessLicenseRequest build() {
            return new RecognizeInternationalBusinessLicenseRequest(this);
        }
    }
}

