/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.services.bos.model.BosProgressCallback;
import com.baidubce.services.bos.model.GenericObjectRequest;
import com.baidubce.services.bos.model.ObjectMetadata;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class PutSuperObjectRequest
extends GenericObjectRequest {
    private long chunkSize;
    private int nThreads;
    private AtomicBoolean isSuperObjectUploadCanced = new AtomicBoolean(false);
    private File file;
    private String uploadId;
    private static final long CHUNK_SIZE = 0x500000L;
    private ObjectMetadata objectMetadata = new ObjectMetadata();
    private static final int AVAILABLEPROCESSORS = Runtime.getRuntime().availableProcessors();
    private BosProgressCallback progressCallback = null;

    public PutSuperObjectRequest(String bucketName, String key, File file) {
        this(bucketName, key, file, 0x500000L, AVAILABLEPROCESSORS);
    }

    public PutSuperObjectRequest(String bucketName, String key, File file, long chunkSize) {
        this(bucketName, key, file, chunkSize, AVAILABLEPROCESSORS);
    }

    public PutSuperObjectRequest(String bucketName, String key, File file, int nThreads) {
        this(bucketName, key, file, 0x500000L, nThreads);
    }

    public PutSuperObjectRequest(String bucketName, String key, File file, long chunkSize, int nThreads) {
        super(bucketName, key);
        this.file = file;
        this.chunkSize = chunkSize;
        this.nThreads = nThreads;
    }

    public void cancel() {
        this.isSuperObjectUploadCanced.set(true);
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public PutSuperObjectRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    @Override
    public PutSuperObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    @Override
    public PutSuperObjectRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public PutSuperObjectRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public int getnThreads() {
        return this.nThreads;
    }

    public void setnThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public PutSuperObjectRequest withnThreads(int nThreads) {
        this.setnThreads(nThreads);
        return this;
    }

    public AtomicBoolean getIsSuperObjectUploadCanced() {
        return this.isSuperObjectUploadCanced;
    }

    public void setIsSuperObjectUploadCanced(AtomicBoolean isSuperObjectUploadCanced) {
        this.isSuperObjectUploadCanced = isSuperObjectUploadCanced;
    }

    public PutSuperObjectRequest withIsSuperObjectUploadCanced(AtomicBoolean isSuperObjectUploadCanced) {
        this.setIsSuperObjectUploadCanced(isSuperObjectUploadCanced);
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public PutSuperObjectRequest withUploadId(String uploadId) {
        this.setUploadId(uploadId);
        return this;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public BosProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    public void setProgressCallback(BosProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public PutSuperObjectRequest withProgressCallback(BosProgressCallback progressCallback) {
        this.setProgressCallback(progressCallback);
        return this;
    }

    public long getTrafficLimitBitPS() {
        return this.trafficLimitBitPS;
    }

    public void setTrafficLimitBitPS(long trafficLimitBitPS) {
        this.trafficLimitBitPS = trafficLimitBitPS;
    }

    public PutSuperObjectRequest withTrafficLimitBitPS(long trafficLimitBitPS) {
        this.setTrafficLimitBitPS(trafficLimitBitPS);
        return this;
    }
}

