/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dugo.core.protocol.mqtt;

import com.baidubce.services.dugo.core.protocol.mqtt.BceIotMessage;
import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttConnection {
    private MqttAsyncClient mqttAsyncClient;
    private MqttConnectOptions connectionOptions;
    private IMqttActionListener mqttMessageListener;
    private static final String TLS_V_1_2 = "TLSv1.2";

    public MqttConnection(String serverURI, String clientId, String userName, String password, SocketFactory socketFactory, MqttCallback mqttCallbackListener, IMqttActionListener mqttMessageListener) throws MqttException {
        if (serverURI == null || mqttCallbackListener == null || mqttMessageListener == null) {
            throw new IllegalArgumentException("serverURI, mqttCallbackListener, mqttMessageListener can't be null!");
        }
        this.mqttAsyncClient = new MqttAsyncClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
        this.mqttAsyncClient.setManualAcks(true);
        this.connectionOptions = new MqttConnectOptions();
        this.initOptions(userName, password, socketFactory);
        this.mqttMessageListener = mqttMessageListener;
        this.mqttAsyncClient.setCallback(mqttCallbackListener);
    }

    private void initOptions(String userName, String password, SocketFactory socketFactory) {
        this.connectionOptions.setKeepAliveInterval(180);
        this.connectionOptions.setCleanSession(true);
        this.connectionOptions.setUserName(userName);
        this.connectionOptions.setSocketFactory(socketFactory);
        if (password != null && !password.isEmpty()) {
            this.connectionOptions.setPassword(password.toCharArray());
        }
    }

    public MqttAsyncClient getMqttAsyncClient() {
        return this.mqttAsyncClient;
    }

    public boolean isConnected() {
        if (null != this.mqttAsyncClient) {
            return this.mqttAsyncClient.isConnected();
        }
        return false;
    }

    public IMqttToken disconnect() throws MqttException {
        if (this.mqttAsyncClient != null) {
            return this.mqttAsyncClient.disconnect();
        }
        return null;
    }

    public void close() throws MqttException {
        if (this.mqttAsyncClient != null) {
            this.mqttAsyncClient.close();
        }
    }

    public void openConnection() {
        try {
            this.mqttAsyncClient.connect(this.connectionOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publishMessage(BceIotMessage message) {
        String topic = message.getTopic();
        MqttMessage mqttMessage = new MqttMessage(message.getPayload());
        mqttMessage.setQos(message.getQos());
        try {
            this.mqttAsyncClient.publish(topic, mqttMessage, (Object)message, this.mqttMessageListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void subscribeTopic(BceIotMessage message) {
        try {
            this.mqttAsyncClient.subscribe(message.getTopic(), message.getQos(), (Object)message, this.mqttMessageListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unsubscribeTopic(BceIotMessage message) {
        try {
            this.mqttAsyncClient.unsubscribe(message.getTopic(), (Object)message, this.mqttMessageListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SSLSocketFactory getFactory(KeyStore keystore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (null == keystore) {
                tmf.init((KeyStore)null);
            } else {
                tmf.init(keystore);
            }
            SSLContext context = SSLContext.getInstance(TLS_V_1_2);
            context.init(null, tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SSLSocketFactory getFactory(KeyStore caKeystore, KeyStore clientKeystore, String keystorePassword) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(caKeystore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientKeystore, keystorePassword.toCharArray());
            SSLContext context = SSLContext.getInstance(TLS_V_1_2);
            KeyManager[] kms = kmf.getKeyManagers();
            context.init(kms, tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

