/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothub.model.iotcore;

import com.baidubce.services.iothub.model.BaseRequest;
import com.baidubce.services.iothub.model.iotcore.Permission;
import lombok.NonNull;

public class AddPolicyRequest
extends BaseRequest {
    @NonNull
    private final String topicFilter;
    private final String desc;
    @NonNull
    private final Permission permission;

    AddPolicyRequest(@NonNull String topicFilter, String desc, @NonNull Permission permission) {
        if (topicFilter == null) {
            throw new NullPointerException("topicFilter is marked @NonNull but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked @NonNull but is null");
        }
        this.topicFilter = topicFilter;
        this.desc = desc;
        this.permission = permission;
    }

    public static AddPolicyRequestBuilder builder() {
        return new AddPolicyRequestBuilder();
    }

    @NonNull
    public String getTopicFilter() {
        return this.topicFilter;
    }

    public String getDesc() {
        return this.desc;
    }

    @NonNull
    public Permission getPermission() {
        return this.permission;
    }

    public static class AddPolicyRequestBuilder {
        private String topicFilter;
        private String desc;
        private Permission permission;

        AddPolicyRequestBuilder() {
        }

        public AddPolicyRequestBuilder topicFilter(String topicFilter) {
            this.topicFilter = topicFilter;
            return this;
        }

        public AddPolicyRequestBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public AddPolicyRequestBuilder permission(Permission permission) {
            this.permission = permission;
            return this;
        }

        public AddPolicyRequest build() {
            return new AddPolicyRequest(this.topicFilter, this.desc, this.permission);
        }

        public String toString() {
            return "AddPolicyRequest.AddPolicyRequestBuilder(topicFilter=" + this.topicFilter + ", desc=" + this.desc + ", permission=" + (Object)((Object)this.permission) + ")";
        }
    }
}

