/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce;

import com.baidubce.Protocol;
import com.baidubce.Region;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.RetryPolicy;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class BceClientConfiguration {
    public static final int DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 50000;
    public static final int DEFAULT_SOCKET_TIMEOUT_IN_MILLIS = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final String DEFAULT_USER_AGENT;
    public static Region DEFAULT_REGION;
    public static Protocol DEFAULT_PROTOCOL;
    private String userAgent = DEFAULT_USER_AGENT;
    private RetryPolicy retryPolicy = RetryPolicy.DEFAULT_RETRY_POLICY;
    private InetAddress localAddress;
    private Protocol protocol = Protocol.HTTP;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String proxyWorkstation = null;
    private boolean proxyPreemptiveAuthenticationEnabled;
    private int maxConnections = 50;
    private int socketTimeoutInMillis = 50000;
    private int connectionTimeoutInMillis = 50000;
    private int socketBufferSizeInBytes = 0;
    private String endpoint = null;
    private Region region = DEFAULT_REGION;
    private BceCredentials credentials = null;
    private boolean redirectsEnabled = true;
    private int ioThreadCount = Runtime.getRuntime().availableProcessors();

    public BceClientConfiguration() {
    }

    public BceClientConfiguration(BceClientConfiguration other) {
        this.connectionTimeoutInMillis = other.connectionTimeoutInMillis;
        this.maxConnections = other.maxConnections;
        this.ioThreadCount = other.ioThreadCount;
        this.retryPolicy = other.retryPolicy;
        this.localAddress = other.localAddress;
        this.protocol = other.protocol;
        this.proxyDomain = other.proxyDomain;
        this.proxyHost = other.proxyHost;
        this.proxyPassword = other.proxyPassword;
        this.proxyPort = other.proxyPort;
        this.proxyUsername = other.proxyUsername;
        this.proxyWorkstation = other.proxyWorkstation;
        this.proxyPreemptiveAuthenticationEnabled = other.proxyPreemptiveAuthenticationEnabled;
        this.socketTimeoutInMillis = other.socketTimeoutInMillis;
        this.userAgent = other.userAgent;
        this.socketBufferSizeInBytes = other.socketBufferSizeInBytes;
        this.endpoint = other.endpoint;
        this.region = other.region;
        this.credentials = other.credentials;
        this.redirectsEnabled = other.redirectsEnabled;
    }

    public BceClientConfiguration(BceClientConfiguration other, String endpoint) {
        this.endpoint = endpoint;
        this.connectionTimeoutInMillis = other.connectionTimeoutInMillis;
        this.maxConnections = other.maxConnections;
        this.ioThreadCount = other.ioThreadCount;
        this.retryPolicy = other.retryPolicy;
        this.localAddress = other.localAddress;
        this.protocol = other.protocol;
        this.proxyDomain = other.proxyDomain;
        this.proxyHost = other.proxyHost;
        this.proxyPassword = other.proxyPassword;
        this.proxyPort = other.proxyPort;
        this.proxyUsername = other.proxyUsername;
        this.proxyWorkstation = other.proxyWorkstation;
        this.proxyPreemptiveAuthenticationEnabled = other.proxyPreemptiveAuthenticationEnabled;
        this.socketTimeoutInMillis = other.socketTimeoutInMillis;
        this.userAgent = other.userAgent;
        this.socketBufferSizeInBytes = other.socketBufferSizeInBytes;
        this.region = other.region;
        this.credentials = other.credentials;
        this.redirectsEnabled = other.redirectsEnabled;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol == null ? DEFAULT_PROTOCOL : protocol;
    }

    public BceClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        Preconditions.checkArgument((maxConnections >= 0 ? 1 : 0) != 0, (Object)"maxConnections should not be negative.");
        this.maxConnections = maxConnections;
    }

    public BceClientConfiguration withMaxConnections(int maxConnections) {
        this.setMaxConnections(maxConnections);
        return this;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        Preconditions.checkArgument((ioThreadCount >= 0 ? 1 : 0) != 0, (Object)"ioThreadCount should not be negative.");
        this.ioThreadCount = ioThreadCount;
    }

    public BceClientConfiguration withIoThreadCount(int ioThreadCount) {
        this.setIoThreadCount(ioThreadCount);
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent == null ? DEFAULT_USER_AGENT : (userAgent.endsWith(DEFAULT_USER_AGENT) ? userAgent : userAgent + ", " + DEFAULT_USER_AGENT);
    }

    public BceClientConfiguration withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return this;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public BceClientConfiguration withLocalAddress(InetAddress localAddress) {
        this.setLocalAddress(localAddress);
        return this;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    public BceClientConfiguration withRedirectsEnabled(boolean redirectsEnabled) {
        this.setRedirectsEnabled(redirectsEnabled);
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public BceClientConfiguration withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public BceClientConfiguration withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public BceClientConfiguration withProxyUsername(String proxyUsername) {
        this.setProxyUsername(proxyUsername);
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public BceClientConfiguration withProxyPassword(String proxyPassword) {
        this.setProxyPassword(proxyPassword);
        return this;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public BceClientConfiguration withProxyDomain(String proxyDomain) {
        this.setProxyDomain(proxyDomain);
        return this;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public BceClientConfiguration withProxyWorkstation(String proxyWorkstation) {
        this.setProxyWorkstation(proxyWorkstation);
        return this;
    }

    public boolean isProxyPreemptiveAuthenticationEnabled() {
        return this.proxyPreemptiveAuthenticationEnabled;
    }

    public void setProxyPreemptiveAuthenticationEnabled(boolean proxyPreemptiveAuthenticationEnabled) {
        this.proxyPreemptiveAuthenticationEnabled = proxyPreemptiveAuthenticationEnabled;
    }

    public BceClientConfiguration withProxyPreemptiveAuthenticationEnabled(boolean proxyPreemptiveAuthenticationEnabled) {
        this.setProxyPreemptiveAuthenticationEnabled(proxyPreemptiveAuthenticationEnabled);
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy == null ? RetryPolicy.DEFAULT_RETRY_POLICY : retryPolicy;
    }

    public BceClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public int getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public void setSocketTimeoutInMillis(int socketTimeoutInMillis) {
        Preconditions.checkArgument((socketTimeoutInMillis >= 0 ? 1 : 0) != 0, (Object)"socketTimeoutInMillis should not be negative.");
        this.socketTimeoutInMillis = socketTimeoutInMillis;
    }

    public BceClientConfiguration withSocketTimeoutInMillis(int socketTimeoutInMillis) {
        this.setSocketTimeoutInMillis(socketTimeoutInMillis);
        return this;
    }

    public int getConnectionTimeoutInMillis() {
        return this.connectionTimeoutInMillis;
    }

    public void setConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
        Preconditions.checkArgument((connectionTimeoutInMillis >= 0 ? 1 : 0) != 0, (Object)"connectionTimeoutInMillis should not be negative.");
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    public BceClientConfiguration withConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
        this.setConnectionTimeoutInMillis(connectionTimeoutInMillis);
        return this;
    }

    public int getSocketBufferSizeInBytes() {
        return this.socketBufferSizeInBytes;
    }

    public void setSocketBufferSizeInBytes(int socketBufferSizeInBytes) {
        this.socketBufferSizeInBytes = socketBufferSizeInBytes;
    }

    public BceClientConfiguration withSocketBufferSizeInBytes(int socketBufferSizeInBytes) {
        this.setSocketBufferSizeInBytes(socketBufferSizeInBytes);
        return this;
    }

    public String getEndpoint() {
        String url = this.endpoint;
        if (this.endpoint != null && this.endpoint.length() > 0 && this.endpoint.indexOf("://") < 0) {
            url = this.protocol.toString().toLowerCase() + "://" + this.endpoint;
        }
        return url;
    }

    public void setEndpoint(String endpoint) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint should not be null.");
        this.endpoint = endpoint;
    }

    public BceClientConfiguration withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region == null ? DEFAULT_REGION : region;
    }

    public BceClientConfiguration withRegion(Region region) {
        this.setRegion(region);
        return this;
    }

    public BceCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(BceCredentials credentials) {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials should not be null.");
        this.credentials = credentials;
    }

    public BceClientConfiguration withCredentials(BceCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public String toString() {
        return "BceClientConfiguration [ \n  userAgent=" + this.userAgent + ", \n  retryPolicy=" + this.retryPolicy + ", \n  localAddress=" + this.localAddress + ", \n  protocol=" + (Object)((Object)this.protocol) + ", \n  proxyHost=" + this.proxyHost + ", \n  proxyPort=" + this.proxyPort + ", \n  proxyUsername=" + this.proxyUsername + ", \n  proxyPassword=******, \n  proxyDomain=" + this.proxyDomain + ", \n  proxyWorkstation=" + this.proxyWorkstation + ", \n  proxyPreemptiveAuthenticationEnabled=" + this.proxyPreemptiveAuthenticationEnabled + ", \n  maxConnections=" + this.maxConnections + ", \n ioThreadCount=" + this.ioThreadCount + ", \n  socketTimeoutInMillis=" + this.socketTimeoutInMillis + ", \n  connectionTimeoutInMillis=" + this.connectionTimeoutInMillis + ", \n  socketBufferSizeInBytes=" + this.socketBufferSizeInBytes + ", \n  endpoint=" + this.endpoint + ", \n  region=" + (Object)((Object)this.region) + ", \n  credentials=" + this.credentials + "]\n";
    }

    static {
        String region;
        DEFAULT_REGION = Region.CN_N1;
        DEFAULT_PROTOCOL = Protocol.HTTP;
        String language = System.getProperty("user.language");
        if (language == null) {
            language = "";
        }
        if ((region = System.getProperty("user.region")) == null) {
            region = "";
        }
        DEFAULT_USER_AGENT = Joiner.on((char)'/').join((Object)"bce-sdk-java", (Object)"0.10.338", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.version"), language, region}).replace(' ', '_');
    }
}

