/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.as;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.as.AsGroupClientConfiguration;
import com.baidubce.services.as.model.asgroup.AsGroupBatchRequest;
import com.baidubce.services.as.model.asgroup.AsGroupDeleteResponse;
import com.baidubce.services.as.model.asgroup.GetAsGroupRequest;
import com.baidubce.services.as.model.asgroup.GetAsGroupResponse;
import com.baidubce.services.as.model.asgroup.GroupCreateRequest;
import com.baidubce.services.as.model.asgroup.GroupCreateResponse;
import com.baidubce.services.as.model.asgroup.ListAsGroupRequest;
import com.baidubce.services.as.model.asgroup.ListAsGroupResponse;
import com.baidubce.services.as.model.asgroup.ListAsNodeRequest;
import com.baidubce.services.as.model.asgroup.ListAsNodeResponse;
import com.baidubce.services.as.model.rule.CreateRuleResult;
import com.baidubce.services.as.model.rule.RuleDelRequest;
import com.baidubce.services.as.model.rule.RuleListQuery;
import com.baidubce.services.as.model.rule.RuleQuery;
import com.baidubce.services.as.model.rule.RuleRequest;
import com.baidubce.services.as.model.rule.RuleVOListResponse;
import com.baidubce.services.as.model.rule.RuleVOResponse;
import com.baidubce.services.as.model.task.DetachNodeRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsGroupClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsGroupClient.class);
    private static final String VERSION = "v1";
    private static final String GROUP = "group";
    private static final String RULE = "rule";
    private static final String GROUP_ID = "groupId";
    private static final String GROUP_IDS = "groupIds";
    private static final String DELETE = "delete";
    private static final String NODE = "node";
    private static final String GROUP_ID_V2 = "groupid";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] as_group_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AsGroupClient() {
        this(new AsGroupClientConfiguration());
    }

    public AsGroupClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, as_group_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public void detachNode(DetachNodeRequest detachNodeRequest) {
        Preconditions.checkNotNull((Object)detachNodeRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(detachNodeRequest.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        Preconditions.checkNotNull(detachNodeRequest.getNodes(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("nodes"));
        InternalRequest internalRequest = this.createRequest(detachNodeRequest, HttpMethodName.POST, GROUP, detachNodeRequest.getGroupId());
        internalRequest.addParameter("detachNode", null);
        this.fillPayload(internalRequest, detachNodeRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateRuleResult createRule(RuleRequest ruleRequest) {
        Preconditions.checkNotNull((Object)ruleRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        this.checkAsRuleRequest(ruleRequest);
        InternalRequest internalRequest = this.createRequest(ruleRequest, HttpMethodName.POST, RULE);
        this.fillPayload(internalRequest, ruleRequest);
        return this.invokeHttpClient(internalRequest, CreateRuleResult.class);
    }

    public void updateRule(RuleRequest ruleRequest) {
        Preconditions.checkNotNull((Object)ruleRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(ruleRequest.getRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat("ruleId"));
        this.checkAsRuleRequest(ruleRequest);
        InternalRequest internalRequest = this.createRequest(ruleRequest, HttpMethodName.PUT, RULE, ruleRequest.getRuleId());
        this.fillPayload(internalRequest, ruleRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public RuleVOListResponse queryRuleList(RuleListQuery ruleListQuery) {
        Preconditions.checkNotNull((Object)ruleListQuery, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(ruleListQuery, HttpMethodName.GET, RULE);
        this.checkAsRuleQuery(ruleListQuery, internalRequest);
        return this.invokeHttpClient(internalRequest, RuleVOListResponse.class);
    }

    public RuleVOResponse getRule(RuleQuery ruleQuery) {
        Preconditions.checkNotNull((Object)ruleQuery, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(ruleQuery.getRuleId(), StringFormatUtils.checkEmptyExceptionMessageFormat("ruleId"));
        InternalRequest internalRequest = this.createRequest(ruleQuery, HttpMethodName.GET, RULE, ruleQuery.getRuleId());
        return this.invokeHttpClient(internalRequest, RuleVOResponse.class);
    }

    public void deleteRule(RuleDelRequest ruleDelRequest) {
        Preconditions.checkNotNull((Object)ruleDelRequest, (Object)REQUEST_NULL_ERROR_MESSAGE);
        this.checkRuleDelRequest(ruleDelRequest);
        InternalRequest internalRequest = this.createRequest(ruleDelRequest, HttpMethodName.POST, RULE);
        internalRequest.addParameter(DELETE, null);
        this.fillPayload(internalRequest, ruleDelRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private void checkRuleDelRequest(RuleDelRequest ruleDelRequest) {
        if (CollectionUtils.isEmpty(ruleDelRequest.getRuleIds()) && CollectionUtils.isEmpty(ruleDelRequest.getGroupIds())) {
            throw new IllegalArgumentException("ruleIds and groupIds cannot be empty at the same time");
        }
    }

    private void checkAsRuleQuery(RuleListQuery ruleListQuery, InternalRequest internalRequest) {
        Validate.checkStringNotEmpty(ruleListQuery.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        Preconditions.checkNotNull((Object)ruleListQuery.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        if (Strings.isNotEmpty((String)ruleListQuery.getGroupId())) {
            internalRequest.addParameter(GROUP_ID_V2, ruleListQuery.getGroupId());
        }
        if (Strings.isNotEmpty((String)ruleListQuery.getKeyword())) {
            internalRequest.addParameter("keyword", ruleListQuery.getKeyword());
        }
        if (Strings.isNotEmpty((String)ruleListQuery.getKeywordType())) {
            internalRequest.addParameter("keywordType", ruleListQuery.getKeywordType());
        }
        if (Strings.isNotEmpty((String)ruleListQuery.getOrder())) {
            internalRequest.addParameter("order", ruleListQuery.getOrder());
        }
        if (Strings.isNotEmpty((String)ruleListQuery.getOrderBy())) {
            internalRequest.addParameter("orderBy", ruleListQuery.getOrderBy());
        }
        if (ruleListQuery.getPageNo() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(ruleListQuery.getPageNo()));
        }
        if (ruleListQuery.getPageSize() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(ruleListQuery.getPageSize()));
        }
    }

    private void checkAsRuleRequest(RuleRequest ruleRequest) {
        Validate.checkStringNotEmpty(ruleRequest.getRuleName(), StringFormatUtils.checkEmptyExceptionMessageFormat("ruleName"));
        Validate.checkStringNotEmpty(ruleRequest.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        Preconditions.checkNotNull((Object)((Object)ruleRequest.getState()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("state"));
        Preconditions.checkNotNull((Object)((Object)ruleRequest.getType()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("type"));
        Preconditions.checkNotNull((Object)((Object)ruleRequest.getActionType()), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("actionType"));
        Preconditions.checkNotNull((Object)ruleRequest.getActionNum(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("actionNum"));
        Preconditions.checkNotNull((Object)ruleRequest.getCooldownInSec(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("cooldownInSec"));
        if (Strings.isNotEmpty((String)ruleRequest.getPeriodStartTime())) {
            this.checkUTC(ruleRequest.getPeriodStartTime());
        }
        if (Strings.isNotEmpty((String)ruleRequest.getPeriodEndTime())) {
            this.checkUTC(ruleRequest.getPeriodEndTime());
        }
    }

    private void checkUTC(String time) {
        String utcPattern = "^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z$";
        Validate.checkPattern(time, utcPattern, "time should be UTC format");
    }

    public GroupCreateResponse createAsGroup(GroupCreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, GROUP);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GroupCreateResponse.class);
    }

    public AsGroupDeleteResponse deleteAsGroup(AsGroupBatchRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull(request.getGroupIds(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_IDS));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, GROUP, DELETE);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AsGroupDeleteResponse.class);
        AsGroupDeleteResponse response = new AsGroupDeleteResponse();
        response.setGroupIds(request.getGroupIds());
        return response;
    }

    public ListAsGroupResponse listAsGroup(ListAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, GROUP);
        this.checkAsGroupListQuery(request, internalRequest);
        return this.invokeHttpClient(internalRequest, ListAsGroupResponse.class);
    }

    private void checkAsGroupListQuery(ListAsGroupRequest request, InternalRequest internalRequest) {
        Preconditions.checkNotNull((Object)request.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        if (Strings.isNotEmpty((String)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (Strings.isNotEmpty((String)request.getKeywordType())) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (Strings.isNotEmpty((String)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (Strings.isNotEmpty((String)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
    }

    public GetAsGroupResponse getAsGroupDetail(GetAsGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, GROUP, request.getGroupId());
        return this.invokeHttpClient(internalRequest, GetAsGroupResponse.class);
    }

    public ListAsNodeResponse listAsNode(ListAsNodeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(GROUP_ID));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NODE);
        this.checkAsGroupNodeListQuery(request, internalRequest);
        internalRequest.addParameter(GROUP_ID_V2, request.getGroupId());
        return this.invokeHttpClient(internalRequest, ListAsNodeResponse.class);
    }

    private void checkAsGroupNodeListQuery(ListAsNodeRequest request, InternalRequest internalRequest) {
        Preconditions.checkNotNull((Object)request.getPageNo(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("pageNo"));
        if (Strings.isNotEmpty((String)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (Strings.isNotEmpty((String)request.getKeywordType())) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (Strings.isNotEmpty((String)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (Strings.isNotEmpty((String)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
    }
}

