/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcm.handler;

import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bcm.model.EmptyResponse;
import com.baidubce.services.bcm.model.ListResponse;
import com.baidubce.services.bcm.model.MapListResponse;
import com.baidubce.services.bcm.model.application.ApplicationMonitorResponse;
import com.baidubce.services.bcm.model.custom.CustomMonitorResponse;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BcmJsonResponseHandler
extends BceJsonResponseHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        if (response instanceof CustomMonitorResponse) {
            ByteArrayOutputStream bos;
            CustomMonitorResponse customMonitorResponse = (CustomMonitorResponse)response;
            customMonitorResponse.setCode("OK");
            customMonitorResponse.setMessage("");
            if (null != response.getMetadata()) {
                customMonitorResponse.setRequestId(response.getMetadata().getBceRequestId());
            }
            if ((bos = BcmJsonResponseHandler.toByteArrayOutputStream(httpResponse.getContent())).size() > 0) {
                OBJECT_MAPPER.readerForUpdating((Object)customMonitorResponse).readValue(bos.toByteArray());
            }
            return true;
        }
        if (response instanceof EmptyResponse || response instanceof ListResponse || response instanceof MapListResponse) {
            InputStream content = httpResponse.getContent();
            if (content != null) {
                if (response.getMetadata().getContentLength() > 0L || "chunked".equalsIgnoreCase(response.getMetadata().getTransferEncoding())) {
                    if (response instanceof ListResponse) {
                        JsonUtils.load(content, ((ListResponse)response).getResult());
                    } else if (response instanceof MapListResponse) {
                        JsonUtils.load(content, ((MapListResponse)response).getResult());
                    }
                }
                content.close();
            }
            return true;
        }
        if (response instanceof ApplicationMonitorResponse) {
            ByteArrayOutputStream bos;
            ApplicationMonitorResponse applicationMonitorResponse = (ApplicationMonitorResponse)response;
            applicationMonitorResponse.setCode("OK");
            applicationMonitorResponse.setMessage("");
            if (null != response.getMetadata()) {
                applicationMonitorResponse.setRequestId(response.getMetadata().getBceRequestId());
            }
            if ((bos = BcmJsonResponseHandler.toByteArrayOutputStream(httpResponse.getContent())).size() > 0) {
                OBJECT_MAPPER.readerForUpdating((Object)applicationMonitorResponse).readValue(bos.toByteArray());
            }
            return true;
        }
        return super.handle(httpResponse, response);
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            bos.write(buffer, 0, len);
        }
        bos.flush();
        input.close();
        return bos;
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

