/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.DynamicGroupDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.p6spy.engine.spy.P6DataSource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private static final String UNDERLINE = "_";
    private DynamicDataSourceProvider provider;
    private Class<? extends DynamicDataSourceStrategy> strategy;
    private String primary;
    private boolean strict;
    private boolean p6spy;
    private Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private Map<String, DynamicGroupDataSource> groupDataSources = new ConcurrentHashMap<String, DynamicGroupDataSource>();

    @Override
    public DataSource determineDataSource() {
        return this.getDataSource(DynamicDataSourceContextHolder.peek());
    }

    private DataSource determinePrimaryDataSource() {
        log.debug("\u4ece\u9ed8\u8ba4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e");
        return this.groupDataSources.containsKey(this.primary) ? this.groupDataSources.get(this.primary).determineDataSource() : this.dataSourceMap.get(this.primary);
    }

    public Map<String, DataSource> getCurrentDataSources() {
        return this.dataSourceMap;
    }

    public Map<String, DynamicGroupDataSource> getCurrentGroupDataSources() {
        return this.groupDataSources;
    }

    public DataSource getDataSource(String ds) {
        if (StringUtils.isEmpty((Object)ds)) {
            return this.determinePrimaryDataSource();
        }
        if (!this.groupDataSources.isEmpty() && this.groupDataSources.containsKey(ds)) {
            log.debug("\u4ece {} \u7ec4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)ds);
            return this.groupDataSources.get(ds).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(ds)) {
            log.debug("\u4ece {} \u5355\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)ds);
            return this.dataSourceMap.get(ds);
        }
        if (this.strict) {
            throw new RuntimeException("\u4e0d\u80fd\u627e\u5230\u540d\u79f0\u4e3a" + ds + "\u7684\u6570\u636e\u6e90");
        }
        return this.determinePrimaryDataSource();
    }

    public synchronized void addDataSource(String ds, DataSource dataSource) {
        if (this.p6spy) {
            dataSource = new P6DataSource(dataSource);
        }
        this.dataSourceMap.put(ds, dataSource);
        if (ds.contains(UNDERLINE)) {
            String group = ds.split(UNDERLINE)[0];
            if (this.groupDataSources.containsKey(group)) {
                this.groupDataSources.get(group).addDatasource(dataSource);
            } else {
                try {
                    DynamicGroupDataSource groupDatasource = new DynamicGroupDataSource(group, this.strategy.newInstance());
                    groupDatasource.addDatasource(dataSource);
                    this.groupDataSources.put(group, groupDatasource);
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
                    this.dataSourceMap.remove(ds);
                }
            }
        }
        log.info("\u52a8\u6001\u6570\u636e\u6e90-\u52a0\u8f7d {} \u6210\u529f", (Object)ds);
    }

    public synchronized void removeDataSource(String ds) {
        if (this.dataSourceMap.containsKey(ds)) {
            String group;
            DataSource dataSource = this.dataSourceMap.get(ds);
            this.dataSourceMap.remove(ds);
            if (ds.contains(UNDERLINE) && this.groupDataSources.containsKey(group = ds.split(UNDERLINE)[0])) {
                this.groupDataSources.get(group).removeDatasource(dataSource);
            }
            log.info("\u52a8\u6001\u6570\u636e\u6e90-\u5220\u9664 {} \u6210\u529f", (Object)ds);
        } else {
            log.warn("\u52a8\u6001\u6570\u636e\u6e90-\u672a\u627e\u5230 {} \u6570\u636e\u6e90", (Object)ds);
        }
    }

    public void setP6spy(boolean p6spy) {
        if (p6spy) {
            try {
                Class.forName("com.p6spy.engine.spy.P6DataSource");
                log.info("\u52a8\u6001\u6570\u636e\u6e90-\u68c0\u6d4b\u5230\u5e76\u5f00\u542f\u4e86p6spy");
                this.p6spy = true;
            }
            catch (Exception e) {
                log.warn("\u591a\u6570\u636e\u6e90\u542f\u52a8\u5668\u5f00\u542f\u4e86p6spy\u4f46\u5e76\u672a\u5f15\u5165\u76f8\u5173\u4f9d\u8d56");
            }
        } else {
            this.p6spy = false;
        }
    }

    public void destroy() throws Exception {
        log.info("closing dynamicDatasource  ing....");
        for (Map.Entry<String, DataSource> item : this.dataSourceMap.entrySet()) {
            DataSource dataSource = item.getValue();
            if (this.p6spy) {
                Field realDataSourceField = P6DataSource.class.getDeclaredField("realDataSource");
                realDataSourceField.setAccessible(true);
                dataSource = (DataSource)realDataSourceField.get(dataSource);
            }
            Class<?> clazz = dataSource.getClass();
            try {
                Method closeMethod = clazz.getDeclaredMethod("close", new Class[0]);
                closeMethod.invoke((Object)dataSource, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.warn("\u5173\u95ed\u6570\u636e\u6e90 {} \u5931\u8d25,", (Object)item.getKey());
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, DataSource> dataSources = this.provider.loadDataSources();
        log.info("\u521d\u59cb\u5171\u52a0\u8f7d {} \u4e2a\u6570\u636e\u6e90", (Object)dataSources.size());
        for (Map.Entry<String, DataSource> dsItem : dataSources.entrySet()) {
            this.addDataSource(dsItem.getKey(), dsItem.getValue());
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u7ec4\u6570\u636e\u6e90,\u7ec4\u540d\u4e3a {} \uff0c\u5176\u4e0b\u6709 {} \u4e2a\u6570\u636e\u6e90", (Object)this.primary, (Object)this.groupDataSources.get(this.primary).size());
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u5355\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u540d\u4e3a {}", (Object)this.primary);
        } else {
            throw new RuntimeException("\u8bf7\u68c0\u67e5primary\u9ed8\u8ba4\u6570\u636e\u5e93\u8bbe\u7f6e");
        }
    }

    public void setProvider(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }

    public void setStrategy(Class<? extends DynamicDataSourceStrategy> strategy) {
        this.strategy = strategy;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

