/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.rules;

import com.baomidou.mybatisplus.toolkit.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NamingStrategy {
    nochange,
    underline_to_camel,
    remove_prefix,
    remove_prefix_and_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        String tempName = name;
        StringBuilder result = new StringBuilder();
        if (StringUtils.isCapitalMode(name)) {
            tempName = name.toLowerCase();
        }
        for (String camel : camels = tempName.split("_")) {
            if (StringUtils.isEmpty(camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefix(String name, String[] prefix) {
        if (StringUtils.isEmpty(name)) {
            return "";
        }
        if (null != prefix) {
            for (String pf : prefix) {
                if (!name.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return name.substring(pf.length());
            }
        }
        return name;
    }

    public static String removePrefixAndCamel(String name, String[] tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotEmpty(name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

