/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.entity.CountOptimize;
import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.SystemClock;
import java.sql.Date;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class PerformanceInterceptor
implements Interceptor {
    private long maxTime = 0L;
    private boolean format = false;
    private String optimizeType = "default";

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameterObject = invocation.getArgs()[1];
        RowBounds rowBounds = null;
        Pagination pagination = null;
        boolean isPageSql = false;
        if (invocation.getMethod().getName().equals("query") && (rowBounds = (RowBounds)invocation.getArgs()[2]) instanceof Pagination) {
            isPageSql = true;
            Pagination page = (Pagination)rowBounds;
            pagination = new Pagination(page.getCurrent(), page.getLimit());
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        Configuration configuration = mappedStatement.getConfiguration();
        StringBuilder sqlBuilder = new StringBuilder();
        if (isPageSql) {
            Pagination page = (Pagination)rowBounds;
            boolean orderBy = true;
            String dbType = GlobalConfiguration.getDbType(configuration).getDb();
            if (page.isSearchCount()) {
                CountOptimize countOptimize = SqlUtils.getCountOptimize(boundSql.getSql(), this.optimizeType, dbType, page.isOptimizeCount());
                orderBy = countOptimize.isOrderBy();
            }
            String sql = DialectFactory.buildPaginationSql(pagination, SqlUtils.concatOrderBy(boundSql.getSql(), page, orderBy), dbType, null).replaceAll("[\\s]+", " ");
            sqlBuilder.append(PerformanceInterceptor.getSql(configuration, boundSql, sql));
        } else {
            sqlBuilder.append(PerformanceInterceptor.getSql(configuration, boundSql, boundSql.getSql()));
        }
        String statementId = mappedStatement.getId();
        long start = SystemClock.now();
        Object result = invocation.proceed();
        long end = SystemClock.now();
        long timing = end - start;
        String sql = SqlUtils.sqlFormat(sqlBuilder.toString(), this.format);
        System.err.println(" Time\uff1a" + timing + " ms" + " - ID\uff1a" + statementId + "\n Execute SQL\uff1a" + sql + "\n");
        if (this.maxTime >= 1L && timing > this.maxTime) {
            throw new MybatisPlusException(" The SQL execution time is too large, please optimize ! ");
        }
        return result;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        sql = sql.replaceAll("[\\s]+", " ");
        if (parameterMappings != null && parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", PerformanceInterceptor.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", PerformanceInterceptor.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", PerformanceInterceptor.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        String value;
        if (obj instanceof String) {
            value = obj != null ? "'" + obj.toString() + "'" : "''";
        } else if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                value = obj != null ? "'" + obj.toString() + "'" : "''";
            } else {
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
                value = obj != null ? "'" + formatter.format(obj) + "'" : "''";
            }
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public String getOptimizeType() {
        return this.optimizeType;
    }

    public void setOptimizeType(String optimizeType) {
        this.optimizeType = optimizeType;
    }
}

