/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.common.constant.TransConfig;
import com.fhs.common.utils.CheckUtils;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.common.utils.StringUtil;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ITransTypeService {
    public static final Logger Logger = LoggerFactory.getLogger(ITransTypeService.class);
    public static final Map<String, Cache<Object, Map<String, Object>>> GLOBAL_TRANS_CACHE = new HashMap<String, Cache<Object, Map<String, Object>>>();
    public static final Map<String, String> namespaceUniqueFieldMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void put2GlobalCache(Map<String, Object> transResultMap, boolean isAccess, long cacheSeconds, int max, Object pkey, String namespace, String transType) {
        Map<String, Cache<Object, Map<String, Object>>> map = GLOBAL_TRANS_CACHE;
        synchronized (map) {
            if (GLOBAL_TRANS_CACHE.containsKey(transType + namespace)) {
                Cache<Object, Map<String, Object>> namespaceCache = GLOBAL_TRANS_CACHE.get(transType + namespace);
                namespaceCache.put((Object)ConverterUtils.toString(pkey), transResultMap);
                if (namespaceUniqueFieldMap.containsKey(namespace)) {
                    namespaceCache.put((Object)ConverterUtils.toString(transResultMap.get(namespaceUniqueFieldMap.get(namespace))), transResultMap);
                }
            } else {
                Caffeine builder = Caffeine.newBuilder();
                builder.maximumSize((long)max);
                if (isAccess) {
                    builder.expireAfterAccess(cacheSeconds, TimeUnit.SECONDS);
                } else {
                    builder.expireAfterWrite(cacheSeconds, TimeUnit.SECONDS);
                }
                Cache namespaceCache = builder.build();
                namespaceCache.put((Object)ConverterUtils.toString(pkey), transResultMap);
                GLOBAL_TRANS_CACHE.put(transType + namespace, (Cache<Object, Map<String, Object>>)namespaceCache);
            }
        }
    }

    default public void clearGlobalCache(Object pkey, String namespace, String transType) {
        if (GLOBAL_TRANS_CACHE.containsKey(transType + namespace)) {
            Cache<Object, Map<String, Object>> namespaceCache = GLOBAL_TRANS_CACHE.get(transType + namespace);
            namespaceCache.invalidate((Object)ConverterUtils.toString(pkey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Map<String, Object> getFromGlobalCache(Object pkey, String namespace, String transType) {
        Map<String, Cache<Object, Map<String, Object>>> map = GLOBAL_TRANS_CACHE;
        synchronized (map) {
            if (GLOBAL_TRANS_CACHE.containsKey(transType + namespace)) {
                Cache<Object, Map<String, Object>> namespaceCache = GLOBAL_TRANS_CACHE.get(transType + namespace);
                return (Map)namespaceCache.getIfPresent((Object)ConverterUtils.toString(pkey));
            }
        }
        return null;
    }

    default public Set<Object> initLocalFromGlobalCache(ThreadLocal<Map<String, Map<String, Object>>> threadLocalCache, Set<Object> ids, String namespace, String transType) {
        HashSet<Object> resultIds = new HashSet<Object>();
        for (Object id : ids) {
            Map<String, Object> transResultMap = this.getFromGlobalCache(id, namespace, transType);
            if (transResultMap != null) {
                threadLocalCache.get().put(namespace + "_" + id, transResultMap);
                continue;
            }
            resultIds.add(id);
        }
        return resultIds;
    }

    public void transOne(VO var1, List<Field> var2);

    public void transMore(List<? extends VO> var1, List<Field> var2);

    default public boolean setRef(Trans trans, VO vo, String val) {
        boolean isSetRef = false;
        if (CheckUtils.isNotEmpty(trans.ref())) {
            this.setValue(vo, trans.ref(), val);
            isSetRef = true;
        }
        if (CheckUtils.isNotEmpty(trans.refs())) {
            Stream.of(trans.refs()).forEach(ref -> this.setValue(vo, (String)ref, val));
            isSetRef = true;
        }
        return isSetRef;
    }

    default public void setRef(Trans trans, VO vo, Map<String, ?> valMap) {
        boolean isNeedClearValMap = false;
        if (CheckUtils.isNotEmpty(trans.ref())) {
            this.setRef(trans.ref(), vo, valMap);
            isNeedClearValMap = true;
        }
        if (CheckUtils.isNotEmpty(trans.refs())) {
            for (int i = 0; i < trans.refs().length; ++i) {
                this.setRef(trans.refs()[i], vo, valMap, i);
            }
            isNeedClearValMap = true;
        }
        if (isNeedClearValMap) {
            valMap.clear();
        }
    }

    default public void setRef(Trans trans, VO vo, Map<String, ?> valMap, VO target) {
        boolean isNeedClearValMap = false;
        if (CheckUtils.isNotEmpty(trans.ref())) {
            boolean isSetRef = false;
            if (target != null) {
                Field field = ReflectUtils.getDeclaredField(vo.getClass(), (String)trans.ref());
                if (field == null) {
                    Logger.error("ref\u5c5e\u6027:" + trans.ref() + "\u5bf9\u5e94\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728");
                    return;
                }
                if (field.getType() == target.getClass()) {
                    isSetRef = true;
                    ReflectUtils.setValue((Object)vo, (String)trans.ref(), (Object)target);
                    isNeedClearValMap = true;
                }
            }
            if (!isSetRef) {
                this.setRef(trans.ref(), vo, valMap);
                isNeedClearValMap = true;
            }
        }
        if (CheckUtils.isNotEmpty(trans.refs())) {
            for (int i = 0; i < trans.refs().length; ++i) {
                this.setRef(trans.refs()[i], vo, valMap, i);
            }
            isNeedClearValMap = true;
        }
        if (isNeedClearValMap) {
            valMap.clear();
        }
    }

    default public void setRef(String ref, VO vo, Map<String, ?> valMap) {
        this.setRef(ref, vo, valMap, null);
    }

    default public void setValue(VO vo, String ref, Object value) {
        Field field = ReflectUtils.getDeclaredField(vo.getClass(), (String)ref);
        if (value == null) {
            return;
        }
        String valueStr = StringUtil.toString(value);
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            ReflectUtils.setValue((Object)vo, (String)ref, (Object)Integer.valueOf(valueStr));
        } else if (fieldType == Long.TYPE || fieldType == Long.class) {
            ReflectUtils.setValue((Object)vo, (String)ref, (Object)Long.valueOf(valueStr));
        } else {
            ReflectUtils.setValue((Object)vo, (String)ref, (Object)valueStr);
        }
    }

    default public void setRef(String ref, VO vo, Map<String, ?> valMap, Integer index) {
        if (index == null) {
            if (valMap.size() > 0) {
                String key = valMap.keySet().iterator().next();
                this.setValue(vo, ref, valMap.get(key));
            }
        } else {
            this.setValue(vo, ref, valMap.get(new ArrayList<String>(valMap.keySet()).get(index)));
        }
    }

    default public List<? extends VO> findByIds(Callable<List<? extends VO>> callable, String dataSourceName) {
        if (!TransConfig.MULTIPLE_DATA_SOURCES) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Logger.error("", (Throwable)e);
                return null;
            }
        }
        CompletableFuture<List> cf = CompletableFuture.supplyAsync(() -> {
            try {
                if (!StringUtil.isEmpty(dataSourceName)) {
                    TransConfig.dataSourceSetter.setDataSource(dataSourceName);
                }
                return (List)callable.call();
            }
            catch (Exception e) {
                Logger.error("", (Throwable)e);
                return null;
            }
        });
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Logger.error("", (Throwable)e);
        }
        catch (ExecutionException e) {
            Logger.error("", (Throwable)e);
        }
        return null;
    }

    default public VO findById(Callable<VO> callable, String dataSourceName) {
        if (!TransConfig.MULTIPLE_DATA_SOURCES) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Logger.error("", (Throwable)e);
                return null;
            }
        }
        CompletableFuture<VO> cf = CompletableFuture.supplyAsync(() -> {
            try {
                if (!StringUtil.isEmpty(dataSourceName)) {
                    TransConfig.dataSourceSetter.setDataSource(dataSourceName);
                }
                return (VO)callable.call();
            }
            catch (Exception e) {
                Logger.error("", (Throwable)e);
                return null;
            }
        });
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Logger.error("", (Throwable)e);
        }
        catch (ExecutionException e) {
            Logger.error("", (Throwable)e);
        }
        return null;
    }

    default public void setUniqueFieldCache(String namespace, String uniqueField) {
        namespaceUniqueFieldMap.put(namespace, uniqueField);
    }
}

