/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.cache.service;

import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.utils.StringUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BothCacheService<T> {
    private static final String TRANS_PRE = "trans:";
    @Autowired(required=false)
    private RedisCacheService<T> redisCacheService;
    @Value(value="${easy-trans.dict-use-redis:false}")
    private boolean useRedis;
    private Map<String, T> localCacheMap = new ConcurrentHashMap<String, T>();

    public void put(String key, T value, boolean onlyLocal) {
        if (!onlyLocal && this.redisCacheService != null && this.useRedis) {
            this.redisCacheService.put(TRANS_PRE + key, value);
        }
        this.localCacheMap.put(key, value);
    }

    public T get(String key) {
        if (!StringUtil.isEmpty(key)) {
            if (this.localCacheMap.containsKey(key)) {
                T result = this.localCacheMap.get(key);
                return result;
            }
            if (this.redisCacheService != null && this.useRedis) {
                T result = this.redisCacheService.get(TRANS_PRE + key);
                if (Objects.nonNull(result)) {
                    this.localCacheMap.put(key, result);
                }
                return result;
            }
            return null;
        }
        return null;
    }

    public void remove(String keyStartWith, boolean onlyLocal) {
        if (!onlyLocal && Objects.nonNull(this.redisCacheService) && this.useRedis) {
            this.redisCacheService.removeFuzzy(TRANS_PRE + keyStartWith);
        }
        Set keys = this.localCacheMap.keySet().stream().filter(key -> key.startsWith(keyStartWith)).collect(Collectors.toSet());
        for (String key2 : keys) {
            this.localCacheMap.remove(key2);
        }
    }

    public RedisCacheService<T> getRedisCacheService() {
        return this.redisCacheService;
    }

    public boolean isUseRedis() {
        return this.useRedis;
    }

    public Map<String, T> getLocalCacheMap() {
        return this.localCacheMap;
    }

    public void setRedisCacheService(RedisCacheService<T> redisCacheService) {
        this.redisCacheService = redisCacheService;
    }

    public void setUseRedis(boolean useRedis) {
        this.useRedis = useRedis;
    }

    public void setLocalCacheMap(Map<String, T> localCacheMap) {
        this.localCacheMap = localCacheMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BothCacheService)) {
            return false;
        }
        BothCacheService other = (BothCacheService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseRedis() != other.isUseRedis()) {
            return false;
        }
        RedisCacheService<T> this$redisCacheService = this.getRedisCacheService();
        RedisCacheService<T> other$redisCacheService = other.getRedisCacheService();
        if (this$redisCacheService == null ? other$redisCacheService != null : !((Object)this$redisCacheService).equals(other$redisCacheService)) {
            return false;
        }
        Map<String, T> this$localCacheMap = this.getLocalCacheMap();
        Map<String, T> other$localCacheMap = other.getLocalCacheMap();
        return !(this$localCacheMap == null ? other$localCacheMap != null : !((Object)this$localCacheMap).equals(other$localCacheMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BothCacheService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseRedis() ? 79 : 97);
        RedisCacheService<T> $redisCacheService = this.getRedisCacheService();
        result = result * 59 + ($redisCacheService == null ? 43 : ((Object)$redisCacheService).hashCode());
        Map<String, T> $localCacheMap = this.getLocalCacheMap();
        result = result * 59 + ($localCacheMap == null ? 43 : ((Object)$localCacheMap).hashCode());
        return result;
    }

    public String toString() {
        return "BothCacheService(redisCacheService=" + this.getRedisCacheService() + ", useRedis=" + this.isUseRedis() + ", localCacheMap=" + this.getLocalCacheMap() + ")";
    }
}

