/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.manager.common;

import com.gitee.sunchenbin.mybatis.actable.command.PageResultCommand;
import com.gitee.sunchenbin.mybatis.actable.command.SaveOrUpdateDataCommand;
import com.gitee.sunchenbin.mybatis.actable.dao.common.BaseCRUDMapper;
import com.gitee.sunchenbin.mybatis.actable.manager.common.BaseCRUDManager;
import com.gitee.sunchenbin.mybatis.actable.utils.ColumnUtils;
import com.gitee.sunchenbin.mybatis.actable.utils.FieldUtils;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class BaseCRUDManagerImpl
implements BaseCRUDManager {
    private static final Logger log = LoggerFactory.getLogger(BaseCRUDManagerImpl.class);
    private static final String KEYFIELDMAP = "keyFieldMap";
    @Autowired
    private BaseCRUDMapper baseCRUDMapper;

    @Override
    public <T> List<T> select(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                continue;
            }
            try {
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        ArrayList list = new ArrayList();
        try {
            for (Map<String, Object> map : query) {
                Field[] declaredFields2;
                Object newInstance = t.getClass().newInstance();
                for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                    field.setAccessible(true);
                    if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                        log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                        continue;
                    }
                    String name = ColumnUtils.getColumnName(field, t.getClass());
                    this.buildFieldValue(map, newInstance, field, name);
                }
                list.add(newInstance);
            }
            return list;
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public <T> T selectByPrimaryKey(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field keyField = FieldUtils.getKeyField(t);
        if (null == keyField) {
            throw new RuntimeException("\u5f53\u524d\u5bf9\u8c61\u6ca1\u6709\u4e3b\u952e\u4e0d\u80fd\u4f7f\u7528\u8be5\u65b9\u6cd5\uff01");
        }
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            keyField.setAccessible(true);
            Object keyValue = keyField.get(t);
            if (null == keyValue) {
                throw new RuntimeException("\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3anull");
            }
            dataMap.put(ColumnUtils.getColumnName(keyField, t.getClass()), keyField.get(t));
        }
        catch (IllegalAccessException e) {
            log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
        }
        tableMap.put(tableName, dataMap);
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        if (query == null || query.size() == 0) {
            return null;
        }
        Map<String, Object> stringObjectMap = query.get(0);
        try {
            Field[] declaredFields2;
            Object newInstance = t.getClass().newInstance();
            for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                String name = ColumnUtils.getColumnName(field, t.getClass());
                this.buildFieldValue(stringObjectMap, newInstance, field, name);
            }
            return (T)newInstance;
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public <T> List<T> selectAll(Class<T> clasz) {
        String tableName = ColumnUtils.getTableName(clasz);
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap dataMap = new HashMap();
        tableMap.put(tableName, dataMap);
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (Map<String, Object> map : query) {
                Field[] declaredFields2;
                T newInstance = clasz.newInstance();
                for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                    field.setAccessible(true);
                    if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
                        log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                        continue;
                    }
                    String name = ColumnUtils.getColumnName(field, clasz);
                    this.buildFieldValue(map, newInstance, field, name);
                }
                list.add(newInstance);
            }
            return list;
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public <T> int selectCount(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                continue;
            }
            try {
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        return this.baseCRUDMapper.selectCount(tableMap);
    }

    @Override
    public <T> T selectOne(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                continue;
            }
            try {
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        if (query == null || query.size() == 0) {
            return null;
        }
        Map<String, Object> stringObjectMap = query.get(0);
        try {
            Field[] declaredFields2;
            Object newInstance = t.getClass().newInstance();
            for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                String name = ColumnUtils.getColumnName(field, t.getClass());
                this.buildFieldValue(stringObjectMap, newInstance, field, name);
            }
            return (T)newInstance;
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
    }

    @Override
    public <T> int delete(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                continue;
            }
            try {
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        return this.baseCRUDMapper.delete(tableMap);
    }

    @Override
    public <T> int deleteByPrimaryKey(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field keyField = FieldUtils.getKeyField(t);
        if (null == keyField) {
            throw new RuntimeException("\u5f53\u524d\u5bf9\u8c61\u6ca1\u6709\u4e3b\u952e\u4e0d\u80fd\u4f7f\u7528\u8be5\u65b9\u6cd5\uff01");
        }
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            keyField.setAccessible(true);
            Object keyValue = keyField.get(t);
            if (null == keyValue) {
                throw new RuntimeException("\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3anull");
            }
            dataMap.put(ColumnUtils.getColumnName(keyField, t.getClass()), keyField.get(t));
        }
        catch (IllegalAccessException e) {
            log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
        }
        tableMap.put(tableName, dataMap);
        return this.baseCRUDMapper.delete(tableMap);
    }

    @Override
    public <T> boolean existsByPrimaryKey(T t) {
        T result = this.selectByPrimaryKey(t);
        return null != result;
    }

    @Override
    public <T> T insert(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap keyFieldMap = new HashMap();
        Field keyField = null;
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                boolean isKey = ColumnUtils.isKey(field, t.getClass());
                boolean autoIncrement = ColumnUtils.isAutoIncrement(field, t.getClass());
                if (isKey) {
                    keyField = field;
                }
                if (isKey && !autoIncrement && field.get(t) == null) {
                    log.error("\u4e3b\u952e\u975e\u81ea\u589e\u7684\u60c5\u51b5\u4e0b\u4fdd\u5b58\u65f6\u4e0d\u80fd\u4e3anull\uff01");
                    throw new RuntimeException("\u4e3b\u952e\u975e\u81ea\u589e\u7684\u60c5\u51b5\u4e0b\u4fdd\u5b58\u65f6\u4e0d\u80fd\u4e3anull\uff01");
                }
                if (autoIncrement) {
                    log.warn("\u5b57\u6bb5\uff1a" + field.getName() + "\u662f\u81ea\u589e\u7684\u4e0d\u9700\u8981\u8bbe\u7f6e\u503c");
                    continue;
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (IllegalAccessException e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        SaveOrUpdateDataCommand saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
        int count = this.baseCRUDMapper.insert(saveOrUpdateDataCommand);
        if (count == 0) {
            return null;
        }
        if (keyField == null) {
            return this.selectOne(t);
        }
        if (ColumnUtils.isAutoIncrement(keyField, t.getClass())) {
            keyField.setAccessible(true);
            try {
                String type = keyField.getGenericType().toString();
                if (type.equals("class java.lang.Long") || type.equals("long")) {
                    keyField.set(t, saveOrUpdateDataCommand.getId());
                } else if (type.equals("class java.lang.Integer") || type.equals("int")) {
                    keyField.set(t, saveOrUpdateDataCommand.getId().intValue());
                } else {
                    log.error("\u81ea\u589e\u4e3b\u952e\u7c7b\u578b\u8d85\u51fa\u7a0b\u5e8f\u652f\u6301\u7684\u8303\u56f4\u76ee\u524d\u53ea\u652f\u6301(Long/Integer/long/int)");
                }
                return this.selectByPrimaryKey(t);
            }
            catch (IllegalAccessException e) {
                log.error("\u5c06\u81ea\u589e\u4e3b\u952e\u8bbe\u7f6e\u7ed9\u6e90\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u5c06\u81ea\u589e\u4e3b\u952e\u8bbe\u7f6e\u7ed9\u6e90\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return this.selectByPrimaryKey(t);
    }

    @Override
    public <T> T insertSelective(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap keyFieldMap = new HashMap();
        Field keyField = null;
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                boolean isKey = ColumnUtils.isKey(field, t.getClass());
                boolean autoIncrement = ColumnUtils.isAutoIncrement(field, t.getClass());
                if (isKey) {
                    keyField = field;
                }
                if (isKey && !autoIncrement && field.get(t) == null) {
                    log.error("\u4e3b\u952e\u975e\u81ea\u589e\u7684\u60c5\u51b5\u4e0b\u4fdd\u5b58\u65f6\u4e0d\u80fd\u4e3anull\uff01");
                    throw new RuntimeException("\u4e3b\u952e\u975e\u81ea\u589e\u7684\u60c5\u51b5\u4e0b\u4fdd\u5b58\u65f6\u4e0d\u80fd\u4e3anull\uff01");
                }
                if (autoIncrement) {
                    log.warn("\u5b57\u6bb5\uff1a" + field.getName() + "\u662f\u81ea\u589e\u7684\u4e0d\u9700\u8981\u8bbe\u7f6e\u503c");
                    continue;
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (IllegalAccessException e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        SaveOrUpdateDataCommand saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
        int count = this.baseCRUDMapper.insertSelective(saveOrUpdateDataCommand);
        if (count <= 0) {
            return null;
        }
        if (null == keyField) {
            return this.selectOne(t);
        }
        if (ColumnUtils.isAutoIncrement(keyField, t.getClass())) {
            keyField.setAccessible(true);
            try {
                String type = keyField.getGenericType().toString();
                if (type.equals("class java.lang.Long") || type.equals("long")) {
                    keyField.set(t, saveOrUpdateDataCommand.getId());
                } else if (type.equals("class java.lang.Integer") || type.equals("int")) {
                    keyField.set(t, saveOrUpdateDataCommand.getId().intValue());
                } else {
                    log.error("\u81ea\u589e\u4e3b\u952e\u7c7b\u578b\u8d85\u51fa\u7a0b\u5e8f\u652f\u6301\u7684\u8303\u56f4\u76ee\u524d\u53ea\u652f\u6301(Long/Integer/long/int)");
                }
                return this.selectByPrimaryKey(t);
            }
            catch (IllegalAccessException e) {
                log.error("\u5c06\u81ea\u589e\u4e3b\u952e\u8bbe\u7f6e\u7ed9\u6e90\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u5c06\u81ea\u589e\u4e3b\u952e\u8bbe\u7f6e\u7ed9\u6e90\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return this.selectByPrimaryKey(t);
    }

    @Override
    public <T> boolean updateByPrimaryKey(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, Object> keyFieldMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                if (ColumnUtils.isKey(field, t.getClass())) {
                    if (field.get(t) != null) {
                        keyFieldMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
                    } else {
                        log.error("\u4e3b\u952e\u66f4\u65b0\u7684\u60c5\u51b5\u4e0b\u4e0d\u80fd\u4e3anull\uff01");
                        throw new RuntimeException("\u4e3b\u952e\u66f4\u65b0\u7684\u60c5\u51b5\u4e0b\u4e0d\u80fd\u4e3anull\uff01");
                    }
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (IllegalAccessException e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        if (keyFieldMap.isEmpty()) {
            log.error("\u4e0d\u652f\u6301\u5bf9\u6ca1\u6709\u4e3b\u952e\u7684\u8868:{}\u8fdb\u884c\u66f4\u65b0\uff01", (Object)tableName);
            throw new RuntimeException("\u4e0d\u652f\u6301\u5bf9\u6ca1\u6709\u4e3b\u952e\u7684\u8868\u8fdb\u884c\u66f4\u65b0\uff01");
        }
        dataMap.put(KEYFIELDMAP, keyFieldMap);
        tableMap.put(tableName, dataMap);
        SaveOrUpdateDataCommand saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
        int count = this.baseCRUDMapper.updateByPrimaryKey(saveOrUpdateDataCommand);
        return count > 0;
    }

    @Override
    public <T> boolean updateByPrimaryKeySelective(T t) {
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, Object> keyFieldMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                if (ColumnUtils.isKey(field, t.getClass())) {
                    if (field.get(t) != null) {
                        keyFieldMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
                    } else {
                        log.error("\u4e3b\u952e\u66f4\u65b0\u7684\u60c5\u51b5\u4e0b\u4e0d\u80fd\u4e3anull\uff01");
                        throw new RuntimeException("\u4e3b\u952e\u66f4\u65b0\u7684\u60c5\u51b5\u4e0b\u4e0d\u80fd\u4e3anull\uff01");
                    }
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (IllegalAccessException e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        if (keyFieldMap.isEmpty()) {
            log.error("\u4e0d\u652f\u6301\u5bf9\u6ca1\u6709\u4e3b\u952e\u7684\u8868:{}\u8fdb\u884c\u66f4\u65b0\uff01", (Object)tableName);
            throw new RuntimeException("\u4e0d\u652f\u6301\u5bf9\u6ca1\u6709\u4e3b\u952e\u7684\u8868\u8fdb\u884c\u66f4\u65b0\uff01");
        }
        dataMap.put(KEYFIELDMAP, keyFieldMap);
        tableMap.put(tableName, dataMap);
        SaveOrUpdateDataCommand saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
        int count = this.baseCRUDMapper.updateByPrimaryKeySelective(saveOrUpdateDataCommand);
        return count > 0;
    }

    @Override
    public List<LinkedHashMap<String, Object>> query(String sql) {
        log.info(sql);
        return this.baseCRUDMapper.query(sql);
    }

    @Override
    public <T> List<T> query(String sql, Class<T> beanClass) {
        if (null == beanClass) {
            return null;
        }
        List<LinkedHashMap<String, Object>> query = this.baseCRUDMapper.query(sql);
        if (null == query || query.size() == 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Map map : query) {
            try {
                Field[] fields;
                T t = beanClass.newInstance();
                for (Field field : fields = FieldUtils.getAllFields(t)) {
                    field.setAccessible(true);
                    String name = ColumnUtils.getColumnName(field, t.getClass());
                    if (null == map.get(name)) continue;
                    this.buildFieldValue(map, t, field, name);
                }
                list.add(t);
            }
            catch (Exception e) {
                log.error("map\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                throw new RuntimeException("map\u8f6c\u5bf9\u8c61\u5931\u8d25");
            }
        }
        return list;
    }

    @Override
    public <T> PageResultCommand<T> search(T t, Integer currentPage, Integer pageSize, LinkedHashMap<String, String> orderby) {
        String startKey = "start";
        String sizeKey = "pageSize";
        String currentPageKey = "currentPage";
        String orderByKey = "orderBy";
        Integer sizeVal = pageSize == null ? 10 : pageSize;
        Integer currentPageVal = currentPage == null ? 1 : currentPage;
        Integer startVal = (currentPageVal - 1) * sizeVal;
        LinkedHashMap<String, String> orderByVal = orderby;
        PageResultCommand pageResultCommand = new PageResultCommand();
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        if (currentPageVal != null && currentPageVal > 0) {
            tableMap.put(startKey, startVal);
            tableMap.put(sizeKey, sizeVal);
        }
        if (orderByVal != null && orderByVal.size() > 0) {
            tableMap.put(orderByKey, orderByVal);
        }
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        ArrayList list = new ArrayList();
        try {
            for (Map<String, Object> map : query) {
                Field[] declaredFields2;
                Object newInstance = t.getClass().newInstance();
                for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                    field.setAccessible(true);
                    if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                        log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                        continue;
                    }
                    String name = ColumnUtils.getColumnName(field, t.getClass());
                    this.buildFieldValue(map, newInstance, field, name);
                }
                list.add(newInstance);
            }
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
        if (null != list && list.size() > 0) {
            pageResultCommand.setData(list);
            int queryCount = this.selectCount(t);
            pageResultCommand.setRecordsFiltered(queryCount);
            pageResultCommand.setRecordsTotal(queryCount);
        }
        return pageResultCommand;
    }

    @Override
    public <T> PageResultCommand<T> search(T t) {
        String startKey = "start";
        String sizeKey = "pageSize";
        String currentPageKey = "currentPage";
        String orderByKey = "orderBy";
        Integer startVal = null;
        Integer sizeVal = null;
        Integer currentPageVal = null;
        HashMap orderByVal = null;
        PageResultCommand pageResultCommand = new PageResultCommand();
        String tableName = ColumnUtils.getTableName(t.getClass());
        if (StringUtils.isEmpty((Object)tableName)) {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            throw new RuntimeException("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
        }
        Field[] declaredFields = FieldUtils.getAllFields(t);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                if (startKey.equals(field.getName())) {
                    startVal = (Integer)field.get(t);
                }
                if (sizeKey.equals(field.getName())) {
                    sizeVal = (Integer)field.get(t);
                }
                if (currentPageKey.equals(field.getName())) {
                    currentPageVal = (Integer)field.get(t);
                }
                if (orderByKey.equals(field.getName())) {
                    orderByVal = (LinkedHashMap)field.get(t);
                }
                if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                    log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                dataMap.put(ColumnUtils.getColumnName(field, t.getClass()), field.get(t));
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u64cd\u4f5c\u5bf9\u8c61\u7684Field\u51fa\u73b0\u5f02\u5e38");
            }
        }
        tableMap.put(tableName, dataMap);
        if (currentPageVal != null && currentPageVal > 0) {
            tableMap.put(startKey, startVal);
            tableMap.put(sizeKey, sizeVal);
        }
        if (orderByVal != null && orderByVal.size() > 0) {
            tableMap.put(orderByKey, orderByVal);
        }
        List<Map<String, Object>> query = this.baseCRUDMapper.select(tableMap);
        ArrayList list = new ArrayList();
        try {
            for (Map<String, Object> map : query) {
                Field[] declaredFields2;
                Object newInstance = t.getClass().newInstance();
                for (Field field : declaredFields2 = FieldUtils.getAllFields(newInstance)) {
                    field.setAccessible(true);
                    if (!ColumnUtils.hasColumnAnnotation(field, t.getClass())) {
                        log.debug("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                        continue;
                    }
                    String name = ColumnUtils.getColumnName(field, t.getClass());
                    this.buildFieldValue(map, newInstance, field, name);
                }
                list.add(newInstance);
            }
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u7ed3\u679c\u96c6\u8f6c\u5bf9\u8c61\u5931\u8d25");
        }
        if (null != list && list.size() > 0) {
            pageResultCommand.setData(list);
            int queryCount = this.selectCount(t);
            pageResultCommand.setRecordsFiltered(queryCount);
            pageResultCommand.setRecordsTotal(queryCount);
        }
        return pageResultCommand;
    }

    private <T> void buildFieldValue(Map<String, Object> map, T newInstance, Field field, String name) throws IllegalAccessException {
        if (field.getGenericType().toString().equals("class java.time.LocalDateTime") && map.get(name) != null) {
            field.set(newInstance, Timestamp.valueOf(map.get(name).toString()).toLocalDateTime());
        } else if (field.getGenericType().toString().equals("class java.time.LocalDate") && map.get(name) != null) {
            field.set(newInstance, Date.valueOf(map.get(name).toString()).toLocalDate());
        } else if (field.getGenericType().toString().equals("class java.time.LocalTime") && map.get(name) != null) {
            field.set(newInstance, Time.valueOf(map.get(name).toString()).toLocalTime());
        } else if (field.getGenericType().toString().equals("class java.lang.Short") && map.get(name) != null) {
            field.set(newInstance, Short.parseShort(map.get(name).toString()));
        } else {
            field.set(newInstance, map.get(name));
        }
    }
}

