/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.tika;

import de.innosystec.unrar.Archive;
import de.innosystec.unrar.NativeStorage;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RARParser
implements Parser {
    private static final MediaType TYPE = MediaType.application((String)"x-rar-compressed");

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(TYPE);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        EmbeddedDocumentExtractor extractor = new EmbeddedDocumentExtractor(context);
        try {
            File file = TikaInputStream.get((InputStream)stream).getFile();
            Archive archive = new Archive(new NativeStorage(file));
            metadata.set("Content-Type", TYPE.toString());
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            for (FileHeader header : archive.getFileHeaders()) {
                Metadata entrydata = new Metadata();
                entrydata.set("resourceName", header.getFileNameString());
                if (!extractor.shouldParseEmbedded(entrydata)) continue;
                extractor.parseEmbedded(stream, (ContentHandler)xhtml, entrydata, true);
            }
            xhtml.endDocument();
        }
        catch (RarException e) {
            throw new TikaException("Unable to parse a RAR archive", (Throwable)e);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

