/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultApacheHttpClientBuilder
implements ApacheHttpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultApacheHttpClientBuilder.class);
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private int connectionRequestTimeout = 3000;
    private int connectionTimeout = 5000;
    private int soTimeout = 5000;
    private int idleConnTimeout = 60000;
    private int checkWaitTime = 60000;
    private int maxConnPerHost = 10;
    private int maxTotalConn = 50;
    private String userAgent;
    private String[] supportedProtocols = new String[]{"TLSv1.2", "TLSv1.3", "TLSv1.1", "TLSv1"};
    private List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy;
    private final HttpRequestRetryHandler defaultHttpRequestRetryHandler = (exception, executionCount, context) -> false;
    private SSLConnectionSocketFactory sslConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
    private final PlainConnectionSocketFactory plainConnectionSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private CloseableHttpClient closeableHttpClient;

    private DefaultApacheHttpClientBuilder() {
    }

    public static DefaultApacheHttpClientBuilder get() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpRequestRetryHandler(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.connectionKeepAliveStrategy = keepAliveStrategy;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder sslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        this.sslConnectionSocketFactory = sslConnectionSocketFactory;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder supportedProtocols(String[] supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    public IdleConnectionMonitorThread getIdleConnectionMonitorThread() {
        return this.idleConnectionMonitorThread;
    }

    private synchronized void prepare() {
        if (this.prepared.get()) {
            return;
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)this.plainConnectionSocketFactory).register("https", (Object)this.sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.maxTotalConn);
        connectionManager.setDefaultMaxPerRoute(this.maxConnPerHost);
        connectionManager.setDefaultSocketConfig(SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(this.soTimeout).build());
        this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager, this.idleConnTimeout, this.checkWaitTime);
        this.idleConnectionMonitorThread.setDaemon(true);
        this.idleConnectionMonitorThread.start();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setSSLSocketFactory((LayeredConnectionSocketFactory)this.buildSSLConnectionSocketFactory()).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(this.soTimeout).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build());
        this.httpRequestRetryHandler = this.httpRequestRetryHandler == null ? this.defaultHttpRequestRetryHandler : this.httpRequestRetryHandler;
        httpClientBuilder.setRetryHandler(this.httpRequestRetryHandler);
        if (this.connectionKeepAliveStrategy != null) {
            httpClientBuilder.setKeepAliveStrategy(this.connectionKeepAliveStrategy);
        }
        if (StringUtils.isNotBlank((CharSequence)this.httpProxyHost) && StringUtils.isNotBlank((CharSequence)this.httpProxyUsername)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort), (Credentials)new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            httpClientBuilder.setProxy(new HttpHost(this.httpProxyHost, this.httpProxyPort));
        }
        if (StringUtils.isNotBlank((CharSequence)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        this.requestInterceptors.forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addInterceptorFirst(arg_0));
        this.responseInterceptors.forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addInterceptorLast(arg_0));
        this.closeableHttpClient = httpClientBuilder.build();
        this.prepared.set(true);
    }

    private SSLConnectionSocketFactory buildSSLConnectionSocketFactory() {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
            return new SSLConnectionSocketFactory(sslcontext, this.supportedProtocols, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("\u6784\u5efaSSL\u8fde\u63a5\u5de5\u5382\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    @Override
    public CloseableHttpClient build() {
        if (!this.prepared.get()) {
            this.prepare();
        }
        return this.closeableHttpClient;
    }

    public AtomicBoolean getPrepared() {
        return this.prepared;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getIdleConnTimeout() {
        return this.idleConnTimeout;
    }

    public int getCheckWaitTime() {
        return this.checkWaitTime;
    }

    public int getMaxConnPerHost() {
        return this.maxConnPerHost;
    }

    public int getMaxTotalConn() {
        return this.maxTotalConn;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String[] getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public List<HttpRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public List<HttpResponseInterceptor> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    public HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return this.httpRequestRetryHandler;
    }

    public ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return this.connectionKeepAliveStrategy;
    }

    public HttpRequestRetryHandler getDefaultHttpRequestRetryHandler() {
        return this.defaultHttpRequestRetryHandler;
    }

    public SSLConnectionSocketFactory getSslConnectionSocketFactory() {
        return this.sslConnectionSocketFactory;
    }

    public PlainConnectionSocketFactory getPlainConnectionSocketFactory() {
        return this.plainConnectionSocketFactory;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public CloseableHttpClient getCloseableHttpClient() {
        return this.closeableHttpClient;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setIdleConnTimeout(int idleConnTimeout) {
        this.idleConnTimeout = idleConnTimeout;
    }

    public void setCheckWaitTime(int checkWaitTime) {
        this.checkWaitTime = checkWaitTime;
    }

    public void setMaxConnPerHost(int maxConnPerHost) {
        this.maxConnPerHost = maxConnPerHost;
    }

    public void setMaxTotalConn(int maxTotalConn) {
        this.maxTotalConn = maxTotalConn;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setSupportedProtocols(String[] supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public void setRequestInterceptors(List<HttpRequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public void setResponseInterceptors(List<HttpResponseInterceptor> responseInterceptors) {
        this.responseInterceptors = responseInterceptors;
    }

    public void setHttpRequestRetryHandler(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
    }

    public void setConnectionKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.connectionKeepAliveStrategy = connectionKeepAliveStrategy;
    }

    public void setSslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        this.sslConnectionSocketFactory = sslConnectionSocketFactory;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setIdleConnectionMonitorThread(IdleConnectionMonitorThread idleConnectionMonitorThread) {
        this.idleConnectionMonitorThread = idleConnectionMonitorThread;
    }

    public void setCloseableHttpClient(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultApacheHttpClientBuilder)) {
            return false;
        }
        DefaultApacheHttpClientBuilder other = (DefaultApacheHttpClientBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionRequestTimeout() != other.getConnectionRequestTimeout()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getSoTimeout() != other.getSoTimeout()) {
            return false;
        }
        if (this.getIdleConnTimeout() != other.getIdleConnTimeout()) {
            return false;
        }
        if (this.getCheckWaitTime() != other.getCheckWaitTime()) {
            return false;
        }
        if (this.getMaxConnPerHost() != other.getMaxConnPerHost()) {
            return false;
        }
        if (this.getMaxTotalConn() != other.getMaxTotalConn()) {
            return false;
        }
        if (this.getHttpProxyPort() != other.getHttpProxyPort()) {
            return false;
        }
        AtomicBoolean this$prepared = this.getPrepared();
        AtomicBoolean other$prepared = other.getPrepared();
        if (this$prepared == null ? other$prepared != null : !this$prepared.equals(other$prepared)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSupportedProtocols(), other.getSupportedProtocols())) {
            return false;
        }
        List<HttpRequestInterceptor> this$requestInterceptors = this.getRequestInterceptors();
        List<HttpRequestInterceptor> other$requestInterceptors = other.getRequestInterceptors();
        if (this$requestInterceptors == null ? other$requestInterceptors != null : !((Object)this$requestInterceptors).equals(other$requestInterceptors)) {
            return false;
        }
        List<HttpResponseInterceptor> this$responseInterceptors = this.getResponseInterceptors();
        List<HttpResponseInterceptor> other$responseInterceptors = other.getResponseInterceptors();
        if (this$responseInterceptors == null ? other$responseInterceptors != null : !((Object)this$responseInterceptors).equals(other$responseInterceptors)) {
            return false;
        }
        HttpRequestRetryHandler this$httpRequestRetryHandler = this.getHttpRequestRetryHandler();
        HttpRequestRetryHandler other$httpRequestRetryHandler = other.getHttpRequestRetryHandler();
        if (this$httpRequestRetryHandler == null ? other$httpRequestRetryHandler != null : !this$httpRequestRetryHandler.equals(other$httpRequestRetryHandler)) {
            return false;
        }
        ConnectionKeepAliveStrategy this$connectionKeepAliveStrategy = this.getConnectionKeepAliveStrategy();
        ConnectionKeepAliveStrategy other$connectionKeepAliveStrategy = other.getConnectionKeepAliveStrategy();
        if (this$connectionKeepAliveStrategy == null ? other$connectionKeepAliveStrategy != null : !this$connectionKeepAliveStrategy.equals(other$connectionKeepAliveStrategy)) {
            return false;
        }
        HttpRequestRetryHandler this$defaultHttpRequestRetryHandler = this.getDefaultHttpRequestRetryHandler();
        HttpRequestRetryHandler other$defaultHttpRequestRetryHandler = other.getDefaultHttpRequestRetryHandler();
        if (this$defaultHttpRequestRetryHandler == null ? other$defaultHttpRequestRetryHandler != null : !this$defaultHttpRequestRetryHandler.equals(other$defaultHttpRequestRetryHandler)) {
            return false;
        }
        SSLConnectionSocketFactory this$sslConnectionSocketFactory = this.getSslConnectionSocketFactory();
        SSLConnectionSocketFactory other$sslConnectionSocketFactory = other.getSslConnectionSocketFactory();
        if (this$sslConnectionSocketFactory == null ? other$sslConnectionSocketFactory != null : !this$sslConnectionSocketFactory.equals(other$sslConnectionSocketFactory)) {
            return false;
        }
        PlainConnectionSocketFactory this$plainConnectionSocketFactory = this.getPlainConnectionSocketFactory();
        PlainConnectionSocketFactory other$plainConnectionSocketFactory = other.getPlainConnectionSocketFactory();
        if (this$plainConnectionSocketFactory == null ? other$plainConnectionSocketFactory != null : !this$plainConnectionSocketFactory.equals(other$plainConnectionSocketFactory)) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        String this$httpProxyPassword = this.getHttpProxyPassword();
        String other$httpProxyPassword = other.getHttpProxyPassword();
        if (this$httpProxyPassword == null ? other$httpProxyPassword != null : !this$httpProxyPassword.equals(other$httpProxyPassword)) {
            return false;
        }
        IdleConnectionMonitorThread this$idleConnectionMonitorThread = this.getIdleConnectionMonitorThread();
        IdleConnectionMonitorThread other$idleConnectionMonitorThread = other.getIdleConnectionMonitorThread();
        if (this$idleConnectionMonitorThread == null ? other$idleConnectionMonitorThread != null : !this$idleConnectionMonitorThread.equals(other$idleConnectionMonitorThread)) {
            return false;
        }
        CloseableHttpClient this$closeableHttpClient = this.getCloseableHttpClient();
        CloseableHttpClient other$closeableHttpClient = other.getCloseableHttpClient();
        return !(this$closeableHttpClient == null ? other$closeableHttpClient != null : !this$closeableHttpClient.equals(other$closeableHttpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultApacheHttpClientBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionRequestTimeout();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getSoTimeout();
        result = result * 59 + this.getIdleConnTimeout();
        result = result * 59 + this.getCheckWaitTime();
        result = result * 59 + this.getMaxConnPerHost();
        result = result * 59 + this.getMaxTotalConn();
        result = result * 59 + this.getHttpProxyPort();
        AtomicBoolean $prepared = this.getPrepared();
        result = result * 59 + ($prepared == null ? 43 : $prepared.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSupportedProtocols());
        List<HttpRequestInterceptor> $requestInterceptors = this.getRequestInterceptors();
        result = result * 59 + ($requestInterceptors == null ? 43 : ((Object)$requestInterceptors).hashCode());
        List<HttpResponseInterceptor> $responseInterceptors = this.getResponseInterceptors();
        result = result * 59 + ($responseInterceptors == null ? 43 : ((Object)$responseInterceptors).hashCode());
        HttpRequestRetryHandler $httpRequestRetryHandler = this.getHttpRequestRetryHandler();
        result = result * 59 + ($httpRequestRetryHandler == null ? 43 : $httpRequestRetryHandler.hashCode());
        ConnectionKeepAliveStrategy $connectionKeepAliveStrategy = this.getConnectionKeepAliveStrategy();
        result = result * 59 + ($connectionKeepAliveStrategy == null ? 43 : $connectionKeepAliveStrategy.hashCode());
        HttpRequestRetryHandler $defaultHttpRequestRetryHandler = this.getDefaultHttpRequestRetryHandler();
        result = result * 59 + ($defaultHttpRequestRetryHandler == null ? 43 : $defaultHttpRequestRetryHandler.hashCode());
        SSLConnectionSocketFactory $sslConnectionSocketFactory = this.getSslConnectionSocketFactory();
        result = result * 59 + ($sslConnectionSocketFactory == null ? 43 : $sslConnectionSocketFactory.hashCode());
        PlainConnectionSocketFactory $plainConnectionSocketFactory = this.getPlainConnectionSocketFactory();
        result = result * 59 + ($plainConnectionSocketFactory == null ? 43 : $plainConnectionSocketFactory.hashCode());
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        String $httpProxyPassword = this.getHttpProxyPassword();
        result = result * 59 + ($httpProxyPassword == null ? 43 : $httpProxyPassword.hashCode());
        IdleConnectionMonitorThread $idleConnectionMonitorThread = this.getIdleConnectionMonitorThread();
        result = result * 59 + ($idleConnectionMonitorThread == null ? 43 : $idleConnectionMonitorThread.hashCode());
        CloseableHttpClient $closeableHttpClient = this.getCloseableHttpClient();
        result = result * 59 + ($closeableHttpClient == null ? 43 : $closeableHttpClient.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultApacheHttpClientBuilder(prepared=" + this.getPrepared() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", soTimeout=" + this.getSoTimeout() + ", idleConnTimeout=" + this.getIdleConnTimeout() + ", checkWaitTime=" + this.getCheckWaitTime() + ", maxConnPerHost=" + this.getMaxConnPerHost() + ", maxTotalConn=" + this.getMaxTotalConn() + ", userAgent=" + this.getUserAgent() + ", supportedProtocols=" + Arrays.deepToString(this.getSupportedProtocols()) + ", requestInterceptors=" + this.getRequestInterceptors() + ", responseInterceptors=" + this.getResponseInterceptors() + ", httpRequestRetryHandler=" + this.getHttpRequestRetryHandler() + ", connectionKeepAliveStrategy=" + this.getConnectionKeepAliveStrategy() + ", defaultHttpRequestRetryHandler=" + this.getDefaultHttpRequestRetryHandler() + ", sslConnectionSocketFactory=" + this.getSslConnectionSocketFactory() + ", plainConnectionSocketFactory=" + this.getPlainConnectionSocketFactory() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", httpProxyUsername=" + this.getHttpProxyUsername() + ", httpProxyPassword=" + this.getHttpProxyPassword() + ", idleConnectionMonitorThread=" + this.getIdleConnectionMonitorThread() + ", closeableHttpClient=" + this.getCloseableHttpClient() + ")";
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private final int idleConnTimeout;
        private final int checkWaitTime;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, int idleConnTimeout, int checkWaitTime) {
            super("IdleConnectionMonitorThread");
            this.connMgr = connMgr;
            this.idleConnTimeout = idleConnTimeout;
            this.checkWaitTime = checkWaitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(this.checkWaitTime);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections((long)this.idleConnTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trigger() {
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private static class SingletonHolder {
        private static final DefaultApacheHttpClientBuilder INSTANCE = new DefaultApacheHttpClientBuilder();

        private SingletonHolder() {
        }
    }
}

