/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.message;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouterRule;
import cn.binarywang.wx.miniapp.message.WxMaXmlOutMessage;
import cn.binarywang.wx.miniapp.util.WxMaConfigHolder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateCheckerSingleton;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaMessageRouter {
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final Logger log = LoggerFactory.getLogger(WxMaMessageRouter.class);
    private final List<WxMaMessageRouterRule> rules = new ArrayList<WxMaMessageRouterRule>();
    private final WxMaService wxMaService;
    private ExecutorService executorService;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;
    private WxMessageDuplicateChecker messageDuplicateChecker;

    public WxMaMessageRouter(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WxMaMessageRouter-pool-%d").build();
        this.executorService = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
    }

    public WxMaMessageRouter(WxMaService wxMaService, ExecutorService executorService) {
        this.wxMaService = wxMaService;
        this.executorService = executorService;
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
        this.messageDuplicateChecker = WxMessageInMemoryDuplicateCheckerSingleton.getInstance();
    }

    public void shutDownExecutorService() {
        this.executorService.shutdown();
    }

    public void shutDownExecutorService(Integer second) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(second.intValue(), TimeUnit.SECONDS)) {
                    this.log.error("\u7ebf\u7a0b\u6c60\u672a\u5173\u95ed\uff01");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public WxMaMessageRouterRule rule() {
        return new WxMaMessageRouterRule(this);
    }

    public WxMaXmlOutMessage route(WxMaMessage wxMessage, Map<String, Object> context) {
        if (this.isMsgDuplicated(wxMessage)) {
            return null;
        }
        ArrayList<WxMaMessageRouterRule> matchRules = new ArrayList<WxMaMessageRouterRule>();
        for (WxMaMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.isEmpty()) {
            return null;
        }
        ArrayList futures = new ArrayList();
        WxMaXmlOutMessage result = null;
        for (WxMaMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                String miniAppId = this.wxMaService.getWxMaConfig().getAppid();
                futures.add(this.executorService.submit(() -> {
                    this.wxMaService.switchoverTo(miniAppId);
                    rule.service(wxMessage, context, this.wxMaService, this.sessionManager, this.exceptionHandler);
                    WxMaConfigHolder.remove();
                }));
                continue;
            }
            result = rule.service(wxMessage, context, this.wxMaService, this.sessionManager, this.exceptionHandler);
            this.log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getFromUser());
            this.sessionEndAccess(wxMessage);
        }
        if (!futures.isEmpty()) {
            this.executorService.submit(() -> {
                for (Future future : futures) {
                    try {
                        future.get();
                        this.log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getFromUser());
                        this.sessionEndAccess(wxMessage);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.log.error("Error happened when wait task finish", (Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    public WxMaXmlOutMessage route(WxMaMessage wxMessage) {
        return this.route(wxMessage, new HashMap<String, Object>(2));
    }

    protected boolean isMsgDuplicated(WxMaMessage wxMessage) {
        StringBuilder messageId = new StringBuilder();
        if (wxMessage.getMsgId() == null) {
            messageId.append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser()).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEvent()));
        } else {
            messageId.append(wxMessage.getMsgId()).append("-").append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUser());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getToUser())) {
            messageId.append("-").append(wxMessage.getToUser());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getTraceId())) {
            messageId.append("-").append(wxMessage.getTraceId());
        }
        return this.messageDuplicateChecker.isDuplicate(messageId.toString());
    }

    private void sessionEndAccess(WxMaMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getFromUser());
        if (session != null) {
            session.endAccess();
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public List<WxMaMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxMaService getWxMaService() {
        return this.wxMaService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public WxSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public WxErrorExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public WxMessageDuplicateChecker getMessageDuplicateChecker() {
        return this.messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMaMessageRouter)) {
            return false;
        }
        WxMaMessageRouter other = (WxMaMessageRouter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        List<WxMaMessageRouterRule> this$rules = this.getRules();
        List<WxMaMessageRouterRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        WxMaService this$wxMaService = this.getWxMaService();
        WxMaService other$wxMaService = other.getWxMaService();
        if (this$wxMaService == null ? other$wxMaService != null : !this$wxMaService.equals(other$wxMaService)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        WxSessionManager this$sessionManager = this.getSessionManager();
        WxSessionManager other$sessionManager = other.getSessionManager();
        if (this$sessionManager == null ? other$sessionManager != null : !this$sessionManager.equals(other$sessionManager)) {
            return false;
        }
        WxErrorExceptionHandler this$exceptionHandler = this.getExceptionHandler();
        WxErrorExceptionHandler other$exceptionHandler = other.getExceptionHandler();
        if (this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler)) {
            return false;
        }
        WxMessageDuplicateChecker this$messageDuplicateChecker = this.getMessageDuplicateChecker();
        WxMessageDuplicateChecker other$messageDuplicateChecker = other.getMessageDuplicateChecker();
        return !(this$messageDuplicateChecker == null ? other$messageDuplicateChecker != null : !this$messageDuplicateChecker.equals(other$messageDuplicateChecker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMaMessageRouter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        List<WxMaMessageRouterRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        WxMaService $wxMaService = this.getWxMaService();
        result = result * 59 + ($wxMaService == null ? 43 : $wxMaService.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        WxSessionManager $sessionManager = this.getSessionManager();
        result = result * 59 + ($sessionManager == null ? 43 : $sessionManager.hashCode());
        WxErrorExceptionHandler $exceptionHandler = this.getExceptionHandler();
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        WxMessageDuplicateChecker $messageDuplicateChecker = this.getMessageDuplicateChecker();
        result = result * 59 + ($messageDuplicateChecker == null ? 43 : $messageDuplicateChecker.hashCode());
        return result;
    }

    public String toString() {
        return "WxMaMessageRouter(log=" + this.getLog() + ", rules=" + this.getRules() + ", wxMaService=" + this.getWxMaService() + ", executorService=" + this.getExecutorService() + ", sessionManager=" + this.getSessionManager() + ", exceptionHandler=" + this.getExceptionHandler() + ", messageDuplicateChecker=" + this.getMessageDuplicateChecker() + ")";
    }
}

