/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorationStage;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorInterceptor;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DecoratedDataSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DataSourceDecoratorBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private DataSourceDecoratorProperties dataSourceDecoratorProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource && !ScopedProxyUtils.isScopedTarget((String)beanName) && !this.getDataSourceDecoratorProperties().getExcludeBeans().contains(beanName)) {
            DataSource dataSource;
            DataSource decoratedDataSource = dataSource = (DataSource)bean;
            LinkedHashMap decorators = new LinkedHashMap();
            this.applicationContext.getBeansOfType(DataSourceDecorator.class).entrySet().stream().sorted(Map.Entry.comparingByValue(AnnotationAwareOrderComparator.INSTANCE)).forEach(entry -> {
                DataSourceDecorator cfr_ignored_0 = (DataSourceDecorator)decorators.put(entry.getKey(), entry.getValue());
            });
            ArrayList<DataSourceDecorationStage> decoratedDataSourceChainEntries = new ArrayList<DataSourceDecorationStage>();
            for (Map.Entry decoratorEntry : decorators.entrySet()) {
                String decoratorBeanName = (String)decoratorEntry.getKey();
                DataSource dataSourceBeforeDecorating = decoratedDataSource;
                DataSourceDecorator decorator = (DataSourceDecorator)decoratorEntry.getValue();
                if (dataSourceBeforeDecorating == (decoratedDataSource = Objects.requireNonNull(decorator.decorate(beanName, decoratedDataSource), "DataSourceDecorator (" + decoratorBeanName + ", " + decorator + ") should not return null"))) continue;
                decoratedDataSourceChainEntries.add(0, new DataSourceDecorationStage(decoratorBeanName, decorator, decoratedDataSource));
            }
            if (dataSource != decoratedDataSource) {
                ProxyFactory factory = new ProxyFactory(bean);
                factory.setProxyTargetClass(true);
                factory.addInterface(DecoratedDataSource.class);
                factory.addAdvice((Advice)new DataSourceDecoratorInterceptor(beanName, dataSource, decoratedDataSource, decoratedDataSourceChainEntries));
                return factory.getProxy();
            }
        }
        return bean;
    }

    private DataSourceDecoratorProperties getDataSourceDecoratorProperties() {
        if (this.dataSourceDecoratorProperties == null) {
            this.dataSourceDecoratorProperties = (DataSourceDecoratorProperties)this.applicationContext.getBean(DataSourceDecoratorProperties.class);
        }
        return this.dataSourceDecoratorProperties;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

