/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorationStage;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DecoratedDataSource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class DataSourceDecoratorInterceptor
implements MethodInterceptor {
    private String beanName;
    private final DataSource realDataSource;
    private final DataSource decoratedDataSource;
    private final List<DataSourceDecorationStage> decoratingChain;

    DataSourceDecoratorInterceptor(String beanName, DataSource realDataSource, DataSource decoratedDataSource, List<DataSourceDecorationStage> decoratingChain) {
        this.beanName = beanName;
        this.realDataSource = realDataSource;
        this.decoratedDataSource = decoratedDataSource;
        this.decoratingChain = decoratingChain;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getName().equals("getConnection")) {
            if (invocation.getMethod().getParameterCount() == 0) {
                return this.decoratedDataSource.getConnection();
            }
            if (invocation.getMethod().getParameterCount() == 2) {
                return this.decoratedDataSource.getConnection((String)invocation.getArguments()[0], (String)invocation.getArguments()[1]);
            }
        }
        if (invocation.getMethod().getName().equals("toString")) {
            return this.decoratingChain.stream().map(entry -> entry.getBeanName() + " [" + entry.getDataSource().getClass().getName() + "]").collect(Collectors.joining(" -> ")) + " -> " + this.beanName + " [" + this.realDataSource.getClass().getName() + "]";
        }
        if (invocation.getMethod().getDeclaringClass() == DecoratedDataSource.class) {
            if (invocation.getMethod().getName().equals("getRealDataSource")) {
                return this.realDataSource;
            }
            if (invocation.getMethod().getName().equals("getDecoratedDataSource")) {
                return this.decoratedDataSource;
            }
            if (invocation.getMethod().getName().equals("getDecoratingChain")) {
                return Collections.unmodifiableList(this.decoratingChain);
            }
        }
        return invocation.proceed();
    }
}

