/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy;

import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ConnectionIdManagerProvider;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.DataSourceProxyProperties;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.ttddyy.dsproxy.ConnectionIdManager;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryCountStrategy;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.logging.SLF4JLogLevel;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ProxyDataSourceBuilderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ProxyDataSourceBuilderConfigurer.class);
    @Autowired(required=false)
    private QueryCountStrategy queryCountStrategy;
    @Autowired(required=false)
    private List<QueryExecutionListener> listeners;
    @Autowired(required=false)
    private List<MethodExecutionListener> methodExecutionListeners;
    @Autowired(required=false)
    private ParameterTransformer parameterTransformer;
    @Autowired(required=false)
    private QueryTransformer queryTransformer;
    @Autowired(required=false)
    private ResultSetProxyLogicFactory resultSetProxyLogicFactory;
    @Autowired(required=false)
    private ConnectionIdManagerProvider connectionIdManagerProvider;

    public void configure(ProxyDataSourceBuilder proxyDataSourceBuilder, DataSourceProxyProperties datasourceProxy) {
        switch (datasourceProxy.getLogging()) {
            case SLF4J: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryBySlf4j(this.toSlf4JLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryBySlf4j(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toSlf4JLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case JUL: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryByJUL(this.toJULLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryByJUL(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toJULLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case COMMONS: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryByCommons(this.toCommonsLogLevel(datasourceProxy.getQuery().getLogLevel()), datasourceProxy.getQuery().getLoggerName());
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryByCommons(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS, this.toCommonsLogLevel(datasourceProxy.getSlowQuery().getLogLevel()), datasourceProxy.getSlowQuery().getLoggerName());
                break;
            }
            case SYSOUT: {
                if (datasourceProxy.getQuery().isEnableLogging()) {
                    proxyDataSourceBuilder.logQueryToSysOut();
                }
                if (!datasourceProxy.getSlowQuery().isEnableLogging()) break;
                proxyDataSourceBuilder.logSlowQueryToSysOut(datasourceProxy.getSlowQuery().getThreshold(), TimeUnit.SECONDS);
            }
        }
        if (datasourceProxy.isMultiline() && datasourceProxy.isJsonFormat()) {
            log.warn("Found opposite multiline and json format, multiline will be used (may depend on library version)");
        }
        if (datasourceProxy.isMultiline()) {
            proxyDataSourceBuilder.multiline();
        }
        if (datasourceProxy.isJsonFormat()) {
            proxyDataSourceBuilder.asJson();
        }
        if (datasourceProxy.isCountQuery()) {
            proxyDataSourceBuilder.countQuery(this.queryCountStrategy);
        }
        if (this.listeners != null) {
            this.listeners.forEach(arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).listener(arg_0));
        }
        if (this.methodExecutionListeners != null) {
            this.methodExecutionListeners.forEach(arg_0 -> ((ProxyDataSourceBuilder)proxyDataSourceBuilder).methodListener(arg_0));
        }
        if (this.parameterTransformer != null) {
            proxyDataSourceBuilder.parameterTransformer(this.parameterTransformer);
        }
        if (this.queryTransformer != null) {
            proxyDataSourceBuilder.queryTransformer(this.queryTransformer);
        }
        if (this.resultSetProxyLogicFactory != null) {
            proxyDataSourceBuilder.proxyResultSet(this.resultSetProxyLogicFactory);
        }
        if (this.connectionIdManagerProvider != null) {
            proxyDataSourceBuilder.connectionIdManager((ConnectionIdManager)this.connectionIdManagerProvider.get());
        }
    }

    private SLF4JLogLevel toSlf4JLogLevel(String logLevel) {
        if (logLevel == null) {
            return null;
        }
        for (SLF4JLogLevel slf4JLogLevel : SLF4JLogLevel.values()) {
            if (!slf4JLogLevel.name().equalsIgnoreCase(logLevel)) continue;
            return slf4JLogLevel;
        }
        throw new IllegalArgumentException("Unresolved log level " + logLevel + " for slf4j logger, known levels: " + Arrays.toString(SLF4JLogLevel.values()));
    }

    private Level toJULLogLevel(String logLevel) {
        if (logLevel == null) {
            return null;
        }
        try {
            return Level.parse(logLevel);
        }
        catch (IllegalArgumentException e) {
            if (logLevel.equalsIgnoreCase("DEBUG")) {
                return Level.FINE;
            }
            if (logLevel.equalsIgnoreCase("WARN")) {
                return Level.WARNING;
            }
            throw new IllegalArgumentException("Unresolved log level " + logLevel + " for java.util.logging", e);
        }
    }

    private CommonsLogLevel toCommonsLogLevel(String logLevel) {
        if (logLevel == null) {
            return null;
        }
        for (CommonsLogLevel commonsLogLevel : CommonsLogLevel.values()) {
            if (!commonsLogLevel.name().equalsIgnoreCase(logLevel)) continue;
            return commonsLogLevel;
        }
        throw new IllegalArgumentException("Unresolved log level " + logLevel + " for apache commons logger, known levels " + Arrays.toString(CommonsLogLevel.values()));
    }
}

