/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceNameResolver;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.DataSourceProxyProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ProxyDataSourceBuilderConfigurer;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.springframework.core.Ordered;

public class ProxyDataSourceDecorator
implements DataSourceDecorator,
Ordered {
    private final DataSourceDecoratorProperties dataSourceDecoratorProperties;
    private final ProxyDataSourceBuilderConfigurer proxyDataSourceBuilderConfigurer;
    private final DataSourceNameResolver dataSourceNameResolver;

    ProxyDataSourceDecorator(DataSourceDecoratorProperties dataSourceDecoratorProperties, ProxyDataSourceBuilderConfigurer proxyDataSourceBuilderConfigurer, DataSourceNameResolver dataSourceNameResolver) {
        this.dataSourceDecoratorProperties = dataSourceDecoratorProperties;
        this.proxyDataSourceBuilderConfigurer = proxyDataSourceBuilderConfigurer;
        this.dataSourceNameResolver = dataSourceNameResolver;
    }

    @Override
    public DataSource decorate(String beanName, DataSource dataSource) {
        ProxyDataSourceBuilder proxyDataSourceBuilder = ProxyDataSourceBuilder.create();
        DataSourceProxyProperties datasourceProxy = this.dataSourceDecoratorProperties.getDatasourceProxy();
        this.proxyDataSourceBuilderConfigurer.configure(proxyDataSourceBuilder, datasourceProxy);
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(dataSource);
        return proxyDataSourceBuilder.dataSource(dataSource).name(dataSourceName).build();
    }

    public int getOrder() {
        return 20;
    }
}

