/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolConfigurationBuilderCustomizer;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolDataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolProperties;
import com.vladmihalcea.flexypool.FlexyPoolDataSource;
import com.vladmihalcea.flexypool.adaptor.DBCP2PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.HikariCPPoolAdapter;
import com.vladmihalcea.flexypool.adaptor.TomcatCPPoolAdapter;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.event.Event;
import com.vladmihalcea.flexypool.event.EventListener;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.micrometer.MicrometerMetrics;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategyFactory;
import com.vladmihalcea.flexypool.strategy.IncrementPoolOnTimeoutConnectionAcquiringStrategy;
import com.vladmihalcea.flexypool.strategy.RetryConnectionAcquiringStrategy;
import com.vladmihalcea.flexypool.util.ClassLoaderUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class FlexyPoolConfiguration {
    static <T extends javax.sql.DataSource> List<ConnectionAcquiringStrategyFactory<?, T>> mergeFactories(List<ConnectionAcquiringStrategyFactory<?, T>> factories, FlexyPoolProperties flexyPool) {
        FlexyPoolProperties.AcquiringStrategy.Retry retry;
        FlexyPoolProperties.AcquiringStrategy.IncrementPool incrementPool;
        List factoryClasses;
        ArrayList newFactories = new ArrayList();
        if (factories != null) {
            factoryClasses = factories.stream().map(Object::getClass).collect(Collectors.toList());
            newFactories.addAll(factories);
        } else {
            factoryClasses = Collections.emptyList();
        }
        if (!factoryClasses.contains(IncrementPoolOnTimeoutConnectionAcquiringStrategy.Factory.class) && (incrementPool = flexyPool.getAcquiringStrategy().getIncrementPool()).getMaxOverflowPoolSize() > 0) {
            newFactories.add((ConnectionAcquiringStrategyFactory<?, T>)new IncrementPoolOnTimeoutConnectionAcquiringStrategy.Factory(incrementPool.getMaxOverflowPoolSize(), incrementPool.getTimeoutMillis()));
        }
        if (!factoryClasses.contains(RetryConnectionAcquiringStrategy.Factory.class) && (retry = flexyPool.getAcquiringStrategy().getRetry()).getAttempts() > 0) {
            newFactories.add((ConnectionAcquiringStrategyFactory<?, T>)new RetryConnectionAcquiringStrategy.Factory(retry.getAttempts()));
        }
        return newFactories;
    }

    private static class FlexyPoolConfigurationAvailableCondition
    extends SpringBootCondition {
        private FlexyPoolConfigurationAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"FlexyPoolConfigurationAvailable", (Object[])new Object[0]);
            String propertiesFilePath = System.getProperty("flexy.pool.properties.path");
            if (propertiesFilePath != null && ClassLoaderUtils.getResource((String)propertiesFilePath) != null) {
                return ConditionOutcome.match((ConditionMessage)message.found("FlexyPool configuration file").items(new Object[]{propertiesFilePath}));
            }
            if (ClassLoaderUtils.getResource((String)"flexy-pool.properties") != null) {
                return ConditionOutcome.match((ConditionMessage)message.found("FlexyPool configuration file").items(new Object[]{"flexy-pool.properties"}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("FlexyPool configuration file").atAll());
        }
    }

    @Configuration
    @ConditionalOnClass(value={MicrometerMetrics.class})
    static class MicrometerConfiguration {
        MicrometerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MetricsFactory metricsFactory() {
            return MicrometerMetrics.FACTORY;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @Conditional(value={FlexyPoolConfigurationAvailableCondition.class})
    static class PropertyFlexyConfiguration {
        private static final Logger log = LoggerFactory.getLogger(PropertyFlexyConfiguration.class);
        @Autowired(required=false)
        private List<ConnectionAcquiringStrategyFactory<?, javax.sql.DataSource>> connectionAcquiringStrategyFactories;

        PropertyFlexyConfiguration() {
        }

        @PostConstruct
        public void warnIfAnyStrategyFound() {
            if (this.connectionAcquiringStrategyFactories != null) {
                log.warn("ConnectionAcquiringStrategyFactory beans found in the context will not be applied to FlexyDataSource due to property based configuration of FlexyPool");
            }
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={DBCP2PoolAdapter.class})
    @ConditionalOnBean(value={BasicDataSource.class})
    static class Dbcp2FlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquiringStrategyFactory<?, BasicDataSource>> connectionAcquiringStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        Dbcp2FlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquiringStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), DBCP2PoolAdapter.FACTORY, BasicDataSource.class);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={TomcatCPPoolAdapter.class})
    @ConditionalOnBean(value={DataSource.class})
    static class TomcatFlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquiringStrategyFactory<?, DataSource>> connectionAcquiringStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        TomcatFlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquiringStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), TomcatCPPoolAdapter.FACTORY, DataSource.class);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FlexyPoolDataSourceDecorator.class})
    @ConditionalOnClass(value={HikariCPPoolAdapter.class})
    @ConditionalOnBean(value={HikariDataSource.class})
    static class HikariFlexyConfiguration {
        @Autowired(required=false)
        private List<ConnectionAcquiringStrategyFactory<?, HikariDataSource>> connectionAcquiringStrategyFactories;
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        HikariFlexyConfiguration() {
        }

        @Bean
        public FlexyPoolDataSourceDecorator flexyPoolDataSourceDecorator() {
            return new FlexyPoolDataSourceDecorator(FlexyPoolConfiguration.mergeFactories(this.connectionAcquiringStrategyFactories, this.dataSourceDecoratorProperties.getFlexyPool()), HikariCPPoolAdapter.FACTORY, HikariDataSource.class);
        }
    }

    @ConditionalOnMissingBean(value={PropertyFlexyConfiguration.class})
    static class FlexyPoolCustomizerConfiguration {
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;
        @Autowired(required=false)
        private MetricsFactory metricsFactory;
        @Autowired(required=false)
        private ConnectionProxyFactory connectionProxyFactory;
        @Autowired(required=false)
        private List<EventListener<? extends Event>> eventListeners;

        FlexyPoolCustomizerConfiguration() {
        }

        @Bean
        public FlexyPoolConfigurationBuilderCustomizer flexyPoolConfigurationBuilderCustomizer() {
            return (beanName, builder, dataSourceClass) -> {
                FlexyPoolProperties flexyPool = this.dataSourceDecoratorProperties.getFlexyPool();
                builder.setMetricLogReporterMillis(flexyPool.getMetrics().getReporter().getLog().getMillis());
                builder.setJmxEnabled(flexyPool.getMetrics().getReporter().getJmx().isEnabled());
                builder.setJmxAutoStart(flexyPool.getMetrics().getReporter().getJmx().isAutoStart());
                builder.setConnectionAcquireTimeThresholdMillis(Long.valueOf(flexyPool.getThreshold().getConnection().getAcquire()));
                builder.setConnectionLeaseTimeThresholdMillis(Long.valueOf(flexyPool.getThreshold().getConnection().getLease()));
                if (this.metricsFactory != null) {
                    builder.setMetricsFactory(this.metricsFactory);
                }
                if (this.connectionProxyFactory != null) {
                    builder.setConnectionProxyFactory(this.connectionProxyFactory);
                }
                if (this.eventListeners != null) {
                    builder.setEventListenerResolver(() -> this.eventListeners);
                }
            };
        }
    }

    @ConditionalOnClass(value={FlexyPoolDataSource.class})
    @Import(value={MicrometerConfiguration.class, PropertyFlexyConfiguration.class, HikariFlexyConfiguration.class, TomcatFlexyConfiguration.class, Dbcp2FlexyConfiguration.class, FlexyPoolCustomizerConfiguration.class})
    public static class Ordered {
    }
}

