/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool;

import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.flexypool.FlexyPoolConfigurationBuilderCustomizer;
import com.vladmihalcea.flexypool.FlexyPoolDataSource;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.config.Configuration;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategyFactory;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

public class FlexyPoolDataSourceDecorator
implements DataSourceDecorator,
Ordered {
    private final ConnectionAcquiringStrategyFactory<?, DataSource>[] connectionAcquiringStrategyFactories;
    private final PoolAdapterFactory<DataSource> poolAdapterFactory;
    private final Class<DataSource> dataSourceClass;
    @Autowired(required=false)
    private List<FlexyPoolConfigurationBuilderCustomizer> customizers;

    <T extends DataSource> FlexyPoolDataSourceDecorator(List<ConnectionAcquiringStrategyFactory<?, T>> connectionAcquiringStrategyFactories, PoolAdapterFactory<T> poolAdapterFactory, Class<T> dataSourceClass) {
        this.connectionAcquiringStrategyFactories = connectionAcquiringStrategyFactories.toArray(new ConnectionAcquiringStrategyFactory[0]);
        this.poolAdapterFactory = poolAdapterFactory;
        this.dataSourceClass = dataSourceClass;
    }

    FlexyPoolDataSourceDecorator() {
        this.connectionAcquiringStrategyFactories = null;
        this.poolAdapterFactory = null;
        this.dataSourceClass = null;
    }

    @Override
    public DataSource decorate(String beanName, DataSource dataSource) {
        if (this.dataSourceClass == null) {
            FlexyPoolDataSource flexyPoolDataSource = new FlexyPoolDataSource(dataSource);
            flexyPoolDataSource.start();
            return flexyPoolDataSource;
        }
        if (this.dataSourceClass.isInstance(dataSource)) {
            Configuration.Builder configurationBuilder = new Configuration.Builder(beanName, this.dataSourceClass.cast(dataSource), this.poolAdapterFactory);
            if (this.customizers != null) {
                this.customizers.forEach(customizer -> customizer.customize(beanName, configurationBuilder, this.dataSourceClass));
            }
            FlexyPoolDataSource flexyPoolDataSource = new FlexyPoolDataSource(configurationBuilder.build(), this.connectionAcquiringStrategyFactories);
            flexyPoolDataSource.start();
            return flexyPoolDataSource;
        }
        return dataSource;
    }

    public int getOrder() {
        return 10;
    }
}

