/*
 * Decompiled with CFR 0.152.
 */
package com.github.gavlyukovskiy.cloud.sleuth;

import brave.Tracer;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorAutoConfiguration;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceDecoratorProperties;
import com.github.gavlyukovskiy.boot.jdbc.decorator.DataSourceNameResolver;
import com.github.gavlyukovskiy.boot.jdbc.decorator.dsproxy.ProxyDataSourceDecorator;
import com.github.gavlyukovskiy.boot.jdbc.decorator.p6spy.P6SpyDataSourceDecorator;
import com.github.gavlyukovskiy.cloud.sleuth.TracingJdbcEventListener;
import com.github.gavlyukovskiy.cloud.sleuth.TracingQueryExecutionListener;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.proxy.SimpleResultSetProxyLogicFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(name={"decorator.datasource.sleuth.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceDecoratorAutoConfiguration.class}, name={"org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration", "org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration"})
public class SleuthListenerAutoConfiguration {
    public static final String SPAN_SQL_QUERY_TAG_NAME = "sql";
    public static final String SPAN_ROW_COUNT_TAG_NAME = "row-count";
    public static final String SPAN_CONNECTION_POSTFIX = "/connection";
    public static final String SPAN_QUERY_POSTFIX = "/query";
    public static final String SPAN_FETCH_POSTFIX = "/fetch";

    @Configuration
    @ConditionalOnBean(value={ProxyDataSourceDecorator.class})
    @ConditionalOnMissingBean(value={P6SpyConfiguration.class})
    static class ProxyDataSourceConfiguration {
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        ProxyDataSourceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ResultSetProxyLogicFactory resultSetProxyLogicFactory() {
            return new SimpleResultSetProxyLogicFactory();
        }

        @Bean
        public TracingQueryExecutionListener tracingQueryExecutionListener(Tracer tracer) {
            return new TracingQueryExecutionListener(tracer, this.dataSourceDecoratorProperties.getSleuth().getInclude());
        }
    }

    @Configuration
    @ConditionalOnBean(value={P6SpyDataSourceDecorator.class})
    static class P6SpyConfiguration {
        @Autowired
        private DataSourceDecoratorProperties dataSourceDecoratorProperties;

        P6SpyConfiguration() {
        }

        @Bean
        public TracingJdbcEventListener tracingJdbcEventListener(Tracer tracer, DataSourceNameResolver dataSourceNameResolver) {
            return new TracingJdbcEventListener(tracer, dataSourceNameResolver, this.dataSourceDecoratorProperties.getSleuth().getInclude(), this.dataSourceDecoratorProperties.getP6spy().getTracing().isIncludeParameterValues());
        }
    }
}

